/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller;

import com.ebaiyihui.ca.server.common.enums.CASignSceneEnum;
import com.ebaiyihui.ca.server.common.properties.HTProperties;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.entity.HtSignRecord;
import com.ebaiyihui.ca.server.pojo.vo.ht.ActivationCodeVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.dto.AutoSignReqDTO;
import com.ebaiyihui.ca.server.pojo.vo.ht.dto.AutoSignRespDTO;
import com.ebaiyihui.ca.server.pojo.vo.ht.dto.EndAutoSignReqDTO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.AddSignJobAndGetResultReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.AutoSignReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CheckFaceIdReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CheckUserIdentityReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.AddSignJobAndGetResultRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.AutoSignRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.EndAutoSignRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.StartAutoSignRespVO;
import com.ebaiyihui.ca.server.service.HTCAService;
import com.ebaiyihui.ca.server.service.HtSignRecordService;
import com.ebaiyihui.ca.server.third.HTCACossHelper;
import com.ebaiyihui.ca.server.utils.QRCodeUtil;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ning.http.util.Base64;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.JedisCluster;

@RestController
@RequestMapping(value={"/api/ht/"})
@Api(tags={"\u822a\u5929CA-API"})
public class HTCAController {
    private static final Logger log = LoggerFactory.getLogger(HTCAController.class);
    private static final String SUCCESS_IDENTIFICATION = "SUCCESS";
    private static int UNAUTHORIZED_STATUS_UNSIGNED = 89004025;
    private static int UNAUTHORIZED_STATUS_EXPIRED = 89004071;
    @Autowired
    private HtSignRecordService htSignRecordService;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private HTCACossHelper htcaCossHelper;
    @Autowired
    private HTProperties htProperties;
    @Autowired
    private HTCAService hTCAService;

    @ApiOperation(value="\u6821\u9a8c\u7528\u6237\u8eab\u4efd\u4fe1\u606f", notes="\u6821\u9a8c\u7528\u6237\u8eab\u4efd\u4fe1\u606f")
    @PostMapping(value={"checkUserIdentity"})
    public BaseResponse checkUserIdentity(@RequestBody @Valid CheckUserIdentityReqVO checkUserIdentityReqVO) {
        this.hTCAService.checkUserIdentity(checkUserIdentityReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4e24\u9879\u5b9e\u4eba\u6821\u9a8c\uff08\u6d3b\u4f53\u6821\u9a8c\uff09\u4ee5\u53ca\u6fc0\u6d3b\u7801\u83b7\u53d6", notes="\u4e24\u9879\u5b9e\u4eba\u6821\u9a8c\uff08\u6d3b\u4f53\u6821\u9a8c\uff09\u4ee5\u53ca\u6fc0\u6d3b\u7801\u83b7\u53d6")
    @PostMapping(value={"checkFaceIdAndGetActivationCode"})
    public BaseResponse<ActivationCodeVO> checkFaceIdAndGetActivationCode(@RequestBody @Valid CheckFaceIdReqVO checkFaceIdReqVO) {
        ActivationCodeVO activationCodeVO = this.hTCAService.checkFaceIdAndGetActivationCode(checkFaceIdReqVO);
        return BaseResponse.success((Object)activationCodeVO);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7b7e\u540d\u4efb\u52a1\u5e76\u83b7\u53d6\u7ed3\u679c", notes="\u6dfb\u52a0\u7b7e\u540d\u4efb\u52a1\u5e76\u83b7\u53d6\u7ed3\u679c")
    @PostMapping(value={"addSignJobAndGetResult"})
    public BaseResponse<AddSignJobAndGetResultRespVO> addSignJobAndGetResult(@RequestBody @Valid AddSignJobAndGetResultReqVO addSignJobAndGetResultReqVO) {
        AddSignJobAndGetResultRespVO addSignJobAndGetResultRespVO = this.hTCAService.addSignJobAndGetResult(addSignJobAndGetResultReqVO);
        return BaseResponse.success((Object)addSignJobAndGetResultRespVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b7e\u7ae0", notes="\u83b7\u53d6\u7b7e\u7ae0")
    @GetMapping(value={"getStamp"})
    public BaseResponse<String> getStamp(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="appCode") String appCode) {
        String base64Stamp = this.hTCAService.getStamp(doctorId, appCode);
        return BaseResponse.success((Object)base64Stamp);
    }

    @ApiOperation(value="\u67e5\u8be2userId", notes="\u67e5\u8be2userId")
    @GetMapping(value={"getUserId"})
    public BaseResponse<String> getUserId(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="appCode") String appCode) {
        String userId = this.hTCAService.getUserId(doctorId, appCode);
        return BaseResponse.success((Object)userId);
    }

    @ApiOperation(value="web\u7aef\u81ea\u52a8\u7b7e\u540d", notes="web\u7aef\u81ea\u52a8\u7b7e\u540d")
    @PostMapping(value={"autoSign"})
    public BaseResponse<AutoSignRespDTO> autoSign(@RequestBody @Valid AutoSignReqDTO autoSignReqDTO) {
        String appCode = autoSignReqDTO.getAppCode();
        String doctorId = autoSignReqDTO.getDoctorId();
        Integer signSceneCode = autoSignReqDTO.getSignSceneCode();
        String toBeSignedData = autoSignReqDTO.getToBeSignedData();
        String msspId = this.hTCAService.getUserId(doctorId, appCode);
        String signToken = this.jedisCluster.get(doctorId);
        if (signToken == null || "".equals(signToken)) {
            AutoSignRespDTO autoSignRespDTO = this.getAutoSignRespDTO(doctorId, msspId);
            return BaseResponse.success((Object)autoSignRespDTO);
        }
        AutoSignReqVO autoSignReqVO = new AutoSignReqVO();
        autoSignReqVO.setUserId(msspId);
        autoSignReqVO.setSignToken(signToken);
        autoSignReqVO.setToBeSignedData(toBeSignedData);
        AutoSignRespVO autoSignRespVO = this.htcaCossHelper.autoSign(autoSignReqVO);
        String message = autoSignRespVO.getMessage();
        int status = autoSignRespVO.getStatus();
        if (UNAUTHORIZED_STATUS_UNSIGNED == status) {
            AutoSignRespDTO autoSignRespDTO = this.getAutoSignRespDTO(doctorId, msspId);
            log.info("\u81ea\u52a8\u7b7etoken\u5bf9\u5e94\u7b7e\u540d\u4efb\u52a1\u672a\u7b7e\u7f72\uff0csignToken \u4e3a\uff1a{}", (Object)signToken);
            log.info("\u81ea\u52a8\u7b7etoken\u5bf9\u5e94\u7b7e\u540d\u4efb\u52a1\u672a\u7b7e\u7f72\uff0cmsspId \u4e3a\uff1a{}", (Object)msspId);
            return BaseResponse.success((Object)autoSignRespDTO);
        }
        if (UNAUTHORIZED_STATUS_EXPIRED == status) {
            AutoSignRespDTO autoSignRespDTO = this.getAutoSignRespDTO(doctorId, msspId);
            log.info("\u81ea\u52a8\u7b7e\u672a\u5f00\u542f\u6216\u5df2\u8fc7\u671f(\u8be5\u7528\u6237\u672a\u5f00\u542f\u81ea\u52a8\u7b7e\u6216\u81ea\u52a8\u7b7e\u5df2\u8fc7\u671f)\uff0csignToken \u4e3a\uff1a{}", (Object)signToken);
            log.info("\u81ea\u52a8\u7b7e\u672a\u5f00\u542f\u6216\u5df2\u8fc7\u671f(\u8be5\u7528\u6237\u672a\u5f00\u542f\u81ea\u52a8\u7b7e\u6216\u81ea\u52a8\u7b7e\u5df2\u8fc7\u671f)\uff0cmsspId \u4e3a\uff1a{}", (Object)msspId);
            return BaseResponse.success((Object)autoSignRespDTO);
        }
        if (!SUCCESS_IDENTIFICATION.equals(message)) {
            throw new BusinessException("\u81ea\u52a8\u7b7e\u540d\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01" + message);
        }
        AutoSignRespVO.DataBean signRespVOData = autoSignRespVO.getData();
        String signCert = signRespVOData.getSignCert();
        String signResult = signRespVOData.getSignResult();
        String signDataId = signRespVOData.getSignDataId();
        HtSignRecord htSignRecord = new HtSignRecord();
        htSignRecord.setStatus(Integer.valueOf(1));
        htSignRecord.setViewId(UUIDUtils.getUUID());
        htSignRecord.setUserId(msspId);
        htSignRecord.setSignDataId(signDataId);
        htSignRecord.setSignData(toBeSignedData);
        htSignRecord.setSignature(signResult);
        htSignRecord.setCert(signCert);
        htSignRecord.setSignId(signDataId);
        if (CASignSceneEnum.CA_PRESCRIPT.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_PRESCRIPT.getDesc());
        } else if (CASignSceneEnum.CA_CHECK_PRESCRIPT.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_CHECK_PRESCRIPT.getDesc());
        } else if (CASignSceneEnum.CA_REFERRAL.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_REFERRAL.getDesc());
        } else if (CASignSceneEnum.CA_CHECK_PRESCRIPT_REFUSE.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_CHECK_PRESCRIPT_REFUSE.getDesc());
        } else {
            throw new BusinessException("\u4e1a\u52a1\u573a\u666fcode\u9519\u8bef\uff01");
        }
        htSignRecord.setSignSceneCode(signSceneCode);
        this.htSignRecordService.save(htSignRecord);
        AutoSignRespDTO autoSignRespDTO = new AutoSignRespDTO();
        autoSignRespDTO.setType("20");
        String stampUrl = this.hTCAService.getStamp(doctorId, appCode);
        autoSignRespDTO.setData(stampUrl);
        return BaseResponse.success((Object)autoSignRespDTO);
    }

    private AutoSignRespDTO getAutoSignRespDTO(String doctorId, String msspId) {
        StartAutoSignRespVO startAutoSignRespVO = this.htcaCossHelper.startAutoSign(msspId, this.htProperties.getTimeRegion());
        String message = startAutoSignRespVO.getMessage();
        if (!SUCCESS_IDENTIFICATION.equals(message)) {
            throw new BusinessException("\u5f00\u542f\u81ea\u52a8\u7b7e\u540d\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01" + message);
        }
        StartAutoSignRespVO.DataBean data = startAutoSignRespVO.getData();
        String signDataId = data.getSignDataId();
        String base64Image = this.getBase64QrCode(signDataId);
        this.jedisCluster.set(doctorId, signDataId);
        this.jedisCluster.expire(doctorId, 2100);
        AutoSignRespDTO autoSignRespDTO = new AutoSignRespDTO();
        autoSignRespDTO.setType("10");
        autoSignRespDTO.setData(base64Image);
        return autoSignRespDTO;
    }

    private String getBase64QrCode(String signDataId) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = QRCodeUtil.encode((String)signDataId, null, (String)"", (boolean)true);
        }
        catch (Exception e) {
            log.error("\u6388\u6743\u4e8c\u7ef4\u7801\u751f\u6210\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u6388\u6743\u4e8c\u7ef4\u7801\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", stream);
        }
        catch (IOException e) {
            log.error("\u6388\u6743\u4e8c\u7ef4\u7801\u8f6cbase64\u4f4d\u56fe\u7247\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u6388\u6743\u4e8c\u7ef4\u7801\u8f6cbase64\u4f4d\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
        }
        return Base64.encode((byte[])stream.toByteArray());
    }

    @ApiOperation(value="web\u7aef\u5173\u95ed\u81ea\u52a8\u7b7e\u540d", notes="web\u7aef\u5173\u95ed\u81ea\u52a8\u7b7e\u540d")
    @PostMapping(value={"endAutoSign"})
    public BaseResponse endAutoSign(@RequestBody @Valid EndAutoSignReqDTO endAutoSignReqDTO) {
        String appCode = endAutoSignReqDTO.getAppCode();
        String doctorId = endAutoSignReqDTO.getDoctorId();
        String signToken = this.jedisCluster.get(doctorId);
        if (signToken == null || "".equals(signToken)) {
            return BaseResponse.success();
        }
        this.jedisCluster.del(doctorId);
        String msspId = this.hTCAService.getUserId(doctorId, appCode);
        EndAutoSignRespVO endAutoSignRespVO = this.htcaCossHelper.endAutoSign(msspId);
        String message = endAutoSignRespVO.getMessage();
        if (SUCCESS_IDENTIFICATION.equals(message)) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)message);
    }
}

