/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller;

import com.ebaiyihui.ca.server.common.enums.CASignSceneEnum;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.entity.HtSignRecord;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.SaveHtSignRecordReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.VerifySignReqVO;
import com.ebaiyihui.ca.server.service.HtSignRecordService;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ht/record/"})
@Api(tags={"\u822a\u5929CA-API\uff08\u7b7e\u540d\u8bb0\u5f55\u8868\uff09"})
public class HtSignRecordController {
    @Autowired
    private HtSignRecordService htSignRecordService;

    @ApiOperation(value="\u62a5\u9519\u7b7e\u540d\u8bb0\u5f55", notes="\u4fdd\u5b58\u7b7e\u540d\u8bb0\u5f55")
    @PostMapping(value={"saveHtSignRecord"})
    public BaseResponse saveHtSignRecord(@RequestBody @Valid SaveHtSignRecordReqVO saveHtSignRecordReqVO) {
        HtSignRecord htSignRecord = new HtSignRecord();
        BeanUtils.copyProperties((Object)saveHtSignRecordReqVO, (Object)htSignRecord);
        htSignRecord.setStatus(Integer.valueOf(1));
        htSignRecord.setViewId(UUIDUtils.getUUID());
        Integer signSceneCode = saveHtSignRecordReqVO.getSignSceneCode();
        if (CASignSceneEnum.CA_PRESCRIPT.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_PRESCRIPT.getDesc());
        } else if (CASignSceneEnum.CA_CHECK_PRESCRIPT.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_CHECK_PRESCRIPT.getDesc());
        } else if (CASignSceneEnum.CA_REFERRAL.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_REFERRAL.getDesc());
        } else if (CASignSceneEnum.CA_CHECK_PRESCRIPT_REFUSE.getValue().equals(signSceneCode)) {
            htSignRecord.setSignSceneName(CASignSceneEnum.CA_CHECK_PRESCRIPT_REFUSE.getDesc());
        } else {
            throw new BusinessException("\u4e1a\u52a1\u573a\u666fcode\u9519\u8bef\uff01");
        }
        htSignRecord.setSignSceneCode(signSceneCode);
        this.htSignRecordService.save(htSignRecord);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u6821\u9a8c\u7b7e\u540d\u8bb0\u5f55", notes="\u6821\u9a8c\u7b7e\u540d\u8bb0\u5f55")
    @PostMapping(value={"verifySign"})
    public BaseResponse verifySign(@RequestBody @Valid VerifySignReqVO verifySignReqVO) {
        this.htSignRecordService.verifySign(verifySignReqVO);
        return BaseResponse.success();
    }
}

