/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.ca.server.pojo.szvo.RandomNumberResponseVo;
import com.ebaiyihui.ca.server.pojo.szvo.SendCodeResponseVo;
import com.ebaiyihui.ca.server.pojo.szvo.SupApplyPersonReqVo;
import com.ebaiyihui.ca.server.pojo.szvo.SupApplyPersonResponseVo;
import com.ebaiyihui.ca.server.pojo.szvo.VerifyCodeRequestVo;
import com.ebaiyihui.ca.server.pojo.szvo.VerifyCodeResponseVo;
import com.ebaiyihui.ca.server.pojo.szvo.VerifySignReqVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.SzCaEditPasswordReqVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.SzCaSaveSignReqVo;
import com.ebaiyihui.ca.server.service.impl.SzCertService;
import com.ebaiyihui.ca.server.third.szca.PersonCertSign;
import com.ebaiyihui.ca.server.third.szca.SupApplyPersonCert;
import com.ebaiyihui.ca.server.utils.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sz"})
@Api(tags={"\u6df1\u5733CA\u76f8\u5173API"})
public class SZCAController {
    @Autowired
    private SupApplyPersonCert supApplyPersonCert;
    @Autowired
    private PersonCertSign personCertSign;
    @Autowired
    private SzCertService szCertService;

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getVerificationCode"})
    public BaseResponse<SendCodeResponseVo> getVerificationCode(@RequestParam(value="phone") String phone) {
        SendCodeResponseVo verificationCode = this.personCertSign.getVerificationCode(phone);
        return BaseResponse.success((Object)verificationCode);
    }

    @ApiOperation(value="\u6821\u9a8c\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/verify"})
    public BaseResponse<VerifyCodeResponseVo> verify(@RequestBody VerifyCodeRequestVo verifyCodeRequestVo) {
        VerifyCodeResponseVo verify = this.personCertSign.verify(verifyCodeRequestVo);
        return BaseResponse.success((Object)verify);
    }

    @ApiOperation(value="\u83b7\u53d6\u53e3\u4ee4")
    @GetMapping(value={"/getRandomNumber"})
    public BaseResponse<RandomNumberResponseVo> getRandomNumber() {
        RandomNumberResponseVo randomNumber = this.supApplyPersonCert.getRandomNumber();
        return BaseResponse.success((Object)randomNumber);
    }

    @ApiOperation(value="\u4e2a\u4eba\u8bc1\u4e66\u8ba4\u8bc1")
    @PostMapping(value={"/supApplyPerson"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse<SupApplyPersonResponseVo> supApplyPerson(HttpServletRequest httpServletRequest, @RequestParam(value="supApplyPersonReqVo") String supApplyPersonReqVo, @RequestParam(value="file") MultipartFile file) {
        SupApplyPersonReqVo applyPersonReqVo = (SupApplyPersonReqVo)JSONObject.parseObject((String)supApplyPersonReqVo, SupApplyPersonReqVo.class);
        SupApplyPersonResponseVo supApplyPersonResponseVo = this.supApplyPersonCert.supApplyPerson(file, applyPersonReqVo);
        supApplyPersonResponseVo.setMsg(StringUtil.clearBracket((String)supApplyPersonResponseVo.getMsg()));
        return BaseResponse.success((Object)supApplyPersonResponseVo);
    }

    @PostMapping(value={"/verifySign"})
    @ApiOperation(value="\u7b7e\u540d\u63a5\u53e3")
    public BaseResponse<RandomNumberResponseVo> verifySign(@RequestBody VerifySignReqVo verifySignReqVo) {
        RandomNumberResponseVo randomNumberResponseVo = this.supApplyPersonCert.verifySign(verifySignReqVo);
        return BaseResponse.success((Object)randomNumberResponseVo);
    }

    @GetMapping(value={"/getDoctorCert"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7b7e\u7ae0\u5bc6\u7801\u72b6\u6001")
    public BaseResponse getDoctorCert(@RequestParam(value="doctorId") Long doctorId) {
        return this.szCertService.getDoctorCert(doctorId);
    }

    @ApiOperation(value="\u7528\u6237\u8bbe\u7f6e\u5bc6\u7801")
    @PostMapping(value={"/editPassword"})
    public BaseResponse editPassword(@RequestBody SzCaEditPasswordReqVo szCaEditPasswordReqVo) {
        return this.szCertService.editPassword(szCaEditPasswordReqVo);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u7b7e\u8bc1\u5bc6\u7801")
    @PostMapping(value={"/certLogin"})
    public BaseResponse certLogin(@RequestBody SzCaEditPasswordReqVo szCaEditPasswordReqVo) {
        return this.szCertService.certLogin(szCaEditPasswordReqVo);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7b7e\u7ae0")
    @PostMapping(value={"/saveSign"})
    public BaseResponse saveSign(@RequestHeader(value="appCode") String appCode, @RequestBody SzCaSaveSignReqVo szCaSaveSignReqVo) {
        return this.szCertService.saveSign(appCode, szCaSaveSignReqVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b7e\u7ae0")
    @GetMapping(value={"/getSign"})
    public BaseResponse getSign(@RequestHeader(value="appCode") String appCode, @RequestParam(value="doctorId") Long doctorId) {
        return this.szCertService.getSign(appCode, doctorId);
    }

    @ApiOperation(value="\u65b0\u7684\u8bbe\u7f6e\u7b7e\u7ae0")
    @PostMapping(value={"/newSaveSign"})
    public BaseResponse newSaveSign(@RequestHeader(value="appCode") String appCode, @RequestBody SzCaSaveSignReqVo szCaSaveSignReqVo) {
        return this.szCertService.newSaveSign(appCode, szCaSaveSignReqVo);
    }
}

