/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller.app;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.ca.server.config.MzCaConfig;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IDoctorApiClient;
import com.ebaiyihui.ca.server.feign.IhospitalApiClient;
import com.ebaiyihui.ca.server.pojo.EmpowerReqVO;
import com.ebaiyihui.ca.server.pojo.GetAuthorizeCodeReqVO;
import com.ebaiyihui.ca.server.pojo.GetMzjhUserInfoReqVO;
import com.ebaiyihui.ca.server.pojo.MzjhCertRespVO;
import com.ebaiyihui.ca.server.pojo.MzjhUserRespVO;
import com.ebaiyihui.ca.server.pojo.SetHandwrittenSignatureReqVO;
import com.ebaiyihui.ca.server.pojo.entity.MzjhCert;
import com.ebaiyihui.ca.server.pojo.entity.MzjhUser;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.AuthorizeReqVO;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.AuthorizeRespVO;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.UserRegisterAndUpdateReqVO;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.UserStatusReqVO;
import com.ebaiyihui.ca.server.service.MzjhCertService;
import com.ebaiyihui.ca.server.service.MzjhUserService;
import com.ebaiyihui.ca.server.third.mzjh.MzRequestHelper;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/mzjh/user"})
@Api(tags={"\u7f8e\u4e2d\u5609\u548capp\u7aef\u76f8\u5173\u63a5\u53e3"})
public class AppMzjhUserController {
    private static final Logger log = LoggerFactory.getLogger(AppMzjhUserController.class);
    private static final String MZJH_APP_CODE = "MZJH";
    private static final String YYHT_APP_CODE = "YYHT";
    @Autowired
    private MzRequestHelper mzRequestHelper;
    @Autowired
    private MzCaConfig mzCaConfig;
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private MzjhUserService mzjhUserService;
    @Autowired
    private MzjhCertService mzjhCertService;

    @ApiOperation(value="\u6388\u6743\u63a5\u53e3", notes="\u6388\u6743\u63a5\u53e3")
    @PostMapping(value={"/register/empower"})
    public BaseResponse empower(@Validated @RequestBody EmpowerReqVO empowerReqVO) {
        Long organId;
        Long doctorId = empowerReqVO.getDoctorId();
        MzjhUser tbMzUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = empowerReqVO.getOrganId());
        if (tbMzUser != null) {
            throw new BusinessException("\u60a8\u5df2\u6388\u6743\uff0c\u65e0\u9700\u91cd\u590d\u6388\u6743\uff01");
        }
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(doctorId.intValue()));
        BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        if (doctorEntityInfoVOBaseResponse == null || doctorEntityInfoVOBaseResponse.getData() == null) {
            throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
        }
        DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
        QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
        queryOrganDetailDTO.setOrganId(Integer.valueOf(organId.intValue()));
        BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
        if (organDetailVOBaseResponse == null || organDetailVOBaseResponse.getData() == null) {
            throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
        }
        QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
        String tbOrganId = organDetailVO.getOrganId();
        if (!organId.equals(Long.valueOf(tbOrganId))) {
            log.info("\u7528\u6237\u4e2d\u5fc3\u7684organId{}", (Object)tbOrganId);
            throw new BusinessException("\u533b\u9662\u4fe1\u606f\u4e0d\u5339\u914d\uff01");
        }
        String appCode = organDetailVO.getAppCode();
        if (!MZJH_APP_CODE.equals(appCode) && !YYHT_APP_CODE.equals(appCode)) {
            throw new BusinessException("\u6388\u6743\u9519\u8bef\uff0c\u533b\u751f\u4fe1\u606f\u4e0e\u533b\u9662\u4e0d\u5339\u914d\uff01");
        }
        MzjhUser mzjhUser = new MzjhUser();
        mzjhUser.setOrganId(organId);
        mzjhUser.setDoctorId(doctorId);
        mzjhUser.setAppId(this.mzCaConfig.getAppId());
        String registerMobile = doctorEntityInfoVO.getRegisterMobile();
        mzjhUser.setIdentityId(registerMobile);
        String name = doctorEntityInfoVO.getName();
        mzjhUser.setUserName(name);
        mzjhUser.setUserStatusCode(UserStatusReqVO.UserStatus.disable.getCode());
        mzjhUser.setUserStatusName(UserStatusReqVO.UserStatus.disable.getName());
        mzjhUser.setIdNoType(Integer.valueOf(1));
        String credNo = doctorEntityInfoVO.getCredNo();
        mzjhUser.setIdNo(credNo);
        mzjhUser.setTelephone(registerMobile);
        UserRegisterAndUpdateReqVO userRegisterAndUpdateReqVO = new UserRegisterAndUpdateReqVO(this.mzCaConfig.getPrivateKey());
        userRegisterAndUpdateReqVO.setAppId(mzjhUser.getAppId());
        userRegisterAndUpdateReqVO.setId(mzjhUser.getIdentityId());
        userRegisterAndUpdateReqVO.setUserName(mzjhUser.getUserName());
        userRegisterAndUpdateReqVO.setIdNoType(mzjhUser.getIdNoType());
        userRegisterAndUpdateReqVO.setIdNo(mzjhUser.getIdNo());
        userRegisterAndUpdateReqVO.setTelephone(mzjhUser.getTelephone());
        userRegisterAndUpdateReqVO.setEmail("");
        this.mzjhUserService.empower(mzjhUser, userRegisterAndUpdateReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @PostMapping(value={"/getMzjhUserInfo"})
    public BaseResponse<MzjhUserRespVO> getMzjhUserInfo(@Validated @RequestBody GetMzjhUserInfoReqVO getMzjhUserInfoReqVO) {
        Long organId;
        Long doctorId = getMzjhUserInfoReqVO.getDoctorId();
        MzjhUser mzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = getMzjhUserInfoReqVO.getOrganId());
        if (mzjhUser == null) {
            return BaseResponse.success();
        }
        MzjhCert cert = this.mzjhCertService.getCertByDoctorIdAndOrganId(doctorId, organId);
        MzjhUserRespVO mzjhUserRespVO = new MzjhUserRespVO();
        mzjhUserRespVO.setMzjhUser(mzjhUser);
        if (cert != null) {
            MzjhCertRespVO mzjhCertRespVO = new MzjhCertRespVO();
            BeanUtils.copyProperties((Object)cert, (Object)mzjhCertRespVO);
            String endDate = cert.getEndDate();
            DateTime parseEndDate = DateUtil.parse((String)endDate);
            Date currentDate = new Date();
            long effectiveDays = DateUtil.betweenDay((Date)currentDate, (Date)parseEndDate, (boolean)true);
            if (parseEndDate.isBefore(currentDate)) {
                effectiveDays = -effectiveDays;
            }
            mzjhCertRespVO.setEffectiveDays(Long.valueOf(effectiveDays));
            mzjhUserRespVO.setMzjhCert(mzjhCertRespVO);
        }
        return BaseResponse.success((Object)mzjhUserRespVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u7801\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u7801\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @PostMapping(value={"/getAppAuthorizeCode"})
    public BaseResponse<String> getAppAuthorizeCode(@Validated @RequestBody GetAuthorizeCodeReqVO getAuthorizeCodeReqVO) {
        AuthorizeReqVO authorizeReqVO = new AuthorizeReqVO(this.mzCaConfig.getPrivateKey());
        authorizeReqVO.setBusinessCode(getAuthorizeCodeReqVO.getBusinessCode());
        authorizeReqVO.setAppId(getAuthorizeCodeReqVO.getAppId());
        authorizeReqVO.setDate(LocalDateTime.now());
        AuthorizeRespVO appAuthorizeCode = this.mzRequestHelper.getAppAuthorizeCode(authorizeReqVO);
        int ret = appAuthorizeCode.getRet();
        if (0 == ret) {
            AuthorizeRespVO.DataBean data = appAuthorizeCode.getData();
            String code = data.getCode();
            return BaseResponse.success((Object)code);
        }
        String msg = appAuthorizeCode.getMsg();
        return BaseResponse.error((String)msg);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u624b\u5199\u7b7e\u540d\u56fe\u7247\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u8bbe\u7f6e\u624b\u5199\u7b7e\u540d\u56fe\u7247\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @PostMapping(value={"/setHandwrittenSignature"})
    public BaseResponse setHandwrittenSignature(@Validated @RequestBody SetHandwrittenSignatureReqVO setHandwrittenSignatureReqVO) {
        Long doctorId = setHandwrittenSignatureReqVO.getDoctorId();
        Long organId = setHandwrittenSignatureReqVO.getOrganId();
        String handwrittenSignatureUrl = setHandwrittenSignatureReqVO.getHandwrittenSignatureUrl();
        MzjhUser mzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId);
        if (mzjhUser == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        mzjhUser.setHandwrittenSignatureUrl(handwrittenSignatureUrl);
        this.mzjhUserService.updateUser(mzjhUser);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u624b\u5199\u7b7e\u540d\u56fe\u7247\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09", notes="\u67e5\u8be2\u624b\u5199\u7b7e\u540d\u56fe\u7247\uff08app\u7aef\u8c03\u7528\u63a5\u53e3\uff09")
    @GetMapping(value={"/getHandwrittenSignature"})
    public BaseResponse getHandwrittenSignature(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="organId") Long organId) {
        MzjhUser mzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId);
        if (mzjhUser == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return BaseResponse.success((Object)mzjhUser.getHandwrittenSignatureUrl());
    }
}

