/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller.rpc;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.ca.client.RpcClient;
import com.ebaiyihui.ca.server.pojo.entity.MzjhCert;
import com.ebaiyihui.ca.server.pojo.entity.MzjhUser;
import com.ebaiyihui.ca.server.service.MzjhCertService;
import com.ebaiyihui.ca.server.service.MzjhUserService;
import com.ebaiyihui.ca.vo.UserCertInfoReqVO;
import com.ebaiyihui.ca.vo.UserCertInfoRespVO;
import com.ebaiyihui.ca.vo.UserCertificationStatusQueryVO;
import com.ebaiyihui.ca.vo.UserCertificationStatusReqVO;
import com.ebaiyihui.ca.vo.UserCertificationStatusRespVO;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ed9\u4e1a\u52a1\u670d\u52a1\u63d0\u4f9b\u7684\u63a5\u53e3"})
public class RpcController
implements RpcClient {
    @Autowired
    private MzjhCertService mzjhCertService;
    @Autowired
    private MzjhUserService mzjhUserService;

    public List<UserCertificationStatusRespVO> getUserCertificationStatusInfo(@RequestBody UserCertificationStatusReqVO userCertificationStatusReqVO) {
        ArrayList<UserCertificationStatusRespVO> userCertificationStatusRespVOList = new ArrayList<UserCertificationStatusRespVO>();
        List certificationStatusQueryVOList = userCertificationStatusReqVO.getUserCertificationStatusQueryVOList();
        if (certificationStatusQueryVOList != null && certificationStatusQueryVOList.size() > 0) {
            for (UserCertificationStatusQueryVO userCertificationStatusQueryVO : certificationStatusQueryVOList) {
                Long doctorId = userCertificationStatusQueryVO.getDoctorId();
                Long organId = userCertificationStatusQueryVO.getOrganId();
                UserCertificationStatusRespVO userCertificationStatusRespVO = this.mzjhUserService.getUserCertificationStatus(doctorId, organId);
                userCertificationStatusRespVOList.add(userCertificationStatusRespVO);
            }
        }
        return userCertificationStatusRespVOList;
    }

    public UserCertInfoRespVO getUserCertInfo(@RequestBody UserCertInfoReqVO userCertInfoReqVO) {
        Long organId;
        Long doctorId = userCertInfoReqVO.getDoctorId();
        MzjhUser mzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = userCertInfoReqVO.getOrganId());
        if (mzjhUser == null) {
            return null;
        }
        MzjhCert mzjhCert = this.mzjhCertService.getCertByDoctorIdAndOrganId(doctorId, organId);
        UserCertInfoRespVO userCertInfoRespVO = new UserCertInfoRespVO();
        if (mzjhCert == null) {
            userCertInfoRespVO.setUserStatusCode(mzjhUser.getUserStatusCode());
            userCertInfoRespVO.setUserStatusName(mzjhUser.getUserStatusName());
            userCertInfoRespVO.setHandwrittenSignatureUrl(mzjhUser.getHandwrittenSignatureUrl());
            return userCertInfoRespVO;
        }
        BeanUtils.copyProperties((Object)mzjhCert, (Object)userCertInfoRespVO);
        String endDate = mzjhCert.getEndDate();
        long effectiveDays = DateUtil.betweenDay((Date)new Date(), (Date)DateUtil.parse((String)endDate), (boolean)true);
        userCertInfoRespVO.setEffectiveDays(Long.valueOf(effectiveDays));
        userCertInfoRespVO.setUserStatusCode(mzjhUser.getUserStatusCode());
        userCertInfoRespVO.setUserStatusName(mzjhUser.getUserStatusName());
        userCertInfoRespVO.setHandwrittenSignatureUrl(mzjhUser.getHandwrittenSignatureUrl());
        return userCertInfoRespVO;
    }
}

