/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.controller.web;

import com.ebaiyihui.ca.server.config.MzCaConfig;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.DisableReqVO;
import com.ebaiyihui.ca.server.pojo.EnableReqVO;
import com.ebaiyihui.ca.server.pojo.entity.MzjhUser;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.UserStatusReqVO;
import com.ebaiyihui.ca.server.service.MzjhUserService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/web/mzjh"})
@Api(tags={"\u7f8e\u4e2d\u5609\u548cweb\u7aef\u76f8\u5173\u63a5\u53e3"})
public class WebMzjhUserController {
    @Autowired
    private MzCaConfig mzCaConfig;
    @Autowired
    private MzjhUserService mzjhUserService;

    @ApiOperation(value="\u542f\u7528\uff08\u6539\u7528\u6237\u72b6\u6001\uff09", notes="\u542f\u7528\uff08\u6539\u7528\u6237\u72b6\u6001\uff09")
    @PostMapping(value={"/enable"})
    public BaseResponse enable(@Validated @RequestBody EnableReqVO enableReqVO) {
        Long organId;
        Long doctorId = enableReqVO.getDoctorId();
        MzjhUser tbMzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = enableReqVO.getOrganId());
        if (tbMzjhUser == null) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (UserStatusReqVO.UserStatus.enable.getCode().equals(tbMzjhUser.getUserStatusCode())) {
            throw new BusinessException("\u7528\u6237\u5df2\u542f\u7528\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c\uff01");
        }
        UserStatusReqVO userStatusReqVO = new UserStatusReqVO(this.mzCaConfig.getPrivateKey());
        userStatusReqVO.setAppId(this.mzCaConfig.getAppId());
        userStatusReqVO.setId(tbMzjhUser.getTelephone());
        userStatusReqVO.setStatus(UserStatusReqVO.UserStatus.enable);
        this.mzjhUserService.enable(tbMzjhUser, userStatusReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u505c\u7528\uff08\u6539\u7528\u6237\u72b6\u6001\uff09", notes="\u505c\u7528\uff08\u6539\u7528\u6237\u72b6\u6001\uff09")
    @PostMapping(value={"/disable"})
    public BaseResponse disable(@Validated @RequestBody DisableReqVO disableReqVO) {
        Long organId;
        Long doctorId = disableReqVO.getDoctorId();
        MzjhUser tbMzjhUser = this.mzjhUserService.getUserInfoByDoctorIdAndOrganId(doctorId, organId = disableReqVO.getOrganId());
        if (tbMzjhUser == null) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (UserStatusReqVO.UserStatus.disable.getCode().equals(tbMzjhUser.getUserStatusCode())) {
            throw new BusinessException("\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c\uff01");
        }
        UserStatusReqVO userStatusReqVO = new UserStatusReqVO(this.mzCaConfig.getPrivateKey());
        userStatusReqVO.setAppId(this.mzCaConfig.getAppId());
        userStatusReqVO.setId(tbMzjhUser.getTelephone());
        userStatusReqVO.setStatus(UserStatusReqVO.UserStatus.disable);
        this.mzjhUserService.disable(tbMzjhUser, userStatusReqVO);
        return BaseResponse.success();
    }
}

