/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.ca.common.dto.DoctorSyncBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorSyncHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorSyncResultDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchRequestDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchResultDTO;
import com.ebaiyihui.ca.common.dto.SynDoctorSearchResultData;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IDoctorApiClient;
import com.ebaiyihui.ca.server.feign.IhospitalApiClient;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.pojo.SyncDoctorReqVO;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.pojo.entity.ConfigDic;
import com.ebaiyihui.ca.server.service.CaDoctorService;
import com.ebaiyihui.ca.server.service.ConfigDicService;
import com.ebaiyihui.ca.server.utils.BASE64DecodedMultipartFile;
import com.ebaiyihui.ca.server.utils.DateTimeUtil;
import com.ebaiyihui.ca.server.utils.OSSClientUtil;
import com.ebaiyihui.ca.server.utils.RestTemplateUtils;
import com.ebaiyihui.ca.server.utils.SignUtil;
import com.ebaiyihui.ca.server.utils.ywx.TokenUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CaDoctorServiceImpl
implements CaDoctorService {
    private static final Logger log = LoggerFactory.getLogger(CaDoctorServiceImpl.class);
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private TokenUtil tokenUtil;
    @Autowired
    private CaDoctorMapper caDoctorMapper;
    @Autowired
    private ConfigDicService configDicService;

    @Transactional(rollbackFor={BusinessException.class})
    public void syncDoctor(SyncDoctorReqVO syncDoctorReqVO) {
        Long doctorId = syncDoctorReqVO.getDoctorId();
        Long hospitalId = syncDoctorReqVO.getHospitalId();
        String appCode = syncDoctorReqVO.getAppCode();
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(doctorId, hospitalId);
        if (doctorEntity != null) {
            Integer userStatus = doctorEntity.getUserStatus();
            if (userStatus == 4) {
                BaseDTO baseDTO = new BaseDTO();
                baseDTO.setId(Integer.valueOf(doctorId.intValue()));
                BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
                if (doctorEntityInfoVOBaseResponse == null || doctorEntityInfoVOBaseResponse.getData() == null) {
                    throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
                }
                DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
                QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
                queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalId.intValue()));
                BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
                if (organDetailVOBaseResponse == null || organDetailVOBaseResponse.getData() == null) {
                    throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
                }
                QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
                DoctorSyncBodyRequestDTO bodyTemp = new DoctorSyncBodyRequestDTO();
                bodyTemp.setDoctorId("");
                bodyTemp.setDoctorIdType("QT");
                bodyTemp.setOrgName(organDetailVO.getOrganName());
                bodyTemp.setDoctorName(doctorEntityInfoVO.getName());
                bodyTemp.setUid(doctorEntityInfoVO.getCredNo());
                bodyTemp.setUidCardType("SF");
                bodyTemp.setPhone(doctorEntityInfoVO.getRegisterMobile());
                bodyTemp.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
                ConfigDic configDic = this.configDicService.getByHospitalId(hospitalId);
                if (configDic == null) {
                    throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
                }
                String clientId = configDic.getClientId();
                String secret = configDic.getSecret();
                String url = configDic.getUrl();
                String accessToken = this.tokenUtil.getAccessToken(url + "/device/server/oauth/getAccessToken", clientId, secret);
                DoctorSyncHeadRequestDTO headDTO = new DoctorSyncHeadRequestDTO();
                headDTO.setClientId(clientId);
                headDTO.setAccessToken(accessToken);
                headDTO.setBodySign(SignUtil.getSign((String)JSON.toJSONString((Object)bodyTemp), (String)secret));
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("head", (Object)headDTO);
                jsonObject.put("body", (Object)bodyTemp);
                log.info("\u4fee\u6539-\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u63a5\u53e3\u4f20\u9012\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
                String doctorSynResult = null;
                try {
                    doctorSynResult = RestTemplateUtils.post((String)(url + "/am/v2/doctor/syn"), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
                }
                catch (Exception e) {
                    throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
                }
                if (doctorSynResult == null) {
                    throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u4e09\u65b9\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e09\u65b9\u6216\u8005\u7f51\u7edc\u9519\u8bef\uff01");
                }
                DoctorSyncResultDTO resultDTO = (DoctorSyncResultDTO)JSON.parseObject((String)doctorSynResult, DoctorSyncResultDTO.class);
                if (!"0".equals(resultDTO.getStatus())) {
                    throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u9519\u8bef\uff1a" + resultDTO.getMessage() + "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u4fe1\u606f\u540e\u518d\u6b21\u6388\u6743\uff01");
                }
                doctorEntity.setOpenId(resultDTO.getData().getOpenId());
                doctorEntity.setDoctorId(doctorId.toString());
                doctorEntity.setUserStatus(Integer.valueOf(-1));
                doctorEntity.setStatusTime(new Date());
                doctorEntity.setDoctorName(doctorEntityInfoVO.getName());
                doctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
                doctorEntity.setOrgName(organDetailVO.getOrganName());
                doctorEntity.setUid(doctorEntityInfoVO.getCredNo());
                doctorEntity.setUidCardType("SF");
                doctorEntity.setPhone(doctorEntityInfoVO.getRegisterMobile());
                doctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
                doctorEntity.setDepartmentSecond(doctorEntityInfoVO.getStdSecondDeptName());
                doctorEntity.setDoctorType("QT");
                doctorEntity.setTitle(doctorEntityInfoVO.getProfession());
                doctorEntity.setIssueOrg("\u5317\u4eac\u6570\u5b57\u533b\u4fe1\u79d1\u6280\u6709\u9650\u516c\u53f8");
                doctorEntity.setOrganCode(appCode);
                doctorEntity.setHospitalId(hospitalId);
                this.caDoctorMapper.updateByPrimaryKeySelective(doctorEntity);
            }
        } else {
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(doctorId.intValue()));
            BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
            if (doctorEntityInfoVOBaseResponse == null || doctorEntityInfoVOBaseResponse.getData() == null) {
                throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
            }
            DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
            QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
            queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalId.intValue()));
            BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
            if (organDetailVOBaseResponse == null || organDetailVOBaseResponse.getData() == null) {
                throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
            }
            QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
            DoctorSyncBodyRequestDTO bodyTemp = new DoctorSyncBodyRequestDTO();
            bodyTemp.setDoctorId("");
            bodyTemp.setDoctorIdType("QT");
            bodyTemp.setOrgName(organDetailVO.getOrganName());
            bodyTemp.setDoctorName(doctorEntityInfoVO.getName());
            bodyTemp.setUid(doctorEntityInfoVO.getCredNo());
            bodyTemp.setUidCardType("SF");
            bodyTemp.setPhone(doctorEntityInfoVO.getRegisterMobile());
            bodyTemp.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
            ConfigDic configDic = this.configDicService.getByHospitalId(hospitalId);
            if (configDic == null) {
                throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
            }
            String clientId = configDic.getClientId();
            String secret = configDic.getSecret();
            String url = configDic.getUrl();
            String accessToken = this.tokenUtil.getAccessToken(url + "/device/server/oauth/getAccessToken", clientId, secret);
            DoctorSyncHeadRequestDTO headDTO = new DoctorSyncHeadRequestDTO();
            headDTO.setClientId(clientId);
            headDTO.setAccessToken(accessToken);
            headDTO.setBodySign(SignUtil.getSign((String)JSON.toJSONString((Object)bodyTemp), (String)secret));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("head", (Object)headDTO);
            jsonObject.put("body", (Object)bodyTemp);
            log.info("\u65b0\u589e-\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u63a5\u53e3\u4f20\u9012\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
            String doctorSynResult = null;
            try {
                doctorSynResult = RestTemplateUtils.post((String)(url + "/am/v2/doctor/syn"), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
            }
            catch (Exception e) {
                throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
            }
            if (doctorSynResult == null) {
                throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u4e09\u65b9\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e09\u65b9\u6216\u8005\u7f51\u7edc\u9519\u8bef\uff01");
            }
            DoctorSyncResultDTO resultDTO = (DoctorSyncResultDTO)JSON.parseObject((String)doctorSynResult, DoctorSyncResultDTO.class);
            if (!"0".equals(resultDTO.getStatus())) {
                throw new BusinessException("\u540c\u6b65\u533b\u5e08\u4fe1\u606f\u8c03\u7528\u9519\u8bef\uff1a" + resultDTO.getMessage() + "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01");
            }
            CaDoctorEntity caDoctorEntity = new CaDoctorEntity();
            caDoctorEntity.setOpenId(resultDTO.getData().getOpenId());
            caDoctorEntity.setDoctorId(doctorId.toString());
            caDoctorEntity.setUserStatus(Integer.valueOf(-1));
            caDoctorEntity.setStatusTime(new Date());
            caDoctorEntity.setDoctorName(doctorEntityInfoVO.getName());
            caDoctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
            caDoctorEntity.setOrgName(organDetailVO.getOrganName());
            caDoctorEntity.setUid(doctorEntityInfoVO.getCredNo());
            caDoctorEntity.setUidCardType("SF");
            caDoctorEntity.setPhone(doctorEntityInfoVO.getRegisterMobile());
            caDoctorEntity.setDepartment(doctorEntityInfoVO.getHospitalDeptName());
            caDoctorEntity.setDepartmentSecond(doctorEntityInfoVO.getStdSecondDeptName());
            caDoctorEntity.setDoctorType("QT");
            caDoctorEntity.setTitle(doctorEntityInfoVO.getProfession());
            caDoctorEntity.setIssueOrg("\u5317\u4eac\u6570\u5b57\u533b\u4fe1\u79d1\u6280\u6709\u9650\u516c\u53f8");
            caDoctorEntity.setOrganCode(appCode);
            caDoctorEntity.setHospitalId(hospitalId);
            this.caDoctorMapper.save(caDoctorEntity);
        }
    }

    public CaDoctorEntity getByDoctorIdAndHospitalId(Long doctorId, Long hospitalId) {
        CaDoctorEntity caDoctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(doctorId, hospitalId);
        return caDoctorEntity;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public BaseResponse<Object> synDoctorSearch(SynDoctorSearchRequestDTO dto) {
        Long hospitalId = dto.getHospitalId();
        Long doctorId = dto.getDoctorId();
        SynDoctorSearchBodyRequestDTO body = dto.getBody();
        if (ObjectUtil.isNull((Object)body)) {
            throw new BusinessException("\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u53c2\u6570\uff01");
        }
        ConfigDic configDic = this.configDicService.getByHospitalId(hospitalId);
        if (ObjectUtil.isNull((Object)configDic)) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        String clientId = configDic.getClientId();
        String url = configDic.getUrl();
        SynDoctorSearchHeadRequestDTO head = new SynDoctorSearchHeadRequestDTO();
        head.setClientId(clientId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)head);
        jsonObject.put("body", (Object)body);
        log.info("\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3-\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        String synDoctorSearchResult = null;
        try {
            synDoctorSearchResult = RestTemplateUtils.post((String)(url + "/gateway/doctor/synDoctorSearch"), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
        }
        log.info("\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3-\u51fa\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        if (synDoctorSearchResult == null) {
            throw new BusinessException("\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e09\u65b9\u6216\u8005\u7f51\u7edc\u9519\u8bef\uff01");
        }
        SynDoctorSearchResultDTO resultDTO = (SynDoctorSearchResultDTO)JSON.parseObject((String)synDoctorSearchResult, SynDoctorSearchResultDTO.class);
        if (!"0".equals(resultDTO.getStatus())) {
            throw new BusinessException("\u540c\u6b65\u533b\u5e08\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff1a" + resultDTO.getMessage() + "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01");
        }
        SynDoctorSearchResultData data = resultDTO.getData();
        CaDoctorEntity caDoctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(doctorId, hospitalId);
        if (ObjectUtil.isNull((Object)caDoctorEntity)) {
            DoctorEntityInfoVO doctorInfoVO = this.getCloudDoctorInfo(Integer.valueOf(doctorId.intValue()));
            QueryOrganDetailVO organDetailVO = this.getOrganDetailInfo(Integer.valueOf(hospitalId.intValue()));
            CaDoctorEntity saveDto = new CaDoctorEntity();
            if ("2".equals(data.getProcess())) {
                String fileName = OSSClientUtil.uploadImg2Oss((MultipartFile)BASE64DecodedMultipartFile.base64ToMultipart((String)("data:image/png;base64," + data.getStamp())), (String)("ca/stamp/" + data.getOpenId() + "/"));
                String ossUrl = OSSClientUtil.getUrl((String)fileName);
                log.info("fileName:{}", (Object)fileName);
                log.info("ossUrl:{}", (Object)ossUrl);
                String issueTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd");
                String validTime = DateTimeUtil.formatTime((Date)DateTimeUtil.addYear((Date)new Date(), (int)1), (String)"yyyy-MM-dd");
                saveDto.setStamp(ossUrl);
                saveDto.setStampStatus(Integer.valueOf(data.getStampStatus()));
                saveDto.setIssueTime(issueTime);
                saveDto.setValidTime(validTime);
            }
            if ("4".equals(data.getProcess())) {
                saveDto.setNote(data.getNote());
            }
            saveDto.setDoctorId(doctorId.toString());
            saveDto.setDoctorName(doctorInfoVO.getName());
            saveDto.setOpenId(data.getOpenId());
            saveDto.setPhone(doctorInfoVO.getRegisterMobile());
            saveDto.setUid(doctorInfoVO.getCredNo());
            saveDto.setOrganCode("BYH");
            saveDto.setUserStatus(Integer.valueOf(data.getProcess()));
            saveDto.setStatusTime(new Date());
            saveDto.setUidCardType("SF");
            saveDto.setTitle(doctorInfoVO.getProfession());
            saveDto.setDepartment(doctorInfoVO.getHospitalDeptName());
            saveDto.setDepartmentSecond(doctorInfoVO.getStdSecondDeptName());
            saveDto.setOrgName(organDetailVO.getOrganName());
            saveDto.setDoctorType("QT");
            saveDto.setIssueOrg("\u5317\u4eac\u6570\u5b57\u533b\u4fe1\u79d1\u6280\u6709\u9650\u516c\u53f8");
            saveDto.setStatus(Integer.valueOf(1));
            saveDto.setPlatform("SXK_CA");
            saveDto.setHospitalId(hospitalId);
            this.caDoctorMapper.save(caDoctorEntity);
            return BaseResponse.success((Object)saveDto);
        }
        if ("2".equals(data.getProcess())) {
            String fileName = OSSClientUtil.uploadImg2Oss((MultipartFile)BASE64DecodedMultipartFile.base64ToMultipart((String)("data:image/png;base64," + data.getStamp())), (String)("ca/stamp/" + data.getOpenId() + "/"));
            String ossUrl = OSSClientUtil.getUrl((String)fileName);
            log.info("fileName:{}", (Object)fileName);
            log.info("ossUrl:{}", (Object)ossUrl);
            String issueTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd");
            String validTime = DateTimeUtil.formatTime((Date)DateTimeUtil.addYear((Date)new Date(), (int)1), (String)"yyyy-MM-dd");
            caDoctorEntity.setStamp(ossUrl);
            caDoctorEntity.setStampStatus(Integer.valueOf(data.getStampStatus()));
            caDoctorEntity.setIssueTime(issueTime);
            caDoctorEntity.setValidTime(validTime);
        }
        if ("4".equals(data.getProcess())) {
            caDoctorEntity.setNote(data.getNote());
        }
        caDoctorEntity.setOpenId(data.getOpenId());
        caDoctorEntity.setUserStatus(Integer.valueOf(data.getProcess()));
        this.caDoctorMapper.updateByPrimaryKey(caDoctorEntity);
        return BaseResponse.success((Object)caDoctorEntity);
    }

    private QueryOrganDetailVO getOrganDetailInfo(Integer organId) {
        QueryOrganDetailDTO organDetailDTO = new QueryOrganDetailDTO();
        organDetailDTO.setOrganId(organId);
        BaseResponse organDetail = this.ihospitalApiClient.queryOrganDetail(organDetailDTO);
        if (organDetail == null || organDetail.getData() == null) {
            throw new BusinessException("\u533b\u9662\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
        }
        return (QueryOrganDetailVO)organDetail.getData();
    }

    private DoctorEntityInfoVO getCloudDoctorInfo(Integer doctorId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(doctorId);
        BaseResponse doctorDetailInfo = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        if (doctorDetailInfo == null || doctorDetailInfo.getData() == null) {
            throw new BusinessException("\u533b\u751f\u4fe1\u606f\u67e5\u4e0d\u5230\uff01");
        }
        return (DoctorEntityInfoVO)doctorDetailInfo.getData();
    }
}

