/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.ca.server.common.enums.PlatformEnum;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.mapper.CaFreePinSignMapper;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaFreePinSignEntity;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CaLoginTaskReqVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CloseFreePinReqVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.SetupCaFreePinReqVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.AddSignJobAndGetResultRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.CaFreePinSignRespVo;
import com.ebaiyihui.ca.server.service.CaFreePinService;
import com.ebaiyihui.ca.server.third.HTCACossHelper;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaFreePinServiceImpl
implements CaFreePinService {
    private static final Logger log = LoggerFactory.getLogger(CaFreePinServiceImpl.class);
    @Autowired
    private CaFreePinSignMapper caFreePinSignMapper;
    @Autowired
    private CaDoctorMapper caDoctorMapper;
    @Autowired
    private HTCACossHelper htcaCossHelper;

    public BaseResponse setupCaFreePinSign(SetupCaFreePinReqVo setupCaFreePinReqVo) {
        CaFreePinSignEntity caFreePinSignEntity = this.caFreePinSignMapper.getByDoctorIdAndOrganId(setupCaFreePinReqVo.getDoctorId(), setupCaFreePinReqVo.getOrganId());
        log.info("\u67e5\u8be2\u533b\u751f\u514d\u5bc6\u7b7e\u540d\u521d\u59cb\u5316\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)caFreePinSignEntity));
        LocalDateTime effectiveTime = LocalDateTime.now().plusDays(setupCaFreePinReqVo.getDayValue().intValue());
        Date effectiveDate = Date.from(effectiveTime.atZone(ZoneId.systemDefault()).toInstant());
        if (Objects.isNull(caFreePinSignEntity)) {
            caFreePinSignEntity = new CaFreePinSignEntity();
            caFreePinSignEntity.setAppCode(setupCaFreePinReqVo.getAppCode());
            caFreePinSignEntity.setEffectiveTime(effectiveDate);
            caFreePinSignEntity.setPinCode(setupCaFreePinReqVo.getPinCode());
            caFreePinSignEntity.setOrganId(setupCaFreePinReqVo.getOrganId());
            caFreePinSignEntity.setDoctorId(setupCaFreePinReqVo.getDoctorId());
            caFreePinSignEntity.setStatus(Integer.valueOf(1));
            log.info("\u533b\u751f\u514d\u5bc6\u7b7e\u540d\u521d\u59cb\u5316\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)caFreePinSignEntity));
            this.caFreePinSignMapper.insertSelective(caFreePinSignEntity);
            return BaseResponse.success();
        }
        caFreePinSignEntity.setAppCode(setupCaFreePinReqVo.getAppCode());
        caFreePinSignEntity.setEffectiveTime(effectiveDate);
        caFreePinSignEntity.setPinCode(setupCaFreePinReqVo.getPinCode());
        caFreePinSignEntity.setStatus(Integer.valueOf(1));
        log.info("\u66f4\u65b0\u533b\u751f\u514d\u5bc6\u7b7e\u540d\u521d\u59cb\u5316\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)caFreePinSignEntity));
        this.caFreePinSignMapper.updateByPrimaryKeySelective(caFreePinSignEntity);
        return BaseResponse.success();
    }

    public BaseResponse<CaFreePinSignRespVo> getCaFreePinSign(Long organId, Long doctorId) {
        CaFreePinSignEntity caFreePinSign = this.caFreePinSignMapper.getByDoctorIdAndOrganId(doctorId, organId);
        CaFreePinSignRespVo caFreePinSignRespVo = new CaFreePinSignRespVo();
        caFreePinSignRespVo.setFreePinStatus(-1);
        if (Objects.nonNull(caFreePinSign) && 1 == caFreePinSign.getStatus()) {
            Date effectiveTime = caFreePinSign.getEffectiveTime();
            if (Objects.nonNull(effectiveTime) && effectiveTime.after(new Date())) {
                caFreePinSignRespVo.setFreePinStatus(1);
                caFreePinSignRespVo.setPinCode(caFreePinSign.getPinCode());
                return BaseResponse.success((Object)caFreePinSignRespVo);
            }
            caFreePinSign.setStatus(Integer.valueOf(-1));
            this.caFreePinSignMapper.updateByPrimaryKeySelective(caFreePinSign);
        }
        return BaseResponse.success((Object)caFreePinSignRespVo);
    }

    public BaseResponse<AddSignJobAndGetResultRespVO> createCaLoginTask(CaLoginTaskReqVo caLoginTaskReqVo) {
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(String.valueOf(caLoginTaskReqVo.getDoctorId()), caLoginTaskReqVo.getAppCode(), PlatformEnum.HT_CA.getValue());
        if (doctorEntity == null || doctorEntity.getOpenId() == null || "".equals(doctorEntity.getOpenId())) {
            throw new BusinessException("\u533b\u751fCA\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String uuid = UUIDUtils.getUUID();
        String signDataId = this.htcaCossHelper.addSignJobAndGetSignResult(uuid);
        AddSignJobAndGetResultRespVO caLoginTaskInfo = new AddSignJobAndGetResultRespVO();
        caLoginTaskInfo.setSignDataId(signDataId);
        caLoginTaskInfo.setUserId(doctorEntity.getOpenId());
        return BaseResponse.success((Object)caLoginTaskInfo);
    }

    public BaseResponse closeCaFreePinSign(CloseFreePinReqVo closeFreePinReqVo) {
        CaFreePinSignEntity caFreePinSignEntity = this.caFreePinSignMapper.getByDoctorIdAndOrganId(closeFreePinReqVo.getDoctorId(), closeFreePinReqVo.getOrganId());
        if (Objects.isNull(caFreePinSignEntity)) {
            return BaseResponse.success();
        }
        caFreePinSignEntity.setStatus(Integer.valueOf(-1));
        this.caFreePinSignMapper.updateByPrimaryKeySelective(caFreePinSignEntity);
        return BaseResponse.success();
    }
}

