/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.ca.common.dto.CaDTO;
import com.ebaiyihui.ca.common.dto.DoctorNotifyBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorNotifyHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorNotifyRequestDTO;
import com.ebaiyihui.ca.common.dto.DoctorPageListResDTO;
import com.ebaiyihui.ca.common.dto.DoctorPageListResultDTO;
import com.ebaiyihui.ca.common.dto.DoctorStatusRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeNotifyBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeNotifyHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeNotifyRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeStatusRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeSyncBodyRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeSyncHeadRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeSyncMsgRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeSyncRequestDTO;
import com.ebaiyihui.ca.common.dto.RecipeSyncResultDTO;
import com.ebaiyihui.ca.common.vo.CaPublicVo;
import com.ebaiyihui.ca.server.common.enums.StampStatusEnum;
import com.ebaiyihui.ca.server.common.enums.UserStatusEnum;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IDoctorApiClient;
import com.ebaiyihui.ca.server.feign.IhospitalApiClient;
import com.ebaiyihui.ca.server.mapper.CaDiagnosisMapper;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.mapper.CaDoctorNotifyMapper;
import com.ebaiyihui.ca.server.mapper.CaMedicalRecordMapper;
import com.ebaiyihui.ca.server.mapper.CaMedicineMapper;
import com.ebaiyihui.ca.server.mapper.CaPublicMapper;
import com.ebaiyihui.ca.server.mapper.CaRecipeMapper;
import com.ebaiyihui.ca.server.mapper.CaRecipeMedicineMapper;
import com.ebaiyihui.ca.server.mapper.CaRecipeNotifyMapper;
import com.ebaiyihui.ca.server.mapper.CaViewportMapper;
import com.ebaiyihui.ca.server.pojo.entity.CaDiagnosisEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorNotifyEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaMedicalRecordEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaPublicEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaRecipeEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaRecipeNotifyEntity;
import com.ebaiyihui.ca.server.pojo.entity.CaViewportEntity;
import com.ebaiyihui.ca.server.pojo.entity.ConfigDic;
import com.ebaiyihui.ca.server.service.CaService;
import com.ebaiyihui.ca.server.service.ConfigDicService;
import com.ebaiyihui.ca.server.utils.BASE64DecodedMultipartFile;
import com.ebaiyihui.ca.server.utils.DateTimeUtil;
import com.ebaiyihui.ca.server.utils.OSSClientUtil;
import com.ebaiyihui.ca.server.utils.PageUtil;
import com.ebaiyihui.ca.server.utils.PrivacyDimmer;
import com.ebaiyihui.ca.server.utils.RestTemplateUtils;
import com.ebaiyihui.ca.server.utils.SignUtil;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.ca.server.utils.ywx.TokenUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CaServiceImpl
implements CaService {
    private static final Logger log = LoggerFactory.getLogger(CaServiceImpl.class);
    @Autowired
    private TokenUtil tokenUtil;
    @Autowired
    private ConfigDicService configDicService;
    @Autowired
    IDoctorApiClient iDoctorApiClient;
    @Autowired
    IhospitalApiClient ihospitalApiClient;
    @Autowired
    CaDoctorMapper caDoctorMapper;
    @Autowired
    CaDoctorNotifyMapper caDoctorNotifyMapper;
    @Autowired
    CaPublicMapper caPublicMapper;
    @Autowired
    CaRecipeMapper caRecipeMapper;
    @Autowired
    CaRecipeNotifyMapper caRecipeNotifyMapper;
    @Autowired
    CaMedicineMapper caMedicineMapper;
    @Autowired
    CaRecipeMedicineMapper caRecipeMedicineMapper;
    @Autowired
    CaViewportMapper caViewportMapper;
    @Autowired
    CaDiagnosisMapper caDiagnosisMapper;
    @Autowired
    CaMedicalRecordMapper caMedicalRecordMapper;

    @Transactional(rollbackFor={Exception.class})
    public CaDTO notifyDoctor(DoctorNotifyRequestDTO dto) {
        log.info("\u533b\u5e08\u540c\u6b65\u56de\u8c03\u901a\u77e5\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        CaDTO caDTO = new CaDTO();
        DoctorNotifyBodyRequestDTO bodyDTO = dto.getBody();
        int process = Integer.valueOf(bodyDTO.getProcess());
        CaDoctorNotifyEntity caDoctorNotifyEntity = new CaDoctorNotifyEntity();
        boolean flag = this.validateDocReq(dto);
        if (flag) {
            log.info("==================\u8fdbflag\u4e86==================");
            try {
                DoctorNotifyHeadRequestDTO head = dto.getHead();
                String clientId = head.getClientId();
                ConfigDic configDic = this.configDicService.getByClientId(clientId);
                CaDoctorEntity doctorEntity = this.caDoctorMapper.findByOpenIdAndHospitalId(bodyDTO.getOpenId(), configDic.getHospitalId());
                if (doctorEntity.getUserStatus() < 2) {
                    doctorEntity.setUserStatus(Integer.valueOf(process));
                }
                doctorEntity.setOpenId(bodyDTO.getOpenId());
                doctorEntity.setNote(bodyDTO.getNote());
                doctorEntity.setStatusTime(DateTimeUtil.parseTime((String)bodyDTO.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                caDoctorNotifyEntity.setOpenId(bodyDTO.getOpenId());
                caDoctorNotifyEntity.setUserStatus(Integer.valueOf(process));
                caDoctorNotifyEntity.setPhoneNum(bodyDTO.getPhoneNum());
                caDoctorNotifyEntity.setNote(bodyDTO.getNote());
                if (process == 2) {
                    log.info("==================process == 2\u7684\u903b\u8f91==================");
                    String fileName = OSSClientUtil.uploadImg2Oss((MultipartFile)BASE64DecodedMultipartFile.base64ToMultipart((String)("data:image/png;base64," + bodyDTO.getStamp())), (String)("ca/stamp/" + dto.getBody().getOpenId() + "/"));
                    String url = OSSClientUtil.getUrl((String)fileName);
                    log.info("fileName" + fileName);
                    log.info("url" + url);
                    String issueTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd");
                    String validTime = DateTimeUtil.formatTime((Date)DateTimeUtil.addYear((Date)new Date(), (int)1), (String)"yyyy-MM-dd");
                    doctorEntity.setIssueTime(issueTime);
                    doctorEntity.setValidTime(validTime);
                    doctorEntity.setStamp(url);
                    doctorEntity.setStampStatus(Integer.valueOf(bodyDTO.getStampStatus()));
                    caDoctorNotifyEntity.setStamp(bodyDTO.getStamp());
                    caDoctorNotifyEntity.setStampStatus(Integer.valueOf(bodyDTO.getStampStatus()));
                }
                this.caDoctorMapper.updateByPrimaryKeySelective(doctorEntity);
                caDTO.setStatus("0");
                caDTO.setMessage("success");
                return caDTO;
            }
            catch (Exception e) {
                throw new BusinessException("\u629b\u51fa\u5f02\u5e38\u4e86\uff1a" + e.getMessage());
            }
        }
        caDTO.setStatus("1");
        caDTO.setMessage("\u7cfb\u7edf\u5f02\u5e38");
        return caDTO;
    }

    @Transactional
    public BaseResponse<Object> syncRecipe(RecipeSyncRequestDTO dto) {
        RecipeSyncBodyRequestDTO bodyDTO;
        RecipeSyncHeadRequestDTO headDTO;
        log.info("\u540c\u6b65\u5904\u65b9\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        HashMap<String, String> map = new HashMap<String, String>(16);
        CaPublicEntity caPublicEntity = new CaPublicEntity();
        RecipeSyncMsgRequestDTO msgDTO = dto.getMsg();
        if (msgDTO == null) {
            msgDTO = new RecipeSyncMsgRequestDTO();
        }
        if ((headDTO = msgDTO.getHead()) == null) {
            headDTO = new RecipeSyncHeadRequestDTO();
        }
        if ((bodyDTO = msgDTO.getBody()) == null) {
            bodyDTO = new RecipeSyncBodyRequestDTO();
        }
        String urId = UUIDUtils.getUUID();
        bodyDTO.setUrId(urId);
        Long hospitalId = dto.getHospitalId();
        if (hospitalId == null) {
            throw new BusinessException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        bodyDTO.setScale(Float.valueOf(1.2f));
        ConfigDic configDic = this.configDicService.getByHospitalId(hospitalId);
        if (configDic == null) {
            throw new BusinessException("\u5b57\u5178\u8868\u4e2d\u67e5\u4e0d\u5230\u533b\u9662\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String clientId = configDic.getClientId();
        String secret = configDic.getSecret();
        String url = configDic.getUrl();
        String accessToken = this.tokenUtil.getAccessToken(url + "/device/server/oauth/getAccessToken", clientId, secret);
        headDTO.setClientId(clientId);
        headDTO.setAccessToken(accessToken);
        headDTO.setServiceId(Integer.valueOf(101));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", (Object)msgDTO);
        jsonObject.put("signType", (Object)dto.getSignType());
        log.info("\u540c\u6b65\u5904\u65b9\u63a5\u53e3\u4f20\u9012\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
        String httpResult = null;
        try {
            httpResult = RestTemplateUtils.post((String)(url + "/am/v2/recipe/syn"), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8, (String)"");
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65\u5904\u65b9\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6" + e.getMessage());
        }
        log.info("\u5904\u65b9ID={},openId={},\u533b\u7f51\u7b7e\u8fd4\u56de\u7ed3\u679c----->{}", new Object[]{urId, dto.getMsg().getBody().getOpenId(), httpResult});
        if (StringUtils.isNotBlank((String)httpResult)) {
            RecipeSyncResultDTO resultDTO = (RecipeSyncResultDTO)JSON.parseObject((String)httpResult, RecipeSyncResultDTO.class);
            if ("0".equals(resultDTO.getStatus())) {
                caPublicEntity.setOpenId(bodyDTO.getOpenId());
                caPublicEntity.setUniqueId(resultDTO.getData().getUniqueId());
                caPublicEntity.setTemplateId(headDTO.getTemplateId());
                caPublicEntity.setUrId(urId);
                caPublicEntity.setSignStatus(Integer.valueOf(-1));
                caPublicEntity.setRecipeTime(DateTimeUtil.parseTime((String)bodyDTO.getRecipeTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                caPublicEntity.setHospitalId(hospitalId);
                caPublicEntity.setClientId(clientId);
                this.caPublicMapper.save(caPublicEntity);
                log.info("uniqueId={}", (Object)resultDTO.getData().getUniqueId());
                switch (this.transform(headDTO.getTemplateId())) {
                    case 1: {
                        CaRecipeEntity recipeEntity = new CaRecipeEntity();
                        recipeEntity.setDiagnose(bodyDTO.getDiagnose());
                        recipeEntity.setPathogeny(bodyDTO.getPathogeny());
                        recipeEntity.setRecipeTerm(Integer.valueOf(bodyDTO.getRecipeTerm()));
                        recipeEntity.setUrId(urId);
                        this.caRecipeMapper.save(recipeEntity);
                        break;
                    }
                    case 2: {
                        CaViewportEntity viewportEntity = new CaViewportEntity();
                        viewportEntity.setClinicalDiagnosis(bodyDTO.getClinicalDiagnosis());
                        viewportEntity.setClinicalMemo(bodyDTO.getClinicalMemo());
                        viewportEntity.setClinicalSysmpton(bodyDTO.getClinicalSympton());
                        viewportEntity.setConsultationStatus(bodyDTO.getConsultationStatus());
                        viewportEntity.setExamBodypart(bodyDTO.getExamBodypart());
                        viewportEntity.setExamModality(bodyDTO.getExamModality());
                        viewportEntity.setExamProcedurestepName(bodyDTO.getExamProcedurestepName());
                        viewportEntity.setUrId(urId);
                        this.caViewportMapper.save(viewportEntity);
                        break;
                    }
                    case 3: {
                        CaDiagnosisEntity diagnosisEntity = new CaDiagnosisEntity();
                        diagnosisEntity.setAuditUser(bodyDTO.getAuditUser());
                        diagnosisEntity.setBedNo(bodyDTO.getBedNo());
                        diagnosisEntity.setBodyPart(bodyDTO.getBodyPart());
                        diagnosisEntity.setCaseUid(bodyDTO.getCaseUid());
                        diagnosisEntity.setConclusion(bodyDTO.getConclusion());
                        diagnosisEntity.setDepartMent(bodyDTO.getDepartMent());
                        diagnosisEntity.setFinding(bodyDTO.getFinding());
                        diagnosisEntity.setHosipitalAddress(bodyDTO.getHosipitalAddress());
                        diagnosisEntity.setHosipitalName(bodyDTO.getHosipitalName());
                        diagnosisEntity.setHosipitalPhone(bodyDTO.getHosipitalPhone());
                        diagnosisEntity.setInpatientNum(bodyDTO.getInpatientNumber());
                        diagnosisEntity.setMt(bodyDTO.getMt());
                        diagnosisEntity.setReportTime(bodyDTO.getReportTime());
                        diagnosisEntity.setReportUser(bodyDTO.getReportUser());
                        diagnosisEntity.setSubmitTime(bodyDTO.getSubmitTime());
                        diagnosisEntity.setUrId(urId);
                        this.caDiagnosisMapper.save(diagnosisEntity);
                        break;
                    }
                    case 4: {
                        CaMedicalRecordEntity medicalRecordEntity = new CaMedicalRecordEntity();
                        medicalRecordEntity.setComplaint(bodyDTO.getComplaint());
                        medicalRecordEntity.setDepartMent(bodyDTO.getDepartMent());
                        medicalRecordEntity.setDiagnosis(bodyDTO.getDiagnosis());
                        medicalRecordEntity.setEntrust(bodyDTO.getEntrust());
                        medicalRecordEntity.setHistoryAllergy(bodyDTO.getHistoryAllergy());
                        medicalRecordEntity.setHistoryDisease(bodyDTO.getHistoryDisease());
                        medicalRecordEntity.setHistoryNow(bodyDTO.getHistoryIllness());
                        medicalRecordEntity.setOpinion(bodyDTO.getOpinion());
                        medicalRecordEntity.setOutNum(bodyDTO.getOutNumber());
                        medicalRecordEntity.setPhysicalCondition(bodyDTO.getPhysicalCondition());
                        medicalRecordEntity.setSuppleExam(bodyDTO.getSuppleExam());
                        medicalRecordEntity.setTreatment(bodyDTO.getTreatment());
                        medicalRecordEntity.setTreatPlan(bodyDTO.getTreatPlan());
                        medicalRecordEntity.setVisitingTime(DateTimeUtil.parseTime((String)bodyDTO.getVisitingTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        medicalRecordEntity.setUrId(urId);
                        this.caMedicalRecordMapper.save(medicalRecordEntity);
                        break;
                    }
                    default: {
                        return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
                    }
                }
                map.put("uniqueId", resultDTO.getData().getUniqueId());
                map.put("urId", urId);
                return BaseResponse.success(map);
            }
            return BaseResponse.error((String)resultDTO.getMessage());
        }
        return BaseResponse.error((String)"CA\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25");
    }

    public BaseResponse<Object> getRecStatus(RecipeStatusRequestDTO dto) {
        log.info("\u67e5\u8be2\u5904\u65b9\u72b6\u6001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        try {
            CaPublicEntity entity = this.caPublicMapper.findByUrID(dto.getUrId());
            log.info("\u5904\u65b9\u4fe1\u606f----->{}", (Object)entity);
            if (entity != null) {
                return BaseResponse.success((Object)entity);
            }
            return BaseResponse.error((String)"\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5904\u65b9\u4fe1\u606f - \u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public BaseResponse<Object> getDocStatus(DoctorStatusRequestDTO dto) {
        log.info("\u67e5\u8be2\u533b\u5e08\u72b6\u6001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        try {
            CaDoctorEntity entity = this.caDoctorMapper.findByDoctorID(dto.getDoctorId());
            log.info("\u533b\u5e08\u4fe1\u606f----->{}", (Object)entity);
            if (entity != null) {
                return BaseResponse.success((Object)entity);
            }
            return BaseResponse.error((String)"\u533b\u5e08\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u533b\u5e08\u4fe1\u606f - \u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CaDTO notifyRecipe(RecipeNotifyRequestDTO dto) {
        log.info("\u540c\u6b65\u5904\u65b9\u56de\u8c03\u901a\u77e5\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        CaDTO caDTO = new CaDTO();
        RecipeNotifyBodyRequestDTO bodyDTO = dto.getBody();
        CaPublicEntity caPublicEntity = new CaPublicEntity();
        CaRecipeNotifyEntity caRecipeNotifyEntity = new CaRecipeNotifyEntity();
        boolean flag = this.validateRecReq(dto);
        if (flag) {
            caPublicEntity.setUniqueId(bodyDTO.getUniqueId());
            caPublicEntity.setSignStatus(bodyDTO.getStatus());
            caRecipeNotifyEntity.setOpenId(bodyDTO.getOpenId());
            caRecipeNotifyEntity.setUniqueId(bodyDTO.getUniqueId());
            caRecipeNotifyEntity.setReason(bodyDTO.getReason());
            caRecipeNotifyEntity.setSignedData(bodyDTO.getSignedData());
            caRecipeNotifyEntity.setUrId(bodyDTO.getUrId());
            caRecipeNotifyEntity.setSignStatus(bodyDTO.getStatus());
            this.caPublicMapper.update(caPublicEntity);
            this.caRecipeNotifyMapper.save(caRecipeNotifyEntity);
            caDTO.setStatus("0");
            caDTO.setMessage("success");
            return caDTO;
        }
        caDTO.setStatus("1");
        caDTO.setMessage("\u7cfb\u7edf\u5f02\u5e38");
        return caDTO;
    }

    public BaseResponse<Object> getUnsignRecipe(DoctorStatusRequestDTO dto) {
        log.info("\u672a\u7b7e\u540d\u5904\u65b9\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        List result = this.caPublicMapper.getUnsignRecipe(dto);
        block6: for (CaPublicVo vo : result) {
            String templated = vo.getTemplateId();
            String urId = vo.getUrId();
            switch (this.transform(templated)) {
                case 1: {
                    CaRecipeEntity recipeEntity = this.caRecipeMapper.getByUrId(urId);
                    if (recipeEntity == null) continue block6;
                    vo.setPathogeny(recipeEntity.getPathogeny());
                    vo.setDiagnose(recipeEntity.getDiagnose());
                    vo.setRecipeTerm(recipeEntity.getRecipeTerm().intValue());
                    continue block6;
                }
                case 2: {
                    CaViewportEntity viewportEntity = this.caViewportMapper.getByUrId(urId);
                    if (viewportEntity == null) continue block6;
                    vo.setClinicalDiagnosis(viewportEntity.getClinicalDiagnosis());
                    vo.setClinicalMemo(viewportEntity.getClinicalMemo());
                    vo.setClinicalSympton(viewportEntity.getClinicalSysmpton());
                    vo.setConsultationStatus(viewportEntity.getConsultationStatus());
                    vo.setExamBodypart(viewportEntity.getExamBodypart());
                    vo.setExamModality(viewportEntity.getExamModality());
                    vo.setExamProcedurestepName(viewportEntity.getExamProcedurestepName());
                    continue block6;
                }
                case 3: {
                    CaDiagnosisEntity diagnosisEntity = this.caDiagnosisMapper.getByUrId(urId);
                    if (diagnosisEntity == null) continue block6;
                    vo.setAuditUser(diagnosisEntity.getAuditUser());
                    vo.setBedNo(diagnosisEntity.getBedNo());
                    vo.setBodyPart(diagnosisEntity.getBodyPart());
                    vo.setCaseUid(diagnosisEntity.getCaseUid());
                    vo.setConclusion(diagnosisEntity.getConclusion());
                    vo.setDepartMent(diagnosisEntity.getDepartMent());
                    vo.setFinding(diagnosisEntity.getFinding());
                    vo.setHosipitalAddress(diagnosisEntity.getHosipitalAddress());
                    vo.setHosipitalName(diagnosisEntity.getHosipitalName());
                    vo.setHosipitalPhone(diagnosisEntity.getHosipitalPhone());
                    vo.setInpatientNumber(diagnosisEntity.getInpatientNum());
                    vo.setMt(diagnosisEntity.getMt());
                    vo.setReportTime(diagnosisEntity.getReportTime());
                    vo.setReportUser(diagnosisEntity.getReportUser());
                    vo.setSubmitTime(diagnosisEntity.getSubmitTime());
                    continue block6;
                }
                case 4: {
                    CaMedicalRecordEntity medicalRecordEntity = this.caMedicalRecordMapper.getByUrId(urId);
                    if (medicalRecordEntity == null) continue block6;
                    vo.setComplaint(medicalRecordEntity.getComplaint());
                    vo.setDepartMent(medicalRecordEntity.getDepartMent());
                    vo.setDiagnosis(medicalRecordEntity.getDiagnosis());
                    vo.setEntrust(medicalRecordEntity.getEntrust());
                    vo.setHistoryAllergy(medicalRecordEntity.getHistoryAllergy());
                    vo.setHistoryDisease(medicalRecordEntity.getHistoryDisease());
                    vo.setHistoryIllness(medicalRecordEntity.getHistoryNow());
                    vo.setOpinion(medicalRecordEntity.getOpinion());
                    vo.setOutNumber(medicalRecordEntity.getOutNum());
                    vo.setPhysicalCondition(medicalRecordEntity.getPhysicalCondition());
                    vo.setSuppleExam(medicalRecordEntity.getSuppleExam());
                    vo.setTreatment(medicalRecordEntity.getTreatment());
                    vo.setTreatPlan(medicalRecordEntity.getTreatPlan());
                    vo.setVisitingTime(DateTimeUtil.formatTime((Date)medicalRecordEntity.getVisitingTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    continue block6;
                }
            }
            return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return BaseResponse.success((Object)result);
    }

    private boolean validateDocReq(DoctorNotifyRequestDTO dto) {
        DoctorNotifyHeadRequestDTO headDTO = dto.getHead();
        DoctorNotifyBodyRequestDTO bodyDTO = dto.getBody();
        String clientId = headDTO.getClientId();
        ConfigDic configDic = this.configDicService.getByClientId(clientId);
        if (configDic == null) {
            return false;
        }
        String secret = configDic.getSecret();
        String sign = SignUtil.getSign((String)JSON.toJSONString((Object)bodyDTO), (String)secret);
        return sign.equals(headDTO.getSign());
    }

    private boolean validateRecReq(RecipeNotifyRequestDTO dto) {
        RecipeNotifyHeadRequestDTO headDTO = dto.getHead();
        RecipeNotifyBodyRequestDTO bodyDTO = dto.getBody();
        String clientId = headDTO.getClientId();
        ConfigDic configDic = this.configDicService.getByClientId(clientId);
        if (configDic == null) {
            return false;
        }
        String secret = configDic.getSecret();
        String sign = SignUtil.getSign((String)JSON.toJSONString((Object)bodyDTO), (String)secret);
        return sign.equals(headDTO.getSign());
    }

    private int transform(String templateId) {
        int temp = 0;
        if (StringUtils.isNotEmpty((String)templateId)) {
            if ("recipe".equals(templateId)) {
                temp = 1;
            } else if ("viewport".equals(templateId)) {
                temp = 2;
            } else if ("diagnosis".equals(templateId)) {
                temp = 3;
            } else if ("medicalRecord".equals(templateId)) {
                temp = 4;
            } else {
                return temp;
            }
        }
        return temp;
    }

    public BaseResponse<PageResult<DoctorPageListResultDTO>> pagingList(DoctorPageListResDTO dto) {
        log.info("=======>CA\u8ba4\u8bc1\u5206\u9875\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageResult result = new PageResult();
        List list = this.caDoctorMapper.pageQuery(dto);
        for (DoctorPageListResultDTO resultDTO : list) {
            Integer userStatus = resultDTO.getUserStatus();
            Integer stampStatus = resultDTO.getStampStatus();
            resultDTO.setUserStatusMsg(UserStatusEnum.getDesc((Integer)userStatus));
            resultDTO.setStampMsg("\u672a\u8bbe\u7f6e");
            resultDTO.setButton(Integer.valueOf(0));
            if (stampStatus != null) {
                if (StampStatusEnum.AUDITED_PASS.getValue().intValue() == stampStatus.intValue()) {
                    resultDTO.setStampMsg("\u5df2\u8bbe\u7f6e");
                }
                if (StampStatusEnum.AUDITED_PASS.getValue().intValue() == stampStatus.intValue() && UserStatusEnum.SET_STAMP.getValue().intValue() == userStatus.intValue()) {
                    resultDTO.setButton(Integer.valueOf(1));
                }
            }
            resultDTO.setOpenId(String.valueOf(resultDTO.getCreateTime().getTime()));
            resultDTO.setPhone(PrivacyDimmer.maskMobile((String)resultDTO.getPhone()));
        }
        int count = this.caDoctorMapper.count(dto);
        int totalPage = PageUtil.getTotalPage((int)count, (int)dto.getPageSize());
        result.setPageSize(dto.getPageSize().intValue());
        result.setPageNum(dto.getPageNum().intValue());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }
}

