/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorUserInfoVO;
import com.ebaiyihui.ca.server.common.enums.PlatformEnum;
import com.ebaiyihui.ca.server.common.enums.UserStatusEnum;
import com.ebaiyihui.ca.server.config.SettingConfig;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.feign.IDoctorApiClient;
import com.ebaiyihui.ca.server.feign.IOssApi;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.mapper.HtCheckFaceReqLogMapper;
import com.ebaiyihui.ca.server.mapper.HtCheckFaceRespLogMapper;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.pojo.entity.HtCheckFaceReqLog;
import com.ebaiyihui.ca.server.pojo.entity.HtCheckFaceRespLog;
import com.ebaiyihui.ca.server.pojo.vo.ht.ActivationCodeVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.AddSignJobAndGetResultReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CardCheckFaceIdReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CheckFaceIdReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CheckFaceIdVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CheckUserIdentityReqVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.AddSignJobAndGetResultRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.CheckFaceIdRespVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.QueryUserInfoRespVO;
import com.ebaiyihui.ca.server.service.HTCAService;
import com.ebaiyihui.ca.server.third.HTCABiopsyHelper;
import com.ebaiyihui.ca.server.third.HTCACossHelper;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.ca.server.utils.oss.OssClientUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HTCAServiceImpl
implements HTCAService {
    private static final Logger log = LoggerFactory.getLogger(HTCAServiceImpl.class);
    @Autowired
    private CaDoctorMapper caDoctorMapper;
    @Autowired
    private HtCheckFaceRespLogMapper htCheckFaceRespLogMapper;
    @Autowired
    private HtCheckFaceReqLogMapper htCheckFaceReqLogMapper;
    @Autowired
    SettingConfig settingConfig;
    @Autowired
    private IDoctorApiClient doctorApiClient;
    @Autowired
    private IOssApi ossApi;
    @Autowired
    private HTCACossHelper htcaCossHelper;
    @Autowired
    private HTCABiopsyHelper htcaBiopsyHelper;

    public ActivationCodeVO checkFaceIdAndGetActivationCode(CheckFaceIdReqVO checkFaceIdReqVO) {
        if (checkFaceIdReqVO == null) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryUserInfoRespVO userInfoRespVO = this.htcaCossHelper.queryUserInfoByIdNumber(checkFaceIdReqVO.getIdNumber());
        CaDoctorEntity tbDoctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(checkFaceIdReqVO.getDoctorId().toString(), checkFaceIdReqVO.getAppCode(), PlatformEnum.HT_CA.getValue());
        if (tbDoctorEntity == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u9519\u8bef");
        }
        if (!this.settingConfig.getTestMode().booleanValue()) {
            log.info("=======\u8c03\u7528\u6d3b\u4f53\u6821\u9a8c=======");
            CheckFaceIdVO checkFaceIdVO = new CheckFaceIdVO();
            BeanUtils.copyProperties((Object)checkFaceIdReqVO, (Object)checkFaceIdVO);
            checkFaceIdVO.setUserTransId(UUIDUtils.getUUID());
            CheckFaceIdRespVO checkFaceIdRespVO = this.htcaBiopsyHelper.checkFaceId(checkFaceIdVO);
            String identityResult = checkFaceIdRespVO.getIdentityResult();
            if ("2".equals(identityResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u59d3\u540d\u9a8c\u8bc1\u4e0d\u4e00\u81f4");
            }
            if ("3".equals(identityResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u59d3\u540d\u9a8c\u8bc1\u5e93\u4e2d\u65e0\u6b64\u53f7");
            }
            if ("4".equals(identityResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u59d3\u540d\u9a8c\u8bc1\u5176\u4ed6\u9519\u8bef");
            }
            String faceResult = checkFaceIdRespVO.getFaceResult();
            if ("0".equals(faceResult) || null == faceResult) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u6821\u9a8c\u5931\u8d25");
            }
            if ("2".equals(faceResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u7cfb\u7edf\u5224\u65ad\u4e3a\u4e0d\u540c\u4eba");
            }
            if ("3".equals(faceResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5e93\u4e2d\u65e0\u7167\u7247");
            }
            if ("4".equals(faceResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5176\u4ed6\u9519\u8bef");
            }
            if ("5".equals(faceResult)) {
                throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u7528\u6237\u7167\u7247\u8d28\u91cf\u4e0d\u4f73");
            }
        }
        ActivationCodeVO activationCodeVO = this.htcaCossHelper.getActivationCode(userInfoRespVO.getUserId());
        activationCodeVO.setUserId(userInfoRespVO.getUserId());
        return activationCodeVO;
    }

    @Transactional
    public void checkUserIdentity(CheckUserIdentityReqVO checkUserIdentityReqVO) {
        log.info(checkUserIdentityReqVO.toString());
        BaseDTO baseDTO = new BaseDTO();
        Integer doctorId = checkUserIdentityReqVO.getDoctorId();
        baseDTO.setId(doctorId);
        BaseResponse doctorUserInfoVOBaseResponse = this.doctorApiClient.queryDoctorUserInfo(baseDTO);
        if (doctorUserInfoVOBaseResponse == null) {
            throw new BusinessException("\u533b\u751f\u670d\u52a1\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        DoctorUserInfoVO doctorUserInfoVO = (DoctorUserInfoVO)doctorUserInfoVOBaseResponse.getData();
        if (doctorUserInfoVO == null) {
            throw new BusinessException("\u533b\u751f\u670d\u52a1\u67e5\u4e0d\u5230\u533b\u751f\u4fe1\u606f\uff01");
        }
        if (!checkUserIdentityReqVO.getName().equals(doctorUserInfoVO.getName()) && checkUserIdentityReqVO.getIdNumber().equals(doctorUserInfoVO.getCredNo())) {
            log.info("\u4f20\u8fc7\u6765\u7684doctorId\uff1a" + doctorId);
            log.info("\u7cfb\u7edf\u4e2d\u7684\u59d3\u540d\uff1a" + doctorUserInfoVO.getName());
            log.info("\u7cfb\u7edf\u4e2d\u7684\u8bc1\u4ef6\u53f7" + doctorUserInfoVO.getCredNo());
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u548c\u7cfb\u7edf\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4e2a\u4eba\u4fe1\u606f\uff01");
        }
        if (!checkUserIdentityReqVO.getName().equals(doctorUserInfoVO.getName()) && !checkUserIdentityReqVO.getIdNumber().equals(doctorUserInfoVO.getCredNo())) {
            log.info("\u4f20\u8fc7\u6765\u7684doctorId\uff1a" + doctorId);
            log.info("\u7cfb\u7edf\u4e2d\u7684\u59d3\u540d\uff1a" + doctorUserInfoVO.getName());
            log.info("\u7cfb\u7edf\u4e2d\u7684\u8bc1\u4ef6\u53f7\uff1a" + doctorUserInfoVO.getCredNo());
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u548c\u7cfb\u7edf\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4e2a\u4eba\u4fe1\u606f\uff01");
        }
        QueryUserInfoRespVO userInfoRespVO = this.htcaCossHelper.queryUserInfoByIdNumber(checkUserIdentityReqVO.getIdNumber());
        if (userInfoRespVO == null || null == userInfoRespVO.getUserId()) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u9662\u65b9\u7ba1\u7406\u5458\u6ce8\u518c\u4fe1\u606f\uff01");
        }
        CaDoctorEntity tbDoctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(doctorId.toString(), checkUserIdentityReqVO.getAppCode(), PlatformEnum.HT_CA.getValue());
        if (tbDoctorEntity == null) {
            CaDoctorEntity caDoctorEntity = new CaDoctorEntity();
            caDoctorEntity.setDoctorId(doctorId.toString());
            caDoctorEntity.setDoctorName(checkUserIdentityReqVO.getName());
            caDoctorEntity.setOpenId(userInfoRespVO.getUserId());
            caDoctorEntity.setUserStatus(UserStatusEnum.AUDITED_PASS.getValue());
            caDoctorEntity.setOrganCode(checkUserIdentityReqVO.getAppCode());
            caDoctorEntity.setPlatform(PlatformEnum.HT_CA.getValue());
            caDoctorEntity.setStatus(Integer.valueOf(1));
            this.caDoctorMapper.insert(caDoctorEntity);
        }
    }

    public AddSignJobAndGetResultRespVO addSignJobAndGetResult(AddSignJobAndGetResultReqVO addSignJobAndGetResultReqVO) {
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(addSignJobAndGetResultReqVO.getDoctorId(), addSignJobAndGetResultReqVO.getAppCode(), PlatformEnum.HT_CA.getValue());
        if (doctorEntity == null || doctorEntity.getOpenId() == null || "".equals(doctorEntity.getOpenId())) {
            throw new BusinessException("\u7528\u6237\u6ca1\u6709\u901a\u8fc7CA\u8ba4\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884cCA\u7b7e\u540d\uff01");
        }
        String signDataId = this.htcaCossHelper.addSignJobAndGetSignResult(addSignJobAndGetResultReqVO.getJsonData());
        if (signDataId == null || "".equals(signDataId)) {
            throw new BusinessException("\u9662\u65b9\u8fd4\u56de\u7684signDataId\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u7b7e\u540d\u4efb\u52a1\u5931\u8d25\uff01");
        }
        AddSignJobAndGetResultRespVO addSignJobAndGetResultRespVO = new AddSignJobAndGetResultRespVO();
        addSignJobAndGetResultRespVO.setUserId(doctorEntity.getOpenId());
        addSignJobAndGetResultRespVO.setSignDataId(signDataId);
        return addSignJobAndGetResultRespVO;
    }

    public String getStamp(String doctorId, String appCode) {
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(doctorId, appCode, PlatformEnum.HT_CA.getValue());
        if (doctorEntity == null || doctorEntity.getOpenId() == null || "".equals(doctorEntity.getOpenId())) {
            throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u901a\u8fc7CA\u8ba4\u8bc1\uff0c\u65e0\u6cd5\u67e5\u8be2CA\u7b7e\u7ae0\uff01");
        }
        if (doctorEntity.getStamp() != null && !"".equals(doctorEntity.getStamp())) {
            return doctorEntity.getStamp();
        }
        String base64Image = this.htcaCossHelper.getBase64ImageByUserId(doctorEntity.getOpenId());
        String rootDir = DateTimeUtil.getYear((Date)new Date()) + "/" + DateTimeUtil.getMonth((Date)new Date()) + "/" + DateTimeUtil.getDayOfMonth((Date)new Date());
        Map map = OssClientUtil.uploadBase64Image((String)rootDir, (String)base64Image);
        String picUrl = map.get("urlpath").toString();
        doctorEntity.setStamp(picUrl);
        this.caDoctorMapper.updateByPrimaryKeySelective(doctorEntity);
        return picUrl;
    }

    public String getUserId(String doctorId, String appCode) {
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndAppCode(doctorId, appCode, PlatformEnum.HT_CA.getValue());
        if (doctorEntity == null) {
            return null;
        }
        return doctorEntity.getOpenId();
    }

    public void checkFaceId(CardCheckFaceIdReqVO cardCheckFaceIdReqVO) {
        log.info("=======\u8c03\u7528\u6d3b\u4f53\u6821\u9a8c=======");
        CheckFaceIdVO checkFaceIdVO = new CheckFaceIdVO();
        BeanUtils.copyProperties((Object)cardCheckFaceIdReqVO, (Object)checkFaceIdVO);
        checkFaceIdVO.setUserTransId(UUIDUtils.getUUID());
        HtCheckFaceReqLog checkFaceReqLog = new HtCheckFaceReqLog();
        checkFaceReqLog.setViewId(UUIDUtils.getUUID());
        checkFaceReqLog.setStatus(Integer.valueOf(1));
        checkFaceReqLog.setUserTransId(checkFaceIdVO.getUserTransId());
        checkFaceReqLog.setName(checkFaceIdVO.getName());
        checkFaceReqLog.setIdNumber(checkFaceIdVO.getIdNumber());
        this.htCheckFaceReqLogMapper.insert(checkFaceReqLog);
        CheckFaceIdRespVO checkFaceIdRespVO = this.htcaBiopsyHelper.checkFaceId(checkFaceIdVO);
        HtCheckFaceRespLog checkFaceRespLog = new HtCheckFaceRespLog();
        checkFaceRespLog.setViewId(UUIDUtils.getUUID());
        checkFaceRespLog.setStatus(Integer.valueOf(1));
        checkFaceRespLog.setResultCode(checkFaceIdRespVO.getResultCode());
        checkFaceRespLog.setResultMessage(checkFaceIdRespVO.getResultMessage());
        checkFaceRespLog.setIdentityResult(checkFaceIdRespVO.getIdentityResult());
        checkFaceRespLog.setFaceResult(checkFaceIdRespVO.getFaceResult());
        checkFaceRespLog.setUserTransId(checkFaceIdRespVO.getUserTransId());
        checkFaceRespLog.setTransId(checkFaceIdRespVO.getTransId());
        this.htCheckFaceRespLogMapper.insert(checkFaceRespLog);
        String identityResult = checkFaceIdRespVO.getIdentityResult();
        if ("2".equals(identityResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u59d3\u540d\u9a8c\u8bc1\u4e0d\u4e00\u81f4");
        }
        if ("3".equals(identityResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u59d3\u540d\u9a8c\u8bc1\u5e93\u4e2d\u65e0\u6b64\u53f7");
        }
        if ("4".equals(identityResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u59d3\u540d\u9a8c\u8bc1\u5176\u4ed6\u9519\u8bef");
        }
        String faceResult = checkFaceIdRespVO.getFaceResult();
        if ("0".equals(faceResult) || null == faceResult) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u6821\u9a8c\u5931\u8d25");
        }
        if ("2".equals(faceResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u7cfb\u7edf\u5224\u65ad\u4e3a\u4e0d\u540c\u4eba");
        }
        if ("3".equals(faceResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5e93\u4e2d\u65e0\u7167\u7247");
        }
        if ("4".equals(faceResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5176\u4ed6\u9519\u8bef");
        }
        if ("5".equals(faceResult)) {
            throw new BusinessException("\u6d3b\u4f53\u6821\u9a8c\u5931\u8d25-\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u7528\u6237\u7167\u7247\u8d28\u91cf\u4e0d\u4f73");
        }
    }
}

