/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.ca.server.common.database.JdbcTemplateDao;
import com.ebaiyihui.ca.server.common.enums.StampStatusEnum;
import com.ebaiyihui.ca.server.common.enums.UserStatusEnum;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.mapper.CaDoctorMapper;
import com.ebaiyihui.ca.server.mapper.HbcaCertMapper;
import com.ebaiyihui.ca.server.mapper.HbcaSignRecordsMapper;
import com.ebaiyihui.ca.server.mapper.HbcaUserMapper;
import com.ebaiyihui.ca.server.pojo.EmpowerReqVO;
import com.ebaiyihui.ca.server.pojo.entity.CaDoctorEntity;
import com.ebaiyihui.ca.server.pojo.entity.ConfigDic;
import com.ebaiyihui.ca.server.pojo.entity.HbcaCert;
import com.ebaiyihui.ca.server.pojo.entity.HbcaSignRecords;
import com.ebaiyihui.ca.server.pojo.entity.HbcaUserVo;
import com.ebaiyihui.ca.server.pojo.hbca.AccessTokenReqVo;
import com.ebaiyihui.ca.server.pojo.hbca.AddCaCertResVo;
import com.ebaiyihui.ca.server.pojo.hbca.BaseReponsVo;
import com.ebaiyihui.ca.server.pojo.hbca.GetAuthCodeReq;
import com.ebaiyihui.ca.server.pojo.hbca.SignReq;
import com.ebaiyihui.ca.server.service.ConfigDicService;
import com.ebaiyihui.ca.server.service.HbcaUserService;
import com.ebaiyihui.ca.server.utils.BASE64DecodedMultipartFile;
import com.ebaiyihui.ca.server.utils.HttpClientUtil;
import com.ebaiyihui.ca.server.utils.ywx.TokenUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class HbcaUserServiceImpl
implements HbcaUserService {
    private static final Logger log = LoggerFactory.getLogger(HbcaUserServiceImpl.class);
    @Autowired
    private HbcaUserMapper hbcaUserMapper;
    @Autowired
    private HbcaCertMapper hbcaCertMapper;
    @Autowired
    private HbcaSignRecordsMapper hbcaSignRecordsMapper;
    @Autowired
    private TokenUtil tokenUtil;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private CaDoctorMapper caDoctorMapper;
    @Autowired
    private JdbcTemplateDao jdbcTemplateDao;
    @Autowired
    private ConfigDicService configDicService;
    private final String HBCA_AUTH_CODE = "hbca_auth_code";
    private final String PASS_ERRO_NUM = "PASS_ERRO_NUM";

    @Transactional(rollbackFor={Exception.class})
    public void empower(HbcaUserVo hbcaUserVo) {
        ConfigDic configDic = this.configDicService.getByHospitalId(hbcaUserVo.getOrganId());
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        String url = configDic.getUrl() + "/cert/api/add";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("certType", "1");
        paramMap.put("userName", hbcaUserVo.getUserName());
        paramMap.put("userCode", hbcaUserVo.getIdNo());
        log.info("\u8bc1\u4e66\u6388\u6743\u8bf7\u6c42url\uff1a", (Object)url);
        log.info("\u8bf7\u6c42\u53c2\u6570param:" + JSONObject.toJSONString(paramMap));
        String reponsData = HttpClientUtil.doPost((String)url, paramMap, (String)("Bearer " + this.tokenUtil.getToken(String.valueOf(hbcaUserVo.getOrganId()))));
        log.info("\u8bc1\u4e66\u6388\u6743 - \u54cd\u5e94 - {}", (Object)reponsData);
        if (reponsData == null || "".equals(reponsData)) {
            throw new BusinessException("\u8bc1\u4e66\u6ce8\u518c\u8fd4\u56de\u4e3a\u7a7a");
        }
        BaseReponsVo reponsVo = (BaseReponsVo)JSON.parseObject((String)reponsData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (0 != reponsVo.getCode()) {
            throw new BusinessException(reponsVo.getMessage());
        }
        if (ObjectUtil.isNull((Object)reponsVo.getData())) {
            throw new BusinessException("\u6ce8\u518cca\u4fe1\u606f\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
        }
        AddCaCertResVo resVo = (AddCaCertResVo)reponsVo.getData();
        HbcaCert hbcaCert = new HbcaCert();
        hbcaCert.setCertSubjectId(resVo.getCertSubjectId());
        hbcaCert.setCert(resVo.getSignCertSN());
        hbcaCert.setCertIssuer("HBCA");
        hbcaCert.setStartDate(resVo.getNotBefore());
        hbcaCert.setEndDate(resVo.getNotAfter());
        hbcaCert.setCertSn(resVo.getEncryptCertSN());
        hbcaCert.setDoctorId(String.valueOf(hbcaUserVo.getDoctorId()));
        hbcaCert.setOrganId(String.valueOf(hbcaUserVo.getOrganId()));
        hbcaCert.setDoctorName(hbcaUserVo.getUserName());
        hbcaCert.setAppCode(hbcaUserVo.getAppId());
        hbcaCert.setIdNo(hbcaUserVo.getIdNo());
        hbcaCert.setTelephone(hbcaUserVo.getTelephone());
        hbcaCert.setPassWord("123456");
        this.hbcaCertMapper.insertSelective(hbcaCert);
        this.addCaDoctorData(hbcaUserVo, hbcaCert);
    }

    public void addCaDoctorData(HbcaUserVo hbcaUserVo, HbcaCert hbcaCert) {
        CaDoctorEntity caDoctorEntity = new CaDoctorEntity();
        caDoctorEntity.setDoctorId(String.valueOf(hbcaUserVo.getDoctorId()));
        caDoctorEntity.setUserStatus(Integer.valueOf(0));
        caDoctorEntity.setStatusTime(new Date());
        caDoctorEntity.setDoctorName(hbcaUserVo.getUserName());
        caDoctorEntity.setDepartment(hbcaUserVo.getDeptName());
        caDoctorEntity.setOrgName(hbcaUserVo.getOrganName());
        caDoctorEntity.setUid(hbcaUserVo.getIdNo());
        caDoctorEntity.setUidCardType("SF");
        caDoctorEntity.setPhone(hbcaUserVo.getTelephone());
        caDoctorEntity.setDoctorType("QT");
        caDoctorEntity.setTitle(hbcaUserVo.getProfession());
        caDoctorEntity.setIssueOrg("\u6cb3\u5317\u7701\u7535\u5b50\u8ba4\u8bc1\u6709\u9650\u516c\u53f8");
        caDoctorEntity.setOrganCode(hbcaUserVo.getAppId());
        caDoctorEntity.setHospitalId(hbcaUserVo.getOrganId());
        caDoctorEntity.setIssueTime(hbcaCert.getStartDate());
        caDoctorEntity.setValidTime(hbcaCert.getEndDate());
        CaDoctorEntity doctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(hbcaUserVo.getDoctorId(), hbcaUserVo.getOrganId());
        if (ObjectUtil.isNull((Object)doctorEntity)) {
            this.caDoctorMapper.save(caDoctorEntity);
        } else {
            caDoctorEntity.setId(doctorEntity.getId());
            this.caDoctorMapper.updateByPrimaryKeySelective(caDoctorEntity);
        }
    }

    public HbcaCert getCaCert(EmpowerReqVO empowerReqVO) {
        HbcaCert certByDoctorIdAndOrganId = this.hbcaCertMapper.getCertByDoctorIdAndOrganId(empowerReqVO.getDoctorId(), empowerReqVO.getOrganId());
        if (ObjectUtil.isNull((Object)certByDoctorIdAndOrganId)) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u5230\u7528\u6237\u8bc1\u4e66");
        }
        certByDoctorIdAndOrganId.setCerFlag("0");
        String endDate = certByDoctorIdAndOrganId.getEndDate();
        DateTime parse = DateUtil.parse((String)endDate, (String)"yyyy-MM-dd HH:mm:ss");
        if (new Date().after((Date)parse)) {
            certByDoctorIdAndOrganId.setCerFlag("1");
        }
        return certByDoctorIdAndOrganId;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseReponsVo<String> verifySign(SignReq verifySignReqVo) {
        HbcaCert certByDoctorIdAndOrganId = this.hbcaCertMapper.getCertByDoctorIdAndOrganId(verifySignReqVo.getDoctorId(), verifySignReqVo.getOrganId());
        if (ObjectUtil.isNull((Object)certByDoctorIdAndOrganId)) {
            throw new BusinessException("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0\u8bc1\u4e66");
        }
        BaseReponsVo reponsVo = this.invoSign(verifySignReqVo, certByDoctorIdAndOrganId);
        BaseReponsVo baseReponsVo = this.invoTimeSign(verifySignReqVo);
        HbcaSignRecords hbcaSignRecords = new HbcaSignRecords();
        hbcaSignRecords.setHbcaUserId(certByDoctorIdAndOrganId.getId());
        hbcaSignRecords.setCertSn(certByDoctorIdAndOrganId.getCertSn());
        hbcaSignRecords.setCert(certByDoctorIdAndOrganId.getCert());
        hbcaSignRecords.setMsg(verifySignReqVo.getCertData());
        hbcaSignRecords.setSignValue((String)reponsVo.getData());
        hbcaSignRecords.setValidTimestamp((String)baseReponsVo.getData());
        this.hbcaSignRecordsMapper.insertSelective(hbcaSignRecords);
        return reponsVo;
    }

    public BaseResponse<String> getAuthCode(GetAuthCodeReq getAuthCodeReq) {
        HbcaCert hbcaCert = this.hbcaCertMapper.selectByCertSubId(getAuthCodeReq.getCertSubjectId());
        String hkey = getAuthCodeReq.getCertSubjectId() + "-num";
        String count = this.jedisCluster.hget(hkey, "PASS_ERRO_NUM");
        if ("3".equals(count)) {
            BaseResponse response = new BaseResponse();
            response.setData((Object)"3");
            response.setMsg("\u5bc6\u7801\u8fde\u7eed\u9519\u8bef\u4e09\u6b21\uff0c\u5341\u5206\u949f\u540e\u518d\u8bd5");
            response.setCode("0");
            return response;
        }
        if (!getAuthCodeReq.getData().trim().equals(hbcaCert.getPassWord())) {
            Boolean hexists = this.jedisCluster.hexists(hkey, "PASS_ERRO_NUM");
            if (hexists.booleanValue()) {
                String num = this.jedisCluster.hget(hkey, "PASS_ERRO_NUM");
                int iNmu = Integer.valueOf(num) + 1;
                this.jedisCluster.hset(hkey, "PASS_ERRO_NUM", String.valueOf(iNmu));
                this.jedisCluster.expire(hkey, 600);
                return BaseResponse.error((String)("\u5bc6\u7801\u8fde\u7eed\u9519\u8bef" + iNmu + "\u6b21"));
            }
            this.jedisCluster.hset(hkey, "PASS_ERRO_NUM", "1");
            this.jedisCluster.expire(hkey, 600);
            return BaseResponse.error((String)"\u5bc6\u7801\u9519\u8bef");
        }
        BaseReponsVo baseReponsVo = this.invoGetAuthCode(getAuthCodeReq);
        return BaseResponse.success((Object)baseReponsVo.getData());
    }

    @Transactional(rollbackFor={Exception.class})
    public void certDelay(String certSubjectId, String organId) {
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(organId));
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        HbcaCert hbcaCert = this.hbcaCertMapper.selectByCertSubId(certSubjectId);
        if (ObjectUtil.isNull((Object)hbcaCert)) {
            throw new BusinessException("\u627e\u4e0d\u5230\u8be5\u8bc1\u4e66\uff0c\u8bf7\u6838\u5bf9");
        }
        String url = configDic.getUrl() + "/cert/api/delay";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("certSubjectId", hbcaCert.getCertSubjectId());
        log.info("\u8bc1\u4e66\u5ef6\u671furl\uff1a" + url);
        log.info("\u8bf7\u6c42\u53c2\u6570param:" + JSONObject.toJSONString(paramMap));
        String reponsData = HttpClientUtil.doPost((String)url, paramMap, (String)("Bearer " + this.tokenUtil.getToken(organId)));
        log.info("\u8bc1\u4e66\u5ef6\u671f - \u54cd\u5e94 - {}", (Object)reponsData);
        if (reponsData == null || "".equals(reponsData)) {
            throw new BusinessException("\u8bc1\u4e66\u5ef6\u671f\u8fd4\u56de\u4e3a\u7a7a");
        }
        BaseReponsVo reponsVo = (BaseReponsVo)JSON.parseObject((String)reponsData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (0 != reponsVo.getCode()) {
            throw new BusinessException(reponsVo.getMessage());
        }
        if (ObjectUtil.isNull((Object)reponsVo.getData())) {
            throw new BusinessException("\u8bc1\u4e66\u5ef6\u671f\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
        }
        AddCaCertResVo resVo = (AddCaCertResVo)reponsVo.getData();
        hbcaCert.setCertSubjectId(resVo.getCertSubjectId());
        hbcaCert.setCert(resVo.getSignCertSN());
        hbcaCert.setCertIssuer("HBCA");
        hbcaCert.setStartDate(resVo.getNotBefore());
        hbcaCert.setEndDate(resVo.getNotAfter());
        hbcaCert.setCertSn(resVo.getEncryptCertSN());
        this.hbcaCertMapper.updateByPrimaryKeySelective(hbcaCert);
    }

    public void saveSign(String doctorId, String signUrl) {
        String sql = "select * from hbca_cert where doctor_id = ?";
        HbcaCert hbcaCert = (HbcaCert)this.jdbcTemplateDao.get(sql, new Object[]{doctorId}, HbcaCert.class);
        if (ObjectUtil.isNull((Object)hbcaCert)) {
            throw new BusinessException("\u8be5\u533b\u751f\u6ca1\u6709\u67e5\u5230\u8bc1\u4e66");
        }
        hbcaCert.setSignUrl(signUrl);
        this.hbcaCertMapper.updateByPrimaryKeySelective(hbcaCert);
        CaDoctorEntity caDoctorEntity = this.caDoctorMapper.getByDoctorIdAndHospitalId(Long.valueOf(Long.parseLong(doctorId)), Long.valueOf(Long.parseLong(hbcaCert.getOrganId())));
        if (ObjectUtil.isNotNull((Object)caDoctorEntity)) {
            caDoctorEntity.setStampStatus(StampStatusEnum.AUDITED_PASS.getValue());
            caDoctorEntity.setUserStatus(UserStatusEnum.SET_STAMP.getValue());
            caDoctorEntity.setStamp(signUrl);
            caDoctorEntity.setStatusTime(new Date());
            this.caDoctorMapper.updateByPrimaryKeySelective(caDoctorEntity);
        }
    }

    public void updatePassWord(String organId, String doctorId, String passWord) {
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(organId));
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        String sql = "select * from hbca_cert where doctor_id = ?";
        HbcaCert hbcaCert = (HbcaCert)this.jdbcTemplateDao.get(sql, new Object[]{doctorId}, HbcaCert.class);
        if (ObjectUtil.isNull((Object)hbcaCert)) {
            throw new BusinessException("\u8be5\u533b\u751f\u6ca1\u6709\u67e5\u5230\u8bc1\u4e66");
        }
        String url = configDic.getUrl() + "/cert/api/changepassword";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("oldPassword", hbcaCert.getPassWord());
        paramMap.put("certSubjectId", hbcaCert.getCertSubjectId());
        paramMap.put("newPassword", passWord);
        log.info("\u4fee\u6539\u5bc6\u7801\u8bf7\u6c42url\uff1a" + url);
        log.info("\u8bf7\u6c42\u53c2\u6570param:" + JSONObject.toJSONString(paramMap));
        String reponsData = HttpClientUtil.doPost((String)url, paramMap, (String)("Bearer " + this.tokenUtil.getToken(organId)));
        log.info("\u4fee\u6539\u5bc6\u7801 - \u54cd\u5e94 - {}", (Object)reponsData);
        if (reponsData == null || "".equals(reponsData)) {
            throw new BusinessException("\u4fee\u6539\u5bc6\u7801\u8fd4\u56de\u4e3a\u7a7a");
        }
        BaseReponsVo reponsVo = (BaseReponsVo)JSON.parseObject((String)reponsData, BaseReponsVo.class);
        if (0 != reponsVo.getCode()) {
            throw new BusinessException(reponsVo.getMessage());
        }
        hbcaCert.setPassWord(passWord);
        this.hbcaCertMapper.updateByPrimaryKeySelective(hbcaCert);
    }

    public BaseReponsVo<String> invoGetAuthCode(GetAuthCodeReq getAuthCodeReq) {
        BaseReponsVo baseReponsVo = new BaseReponsVo();
        ConfigDic configDic = this.configDicService.getByHospitalId(getAuthCodeReq.getOrganId());
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        String url = configDic.getUrl() + "/cert/api/authcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("type", getAuthCodeReq.getType());
        paramMap.put("data", getAuthCodeReq.getData());
        paramMap.put("certSubjectId", getAuthCodeReq.getCertSubjectId());
        log.info("\u83b7\u53d6\u8bc1\u4e66\u6388\u6743\u7801url\uff1a" + url);
        log.info("\u8bf7\u6c42\u53c2\u6570param:" + JSONObject.toJSONString(paramMap));
        String reponsData = HttpClientUtil.doPost((String)url, paramMap, (String)("Bearer " + this.tokenUtil.getToken(String.valueOf(getAuthCodeReq.getOrganId()))));
        log.info("\u83b7\u53d6\u8bc1\u4e66\u6388\u6743\u7801 - \u54cd\u5e94 - {}", (Object)reponsData);
        if (reponsData == null || "".equals(reponsData)) {
            throw new BusinessException("\u83b7\u53d6\u8bc1\u4e66\u6388\u6743\u7801\u8fd4\u56de\u4e3a\u7a7a");
        }
        BaseReponsVo reponsVo = (BaseReponsVo)JSON.parseObject((String)reponsData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (0 != reponsVo.getCode()) {
            throw new BusinessException(reponsVo.getMessage());
        }
        if (ObjectUtil.isNull((Object)reponsVo.getData())) {
            throw new BusinessException("\u83b7\u53d6\u8bc1\u4e66\u6388\u6743\u7801\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
        }
        String authcode = ((AccessTokenReqVo)reponsVo.getData()).getAuthcode();
        if (StringUtils.isEmpty((Object)authcode)) {
            throw new BusinessException("authcode\u6388\u6743\u7801\u83b7\u53d6\u4e3a\u7a7a");
        }
        baseReponsVo.setData((Object)authcode);
        return baseReponsVo;
    }

    public BaseReponsVo<String> invoSign(SignReq verifySignReqVo, HbcaCert hbcaCert) {
        ConfigDic configDic = this.configDicService.getByHospitalId(verifySignReqVo.getOrganId());
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        String url = configDic.getUrl() + "/cert/api/sign";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("dataB64", BASE64DecodedMultipartFile.stringToBase64((String)verifySignReqVo.getCertData()));
        paramMap.put("certSubjectId", hbcaCert.getCertSubjectId());
        paramMap.put("authCode", verifySignReqVo.getAuthCode());
        log.info("\u6570\u5b57\u7b7e\u540d\u8bf7\u6c42url\uff1a" + url);
        log.info("\u8bf7\u6c42\u53c2\u6570param:" + JSONObject.toJSONString(paramMap));
        String reponsData = HttpClientUtil.doPost((String)url, paramMap, (String)("Bearer " + this.tokenUtil.getToken(String.valueOf(verifySignReqVo.getOrganId()))));
        log.info("\u6570\u5b57\u7b7e\u540d - \u54cd\u5e94 - {}", (Object)reponsData);
        if (reponsData == null || "".equals(reponsData)) {
            throw new BusinessException("\u6570\u5b57\u7b7e\u540d\u8fd4\u56de\u4e3a\u7a7a");
        }
        BaseReponsVo reponsVo = (BaseReponsVo)JSON.parseObject((String)reponsData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (0 != reponsVo.getCode()) {
            throw new BusinessException(reponsVo.getMessage());
        }
        if (ObjectUtil.isNull((Object)reponsVo.getData())) {
            throw new BusinessException("\u6570\u5b57\u7b7e\u540d\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
        }
        return reponsVo;
    }

    public BaseReponsVo<String> invoTimeSign(SignReq verifySignReqVo) {
        ConfigDic configDic = this.configDicService.getByHospitalId(verifySignReqVo.getOrganId());
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        String url = configDic.getUrl() + "/timestamp/api/sign";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("data", BASE64DecodedMultipartFile.stringToBase64((String)verifySignReqVo.getCertData()));
        log.info("\u7b7e\u53d1\u65f6\u95f4\u6233\u8bf7\u6c42url\uff1a", (Object)url);
        log.info("\u8bf7\u6c42\u53c2\u6570param:" + JSONObject.toJSONString(paramMap));
        String reponsData = HttpClientUtil.doPost((String)url, paramMap, (String)("Bearer " + this.tokenUtil.getToken(String.valueOf(verifySignReqVo.getOrganId()))));
        log.info("\u7b7e\u53d1\u65f6\u95f4\u6233 - \u54cd\u5e94 - {}", (Object)reponsData);
        if (reponsData == null || "".equals(reponsData)) {
            throw new BusinessException("\u7b7e\u53d1\u65f6\u95f4\u6233\u8fd4\u56de\u4e3a\u7a7a");
        }
        BaseReponsVo reponsVo = (BaseReponsVo)JSON.parseObject((String)reponsData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (0 != reponsVo.getCode()) {
            throw new BusinessException(reponsVo.getMessage());
        }
        if (ObjectUtil.isNull((Object)reponsVo.getData())) {
            throw new BusinessException("\u6570\u5b57\u7b7e\u540d\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
        }
        return reponsVo;
    }
}

