/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.mapper.MzjhUserMapper;
import com.ebaiyihui.ca.server.pojo.entity.MzjhUser;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.CommonRespVO;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.UserRegisterAndUpdateReqVO;
import com.ebaiyihui.ca.server.pojo.mzjh.vo.UserStatusReqVO;
import com.ebaiyihui.ca.server.service.MzjhUserService;
import com.ebaiyihui.ca.server.third.mzjh.MzRequestHelper;
import com.ebaiyihui.ca.vo.UserCertificationStatusRespVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MzjhUserServiceImpl
implements MzjhUserService {
    @Autowired
    private MzRequestHelper mzRequestHelper;
    @Autowired
    private MzjhUserMapper mzjhUserMapper;

    public MzjhUser getUserInfoByDoctorIdAndOrganId(Long doctorId, Long organId) {
        return this.mzjhUserMapper.getUserInfoByDoctorIdAndOrganId(doctorId, organId);
    }

    public void addUser(MzjhUser mzjhUser) {
        this.mzjhUserMapper.insertSelective(mzjhUser);
    }

    public void updateUser(MzjhUser mjhUser) {
        this.mzjhUserMapper.updateByPrimaryKeySelective(mjhUser);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void empower(MzjhUser mzjhUser, UserRegisterAndUpdateReqVO userRegisterAndUpdateReqVO) {
        this.addUser(mzjhUser);
        CommonRespVO commonRespVO = this.mzRequestHelper.userRegister(userRegisterAndUpdateReqVO);
        String ret = commonRespVO.getRet();
        if (!"success".equals(ret)) {
            String msg = commonRespVO.getMsg();
            throw new BusinessException(msg);
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void enable(MzjhUser tbMzjhUser, UserStatusReqVO userStatusReqVO) {
        tbMzjhUser.setUserStatusCode(UserStatusReqVO.UserStatus.enable.getCode());
        tbMzjhUser.setUserStatusName(UserStatusReqVO.UserStatus.enable.getName());
        this.updateUser(tbMzjhUser);
        CommonRespVO commonRespVO = this.mzRequestHelper.updateUserStatus(userStatusReqVO);
        String ret = commonRespVO.getRet();
        if (!"success".equals(ret)) {
            String msg = commonRespVO.getMsg();
            throw new BusinessException(msg);
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void disable(MzjhUser tbMzjhUser, UserStatusReqVO userStatusReqVO) {
        tbMzjhUser.setUserStatusCode(UserStatusReqVO.UserStatus.disable.getCode());
        tbMzjhUser.setUserStatusName(UserStatusReqVO.UserStatus.disable.getName());
        this.updateUser(tbMzjhUser);
        CommonRespVO commonRespVO = this.mzRequestHelper.updateUserStatus(userStatusReqVO);
        String ret = commonRespVO.getRet();
        if (!"success".equals(ret)) {
            String msg = commonRespVO.getMsg();
            throw new BusinessException(msg);
        }
    }

    public void logOffUser(MzjhUser tbMzjhUser, UserStatusReqVO userStatusReqVO) {
        tbMzjhUser.setUserStatusCode(UserStatusReqVO.UserStatus.logoff.getCode());
        tbMzjhUser.setUserStatusName(UserStatusReqVO.UserStatus.logoff.getName());
        this.updateUser(tbMzjhUser);
        CommonRespVO commonRespVO = this.mzRequestHelper.updateUserStatus(userStatusReqVO);
        String ret = commonRespVO.getRet();
        if (!"success".equals(ret)) {
            String msg = commonRespVO.getMsg();
            throw new BusinessException(msg);
        }
    }

    public UserCertificationStatusRespVO getUserCertificationStatus(Long doctorId, Long organId) {
        return this.mzjhUserMapper.getUserCertificationStatus(doctorId, organId);
    }
}

