/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.ca.server.common.properties.CommonProperties;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.rc.AddUserVo;
import com.ebaiyihui.ca.server.pojo.rc.AuthUserInfoVo;
import com.ebaiyihui.ca.server.pojo.rc.AuthUserRespVo;
import com.ebaiyihui.ca.server.pojo.rc.GetTssVo;
import com.ebaiyihui.ca.server.pojo.rc.SignJobRespVo;
import com.ebaiyihui.ca.server.pojo.rc.SignJobVo;
import com.ebaiyihui.ca.server.pojo.rc.TssInfoVo;
import com.ebaiyihui.ca.server.pojo.rc.verifySignVo;
import com.ebaiyihui.ca.server.pojo.rc.verifyTssVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.QueryUserInfoRespVO;
import com.ebaiyihui.ca.server.service.RcCaService;
import com.ebaiyihui.ca.server.utils.ht.HTTPUtils;
import com.ebaiyihui.ca.server.utils.ht.RequestUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RcCaServiceImpl
implements RcCaService {
    private static final Logger log = LoggerFactory.getLogger(RcCaServiceImpl.class);
    @Resource
    private CommonProperties commonProperties;
    private static final Integer SUCCESS_CODE = 200;

    public BaseResponse<AuthUserRespVo> getAuthCodeWithIdenVerify(AuthUserInfoVo vo) {
        log.info("\u4ea7\u751f\u6fc0\u6d3b\u7801\u5165\u53c2\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("userId", vo.getUserId());
        map.put("idNumber", vo.getIdNumber());
        map.put("idType", vo.getIdType());
        map.put("userName", vo.getUserName());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/getAuthCodeWithIdenVerify  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/getAuthCodeWithIdenVerify").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u4ea7\u751f\u6fc0\u6d3b\u7801\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        AuthUserRespVo authUserRespVo = new AuthUserRespVo();
        authUserRespVo.setAuthCode(dataObject.getString("authCode"));
        authUserRespVo.setCode(dataObject.getString("code"));
        return BaseResponse.success((Object)authUserRespVo);
    }

    public BaseResponse<SignJobRespVo> addSignJob(SignJobVo vo) {
        log.info("\u6dfb\u52a0\u7b7e\u540d\u4efb\u52a1\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        if (StringUtils.isNotEmpty((String)vo.getUserId())) {
            map.put("userId", vo.getUserId());
        }
        if (StringUtils.isNotEmpty((String)vo.getDescription())) {
            map.put("description", vo.getDescription());
        }
        if (StringUtils.isNotEmpty((String)vo.getExpiryDate())) {
            map.put("expiryDate", vo.getExpiryDate());
        }
        if (StringUtils.isNotEmpty((String)vo.getCallBackUrl())) {
            map.put("callBackUrl", vo.getCallBackUrl());
        }
        map.put("title", vo.getTitle());
        map.put("dataType", "DATA");
        map.put("algo", "SM3withSM2");
        map.put("data", vo.getData());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/addSignJob  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/addSignJob").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u6dfb\u52a0\u7b7e\u540d\u4efb\u52a1\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        SignJobRespVo signJobRespVo = new SignJobRespVo();
        signJobRespVo.setSignDataId(dataObject.getString("signDataId"));
        signJobRespVo.setSignature(dataObject.getString("signature"));
        signJobRespVo.setCert(dataObject.getString("cert"));
        signJobRespVo.setQrCode(dataObject.getString("qrCode"));
        return BaseResponse.success((Object)signJobRespVo);
    }

    public BaseResponse<String> createAndGetTssInfo(TssInfoVo vo) {
        log.info("\u4ea7\u751f\u65f6\u95f4\u6233\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("oriData", vo.getOriData());
        map.put("attachCert", vo.getAttachCert());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/createAndGetTssInfo  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/createAndGetTssInfo").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u4ea7\u751f\u65f6\u95f4\u6233\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        return BaseResponse.success((Object)dataObject.getString("tsResp"));
    }

    public BaseResponse<String> getTSInfo(GetTssVo vo) {
        log.info("\u89e3\u6790\u65f6\u95f4\u6233\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("tsResp", vo.getTsResp());
        map.put("type", vo.getType());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/getTSInfo  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/getTSInfo").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        return BaseResponse.success((Object)dataObject.getString("tsInfo"));
    }

    public BaseResponse<String> verifyTS(verifyTssVo vo) {
        log.info("\u9a8c\u8bc1\u65f6\u95f4\u6233\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("oriData", vo.getOriData());
        map.put("tsResp", vo.getTsResp());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/verifyTS  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/verifyTS").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        return BaseResponse.success((Object)dataObject.getString("verifyRes"));
    }

    public BaseResponse<String> addUser(AddUserVo vo) {
        log.info("\u6dfb\u52a0\u7528\u6237\u5165\u53c2\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("idNumber", vo.getIdNumber());
        map.put("idType", vo.getIdType());
        map.put("userName", vo.getUserName());
        map.put("mobile", vo.getPhone());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/addUser  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/addUser").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        return BaseResponse.success((Object)dataObject.getString("userId"));
    }

    public BaseResponse<QueryUserInfoRespVO> queryUserInfo(String idNumber) {
        log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)idNumber);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("idType", "SF");
        map.put("idNumber", idNumber);
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/queryUserInfo  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/queryUserInfo").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        QueryUserInfoRespVO queryUserInfoRespVO = new QueryUserInfoRespVO();
        queryUserInfoRespVO.setUserId(dataObject.getString("msspId"));
        queryUserInfoRespVO.setUserName(dataObject.getString("username"));
        queryUserInfoRespVO.setOrgId(dataObject.getString("orgId"));
        return BaseResponse.success((Object)queryUserInfoRespVO);
    }

    public BaseResponse verifySign(verifySignVo vo) {
        log.info("\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u5165\u53c2\uff1a{}", (Object)vo);
        StringBuffer url = new StringBuffer(this.commonProperties.getBiopsyReqDomain());
        Map map = this.getMap();
        map.put("signAlg", "SM3withSM2");
        map.put("plain", vo.getPlain());
        map.put("signValue", vo.getSignValue());
        map.put("cert", vo.getCert());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson((Map)map, (String)this.commonProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/verifySign  param\uff1a" + requestJson);
            resp = HTTPUtils.post((String)url.append("/verifySign").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        return BaseResponse.success();
    }

    public Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("version", this.commonProperties.getBiopsyVersion());
        map.put("appId", this.commonProperties.getBiopsyAppId());
        map.put("signAlgo", this.commonProperties.getBiopsySignAlgo());
        return map;
    }
}

