/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import cn.hutool.json.JSONObject;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.entity.ConfigDic;
import com.ebaiyihui.ca.server.pojo.sc.DigitalCertListReq;
import com.ebaiyihui.ca.server.pojo.sc.DigitalCertListRes;
import com.ebaiyihui.ca.server.pojo.sc.SealQuery;
import com.ebaiyihui.ca.server.pojo.sc.SealQueryRes;
import com.ebaiyihui.ca.server.pojo.sc.SignReq;
import com.ebaiyihui.ca.server.pojo.sc.SignRes;
import com.ebaiyihui.ca.server.pojo.sc.VerifyReq;
import com.ebaiyihui.ca.server.service.ConfigDicService;
import com.ebaiyihui.ca.server.service.ScCaService;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.ca.server.utils.sm3tools.HttpUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScCaServiceImpl
implements ScCaService {
    private static final Logger log = LoggerFactory.getLogger(ScCaServiceImpl.class);
    @Autowired
    private ConfigDicService configDicService;
    private static final String SUCCESS_CODE = "true";

    public BaseResponse<SignRes> sign(SignReq vo) {
        log.info("SC-CA-LOG", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(vo.getOrgId().intValue()));
        log.info("SC-CONFIGDIC {}", (Object)configDic);
        try {
            vo.setSignatureAlgID("SM2");
            vo.setHashAlgID("SM3");
            vo.setDataType("HASH");
            vo.setTransId(UUIDUtils.getUUID());
            vo.setToSign(String.valueOf(vo.getToSign().hashCode()));
            com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
            param.remove((Object)"orgId");
            log.info("SC-IN-SIGN {}", (Object)param);
            String res = HttpUtils.postJson((String)(configDic.getUrl() + "/open/signature/sign"), (String)com.alibaba.fastjson.JSONObject.toJSONString((Object)param), new HashMap(), (String)configDic.getClientId(), (String)configDic.getSecret());
            JSONObject json = new JSONObject((Object)res);
            if (!SUCCESS_CODE.equals(String.valueOf(json.getStr((Object)"success")))) {
                if ("\u8bc1\u4e66\u4e0d\u5b58\u5728".equals(json.getStr((Object)"result_msg"))) {
                    return BaseResponse.error((String)"\u8bf7\u524d\u5f80\u3010\u533b\u62a4\u5b9d\u3011\u6ce8\u518c\u7533\u9886\u8bc1\u4e66");
                }
                return BaseResponse.error((String)json.getStr((Object)"result_msg"));
            }
            SignRes signRes = (SignRes)com.alibaba.fastjson.JSONObject.parseObject((String)json.getStr((Object)"body"), SignRes.class);
            return BaseResponse.success((Object)signRes);
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u5b57\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    public BaseResponse<String> verify(VerifyReq vo) {
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(vo.getOrgId().intValue()));
        log.info("SC-CONFIGDIC {}", (Object)configDic);
        log.info("SC-CA-LOG", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
        try {
            vo.setTransId(null);
            vo.setSignatureAlgID("SM2");
            vo.setHashAlgID("SM3");
            vo.setToSign(String.valueOf(vo.getToSign().hashCode()));
            com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
            param.remove((Object)"orgId");
            log.info("SC-IN-VERIFY {}", (Object)param);
            String res = HttpUtils.postJson((String)(configDic.getUrl() + "open/signature/verify"), (String)com.alibaba.fastjson.JSONObject.toJSONString((Object)param), new HashMap(), (String)configDic.getClientId(), (String)configDic.getSecret());
            JSONObject json = new JSONObject((Object)res);
            if (!SUCCESS_CODE.equals(String.valueOf(json.getStr((Object)"success")))) {
                return BaseResponse.error((String)json.getStr((Object)"result_msg"));
            }
            return BaseResponse.success((Object)json.getStr((Object)"body"));
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u5b57\u8bc1\u4e66\u7b7e\u540d\u9a8c\u8bc1\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    public BaseResponse<SealQueryRes> sealQuery(SealQuery vo) {
        log.info("SC-CA-LOG{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(vo.getOrgId().intValue()));
        log.info("SC-CONFIGDIC {}", (Object)configDic);
        try {
            com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
            param.remove((Object)"orgId");
            log.info("SC-IN-SEALQUERY {}", (Object)param);
            String res = HttpUtils.postJson((String)(configDic.getUrl() + "/open/signature/sealQuerysealQue"), (String)com.alibaba.fastjson.JSONObject.toJSONString((Object)param), new HashMap(), (String)configDic.getClientId(), (String)configDic.getSecret());
            JSONObject json = new JSONObject((Object)res);
            if (!SUCCESS_CODE.equals(String.valueOf(json.getStr((Object)"success")))) {
                return BaseResponse.error((String)json.getStr((Object)"result_msg"));
            }
            List item = com.alibaba.fastjson.JSONObject.parseArray((String)json.getStr((Object)"body"), SealQueryRes.class);
            item.sort(Comparator.comparing(SealQueryRes::getMakeEsealTime).reversed());
            return BaseResponse.success(item.get(0));
        }
        catch (Exception e) {
            throw new BusinessException("\u533b\u751f\u7b7e\u67e5\u8be2\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    public BaseResponse<List<DigitalCertListRes>> digitalCertList(DigitalCertListReq vo) {
        log.info("SC-CA-LOG{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(vo.getOrgId().intValue()));
        log.info("SC-CONFIGDIC {}", (Object)configDic);
        try {
            com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo));
            param.remove((Object)"orgId");
            log.info("SC-IN-DIGITALCERTLIST {}", (Object)param);
            String res = HttpUtils.postJson((String)(configDic.getUrl() + "/open/digitalCert/list"), (String)com.alibaba.fastjson.JSONObject.toJSONString((Object)param), new HashMap(), (String)configDic.getClientId(), (String)configDic.getSecret());
            JSONObject json = new JSONObject((Object)res);
            if (!SUCCESS_CODE.equals(String.valueOf(json.getStr((Object)"success")))) {
                return BaseResponse.error((String)json.getStr((Object)"result_msg"));
            }
            List item = com.alibaba.fastjson.JSONObject.parseArray((String)json.getStr((Object)"body"), DigitalCertListRes.class);
            if (item == null || item.size() < 1) {
                return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8bc1\u4e66");
            }
            return BaseResponse.success((Object)item);
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u5b57\u8bc1\u4e66\u67e5\u8be2\u5f02\u5e38\uff01" + e.getMessage());
        }
    }
}

