/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.service.impl;

import com.ebaiyihui.ca.server.mapper.SzCertMapper;
import com.ebaiyihui.ca.server.pojo.entity.SzCertEntity;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.SzCaEditPasswordReqVo;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.SzCaSaveSignReqVo;
import com.ebaiyihui.ca.server.service.impl.SzCertService;
import com.ebaiyihui.ca.server.utils.UUIDUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SzCertServiceImpl
implements SzCertService {
    @Autowired
    SzCertMapper szCertMapper;

    public BaseResponse getDoctorCert(Long doctorId) {
        SzCertEntity szCertEntity = this.szCertMapper.selectByDoctorId(doctorId);
        if (Objects.isNull(szCertEntity)) {
            return BaseResponse.error((String)"\u60a8\u5c1a\u672a\u5b8c\u6210\u8d44\u8d28\u8ba4\u8bc1,\u8bf7\u5148\u5b8c\u6210\u6388\u6743\u8ba4\u8bc1");
        }
        return BaseResponse.success((Object)szCertEntity);
    }

    public BaseResponse editPassword(SzCaEditPasswordReqVo szCaEditPasswordReqVo) {
        SzCertEntity szCertEntity = this.szCertMapper.selectByDoctorId(szCaEditPasswordReqVo.getDoctorId());
        if (!StringUtils.isEmpty((Object)szCertEntity.getPassword()) && szCertEntity.getPassword().equals(szCaEditPasswordReqVo.getPassword())) {
            return BaseResponse.error((String)"\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e00\u81f4,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        this.szCertMapper.updatePasswordByDoctorId(szCaEditPasswordReqVo.getDoctorId(), szCaEditPasswordReqVo.getPassword());
        return BaseResponse.success((Object)"\u5bc6\u7801\u8bbe\u7f6e\u6210\u529f");
    }

    public BaseResponse certLogin(SzCaEditPasswordReqVo szCaEditPasswordReqVo) {
        SzCertEntity szCertEntity = this.szCertMapper.selectByDoctorId(szCaEditPasswordReqVo.getDoctorId());
        if (Objects.isNull(szCertEntity)) {
            return BaseResponse.error((String)"\u6682\u4e0d\u80fd\u4f7f\u7528.\u60a8\u5c1a\u672a\u5b8c\u6210\u8d44\u8d28\u8ba4\u8bc1,\u8bf7\u5148\u5b8c\u6210\u6388\u6743\u8ba4\u8bc1");
        }
        if (!szCertEntity.getPassword().equals(szCaEditPasswordReqVo.getPassword())) {
            int loginNum = szCertEntity.getLoginNum() + 1;
            this.szCertMapper.updateLoginNunByDoctorId(szCaEditPasswordReqVo.getDoctorId(), loginNum);
            szCertEntity = this.szCertMapper.selectByDoctorId(szCaEditPasswordReqVo.getDoctorId());
            if (szCertEntity.getLoginNum() > 2) {
                return BaseResponse.error((String)"\u60a8\u5df2\u8fde\u7eed\u8f93\u95193\u6b21\u5bc6\u7801,\u4e3a\u4fdd\u8bc1\u8d26\u53f7\u5b89\u5168,\u8bf7\u91cd\u7f6e\u5bc6\u7801\u540e\u518d\u8bd5");
            }
            return BaseResponse.error((String)"\u5bc6\u7801\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u8bd5");
        }
        if (szCertEntity.getLoginNum() > 2) {
            return BaseResponse.error((String)"\u60a8\u5df2\u8fde\u7eed\u8f93\u95193\u6b21\u5bc6\u7801,\u4e3a\u4fdd\u8bc1\u8d26\u53f7\u5b89\u5168,\u8bf7\u91cd\u7f6e\u5bc6\u7801\u540e\u518d\u8bd5");
        }
        return BaseResponse.success();
    }

    public BaseResponse saveSign(String appCode, SzCaSaveSignReqVo szCaSaveSignReqVo) {
        SzCertEntity szCertEntity = this.szCertMapper.selectByDoctorId(szCaSaveSignReqVo.getDoctorId());
        if (Objects.isNull(szCertEntity)) {
            return BaseResponse.error((String)"\u6682\u4e0d\u80fd\u4f7f\u7528.\u60a8\u5c1a\u672a\u5b8c\u6210\u8d44\u8d28\u8ba4\u8bc1,\u8bf7\u5148\u5b8c\u6210\u6388\u6743\u8ba4\u8bc1");
        }
        this.szCertMapper.updateSignByDoctorId(szCaSaveSignReqVo.getDoctorId(), szCaSaveSignReqVo.getUrl());
        return BaseResponse.success();
    }

    public BaseResponse getSign(String appCode, Long doctorId) {
        SzCertEntity szCertEntity = new SzCertEntity();
        szCertEntity = this.szCertMapper.selectByDoctorId(doctorId);
        if (Objects.isNull(szCertEntity)) {
            return BaseResponse.error((String)"\u6682\u4e0d\u80fd\u4f7f\u7528.\u60a8\u5c1a\u672a\u5b8c\u6210\u8d44\u8d28\u8ba4\u8bc1,\u8bf7\u5148\u5b8c\u6210\u6388\u6743\u8ba4\u8bc1");
        }
        if (StringUtils.isEmpty((Object)szCertEntity.getSign())) {
            return BaseResponse.error((String)"");
        }
        return BaseResponse.success((Object)szCertEntity.getSign());
    }

    public BaseResponse newSaveSign(String appCode, SzCaSaveSignReqVo szCaSaveSignReqVo) {
        SzCertEntity szCertEntity = new SzCertEntity();
        szCertEntity.setDoctorId(szCaSaveSignReqVo.getDoctorId());
        szCertEntity.setApplyId(UUIDUtils.getUUID());
        szCertEntity.setSign(szCaSaveSignReqVo.getUrl());
        this.szCertMapper.newInsert(szCertEntity);
        return BaseResponse.success();
    }
}

