/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.third;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.ca.server.common.properties.HTProperties;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.vo.ht.req.CheckFaceIdVO;
import com.ebaiyihui.ca.server.pojo.vo.ht.resp.CheckFaceIdRespVO;
import com.ebaiyihui.ca.server.utils.ht.HTTPUtils;
import com.ebaiyihui.ca.server.utils.ht.RequestUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HTCABiopsyHelper {
    private static final Logger log = LoggerFactory.getLogger(HTCABiopsyHelper.class);
    private static final Integer SUCCESS_CODE = 200;
    @Autowired
    private HTProperties htProperties;

    public CheckFaceIdRespVO checkFaceId(CheckFaceIdVO checkFaceIdVO) {
        StringBuffer url = new StringBuffer(this.htProperties.getBiopsyReqDomain());
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("deviceId", this.htProperties.getBiopsyDeviceId());
        map.put("appId", this.htProperties.getBiopsyAppId());
        map.put("signAlgo", this.htProperties.getBiopsySignAlgo());
        map.put("version", this.htProperties.getBiopsyVersion());
        map.put("userTransId", checkFaceIdVO.getUserTransId());
        map.put("name", checkFaceIdVO.getName());
        map.put("idNumber", checkFaceIdVO.getIdNumber());
        map.put("userPhoto", checkFaceIdVO.getUserPhoto());
        String requestJson = null;
        try {
            requestJson = RequestUtils.generateRequestJson(map, (String)this.htProperties.getBiopsySecret());
        }
        catch (Exception e) {
            throw new BusinessException("generateRequestJson\u5f02\u5e38\uff01");
        }
        System.out.println(requestJson);
        String resp = null;
        try {
            log.info("url\uff1a" + url.toString() + "/identityFace/checkIdface");
            resp = HTTPUtils.post((String)url.append("/identityFace/checkIdface").toString(), (String)requestJson);
            if (resp == null) {
                throw new BusinessException("\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4e24\u9879\u5b9e\u4f53\u6821\u9a8c\u8c03\u7528\u5f02\u5e38\uff01");
        }
        log.info("resp\uff1a" + resp);
        JSONObject jsonObject = JSON.parseObject((String)resp);
        Integer status = jsonObject.getInteger("status");
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!SUCCESS_CODE.equals(status)) {
            throw new BusinessException("\u4eba\u8138\u8bc6\u522b\u6821\u9a8c\u5931\u8d25\uff1a" + dataObject.getString("errMsg"));
        }
        CheckFaceIdRespVO checkFaceIdRespVO = new CheckFaceIdRespVO();
        checkFaceIdRespVO.setResultCode(dataObject.getInteger("resultCode"));
        checkFaceIdRespVO.setResultMessage(dataObject.getString("resultMessage"));
        checkFaceIdRespVO.setIdentityResult(dataObject.getString("identityResult"));
        checkFaceIdRespVO.setFaceResult(dataObject.getString("faceResult"));
        checkFaceIdRespVO.setUserTransId(dataObject.getString("userTransId"));
        checkFaceIdRespVO.setTransId(dataObject.getString("transId"));
        return checkFaceIdRespVO;
    }
}

