/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.utils;

import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class QRCodeUtil {
    private static final String CHARSET = "utf-8";
    private static final String FORMAT_NAME = "JPG";
    private static final int QRCODE_SIZE = 300;
    private static final int WIDTH = 60;
    private static final int HEIGHT = 60;

    private static BufferedImage createImage(String content, String imgPath, boolean needCompress) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 300, 300, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (imgPath == null || "".equals(imgPath)) {
            return image;
        }
        QRCodeUtil.insertImage((BufferedImage)image, (String)imgPath, (boolean)needCompress);
        return image;
    }

    private static void insertImage(BufferedImage source, String imgPath, boolean needCompress) throws Exception {
        File file = new File(imgPath);
        if (!file.exists()) {
            System.err.println("" + imgPath + "   \u8be5\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        Image src = ImageIO.read(new File(imgPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > 60) {
                width = 60;
            }
            if (height > 60) {
                height = 60;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (300 - width) / 2;
        int y = (300 - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public static BufferedImage encode(String content, String imgPath, String destPath, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage((String)content, (String)imgPath, (boolean)needCompress);
        return image;
    }

    public static BufferedImage encode(String content, String imgPath, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage((String)content, (String)imgPath, (boolean)needCompress);
        return image;
    }

    public static void mkdirs(String destPath) {
        File file = new File(destPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static void encode(String content, String imgPath, String destPath) throws Exception {
        QRCodeUtil.encode((String)content, (String)imgPath, (String)destPath, (boolean)false);
    }

    public static void encode(String content, String destPath) throws Exception {
        QRCodeUtil.encode((String)content, null, (String)destPath, (boolean)false);
    }

    public static void encode(String content, String imgPath, OutputStream output, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage((String)content, (String)imgPath, (boolean)needCompress);
        ImageIO.write((RenderedImage)image, "JPG", output);
    }

    public static void encode(String content, OutputStream output) throws Exception {
        QRCodeUtil.encode((String)content, null, (OutputStream)output, (boolean)false);
    }

    public static String decode(File file) throws Exception {
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }

    public static String decode(String path) throws Exception {
        return QRCodeUtil.decode((File)new File(path));
    }
}

