/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.utils.card;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RegUtils {
    private static final HashMap<String, String> CITY_MAP = new HashMap();

    private RegUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isMobileSimple(CharSequence input) {
        return RegUtils.isMatch((String)"^[1]\\d{10}$", (CharSequence)input);
    }

    public static boolean isMobileExact(CharSequence input) {
        return RegUtils.isMatch((String)"^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(16[6])|(17[0,1,3,5-8])|(18[0-9])|(19[1,8,9]))\\d{8}$", (CharSequence)input);
    }

    public static boolean isTel(CharSequence input) {
        return RegUtils.isMatch((String)"^0\\d{2,3}[- ]?\\d{7,8}", (CharSequence)input);
    }

    public static boolean isIDCard15(CharSequence input) {
        return RegUtils.isMatch((String)"^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", (CharSequence)input);
    }

    public static boolean isIDCard18(CharSequence input) {
        return RegUtils.isMatch((String)"^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$", (CharSequence)input);
    }

    public static boolean isIDCard18Exact(CharSequence input) {
        if (RegUtils.isIDCard18((CharSequence)input)) {
            int[] factor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
            char[] suffix = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
            if (CITY_MAP.isEmpty()) {
                CITY_MAP.put("11", "\u5317\u4eac");
                CITY_MAP.put("12", "\u5929\u6d25");
                CITY_MAP.put("13", "\u6cb3\u5317");
                CITY_MAP.put("14", "\u5c71\u897f");
                CITY_MAP.put("15", "\u5185\u8499\u53e4");
                CITY_MAP.put("21", "\u8fbd\u5b81");
                CITY_MAP.put("22", "\u5409\u6797");
                CITY_MAP.put("23", "\u9ed1\u9f99\u6c5f");
                CITY_MAP.put("31", "\u4e0a\u6d77");
                CITY_MAP.put("32", "\u6c5f\u82cf");
                CITY_MAP.put("33", "\u6d59\u6c5f");
                CITY_MAP.put("34", "\u5b89\u5fbd");
                CITY_MAP.put("35", "\u798f\u5efa");
                CITY_MAP.put("36", "\u6c5f\u897f");
                CITY_MAP.put("37", "\u5c71\u4e1c");
                CITY_MAP.put("41", "\u6cb3\u5357");
                CITY_MAP.put("42", "\u6e56\u5317");
                CITY_MAP.put("43", "\u6e56\u5357");
                CITY_MAP.put("44", "\u5e7f\u4e1c");
                CITY_MAP.put("45", "\u5e7f\u897f");
                CITY_MAP.put("46", "\u6d77\u5357");
                CITY_MAP.put("50", "\u91cd\u5e86");
                CITY_MAP.put("51", "\u56db\u5ddd");
                CITY_MAP.put("52", "\u8d35\u5dde");
                CITY_MAP.put("53", "\u4e91\u5357");
                CITY_MAP.put("54", "\u897f\u85cf");
                CITY_MAP.put("61", "\u9655\u897f");
                CITY_MAP.put("62", "\u7518\u8083");
                CITY_MAP.put("63", "\u9752\u6d77");
                CITY_MAP.put("64", "\u5b81\u590f");
                CITY_MAP.put("65", "\u65b0\u7586");
                CITY_MAP.put("71", "\u53f0\u6e7e");
                CITY_MAP.put("81", "\u9999\u6e2f");
                CITY_MAP.put("82", "\u6fb3\u95e8");
                CITY_MAP.put("91", "\u56fd\u5916");
            }
            if (CITY_MAP.get(input.subSequence(0, 2).toString()) != null) {
                int weightSum = 0;
                for (int i = 0; i < 17; ++i) {
                    weightSum += (input.charAt(i) - 48) * factor[i];
                }
                int idCardMod = weightSum % 11;
                char idCardLast = input.charAt(17);
                return idCardLast == suffix[idCardMod];
            }
        }
        return false;
    }

    public static boolean isEmail(CharSequence input) {
        return RegUtils.isMatch((String)"^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$", (CharSequence)input);
    }

    public static boolean isURL(CharSequence input) {
        return RegUtils.isMatch((String)"[a-zA-z]+://[^\\s]*", (CharSequence)input);
    }

    public static boolean isZh(CharSequence input) {
        return RegUtils.isMatch((String)"^[\\u4e00-\\u9fa5]+$", (CharSequence)input);
    }

    public static boolean isUsername(CharSequence input) {
        return RegUtils.isMatch((String)"^[\\w\\u4e00-\\u9fa5]{6,20}(?<!_)$", (CharSequence)input);
    }

    public static boolean isDate(CharSequence input) {
        return RegUtils.isMatch((String)"^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$", (CharSequence)input);
    }

    public static boolean isIP(CharSequence input) {
        return RegUtils.isMatch((String)"((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)", (CharSequence)input);
    }

    public static boolean isMatch(String regex, CharSequence input) {
        return input != null && input.length() > 0 && Pattern.matches(regex, input);
    }

    public static List<String> getMatches(String regex, CharSequence input) {
        if (input == null) {
            return Collections.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    public static String[] getSplits(String input, String regex) {
        if (input == null) {
            return new String[0];
        }
        return input.split(regex);
    }

    public static String getReplaceFirst(String input, String regex, String replacement) {
        if (input == null) {
            return "";
        }
        return Pattern.compile(regex).matcher(input).replaceFirst(replacement);
    }

    public static String getReplaceAll(String input, String regex, String replacement) {
        if (input == null) {
            return "";
        }
        return Pattern.compile(regex).matcher(input).replaceAll(replacement);
    }
}

