/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.utils.sm3tools;

import com.ebaiyihui.ca.server.utils.sm3tools.HMACUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.reflections.Reflections;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Decoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtils {
    private static final RestTemplate template = new RestTemplate();

    public static String postJson(String uri, String json, Map<String, String> headerParams, String appId, String secret) {
        HttpHeaders header = HttpUtils.getHeaders(headerParams, (String)json, (String)appId, (String)secret);
        header.add("Content-Type", "application/json;charset=UTF-8");
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)header);
        return HttpUtils.execute((String)uri, (HttpEntity)entity);
    }

    public static String postForm(String uri, Map<String, Object> data, Map<String, String> headerParams, String appId, String secret) {
        StringBuilder toSign = new StringBuilder();
        TreeMap<String, Object> orderMap = new TreeMap<String, Object>(data);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        orderMap.forEach((arg_0, arg_1) -> HttpUtils.lambda$postForm$0(toSign, (MultiValueMap)form, arg_0, arg_1));
        HttpHeaders header = HttpUtils.getHeaders(headerParams, (String)toSign.toString(), (String)appId, (String)secret);
        HttpEntity entity = new HttpEntity((Object)form, (MultiValueMap)header);
        return HttpUtils.execute((String)uri, (HttpEntity)entity);
    }

    private static HttpHeaders getHeaders(Map<String, String> headerParams, String toSign, String appId, String secret) {
        HttpHeaders headers = new HttpHeaders();
        if (headerParams != null) {
            headerParams.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        String nonce = HttpUtils.nonce();
        String ts = String.valueOf(System.currentTimeMillis());
        String ori = toSign.concat(nonce).concat(ts);
        String signature = HttpUtils.signature((String)ori, (String)secret);
        headers.add("signature", signature);
        headers.add("app_id", appId);
        headers.add("nonce", nonce);
        headers.add("timestamp", ts);
        Reflections.log.info("SC-HEADERS {}", (Object)headers);
        return headers;
    }

    private static String nonce() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replaceAll("[^0-9]", "");
    }

    private static String execute(String url, HttpEntity<?> entity) throws RuntimeException {
        Reflections.log.info("SC-URL {}", (Object)url);
        Reflections.log.info("SC-ENTITY {}", entity);
        ResponseEntity result = template.postForEntity(url, entity, String.class, new Object[0]);
        Reflections.log.info("SC-RESULT {}", (Object)result);
        if (result.getStatusCodeValue() == 200) {
            return (String)result.getBody();
        }
        throw new RuntimeException("\u8bf7\u6c42\u670d\u52a1\u5668\u51fa\u9519");
    }

    private static String signature(String toSign, String secret) {
        return HttpUtils.calc((String)toSign, (String)secret);
    }

    private static String calc(String toSign, String secret) {
        try {
            byte[] bytes = HMACUtils.hmacSM3((byte[])toSign.getBytes(StandardCharsets.UTF_8), (byte[])secret.getBytes(StandardCharsets.UTF_8));
            return HMACUtils.byteArrayToHexString((byte[])bytes);
        }
        catch (Throwable var4) {
            throw new RuntimeException("hmac\u7b7e\u540d\u5931\u8d25.", var4);
        }
    }

    public static boolean GenerateImage(String imgStr, String path) {
        if (imgStr == null) {
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            FileOutputStream out = new FileOutputStream(path);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$postForm$0(StringBuilder toSign, MultiValueMap form, String k, Object v) {
        if (v instanceof String) {
            toSign.append(v);
            form.add((Object)k, v);
        } else {
            if (!(v instanceof File)) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b: " + v.getClass().getSimpleName());
            }
            form.add((Object)k, (Object)new FileSystemResource((File)v));
        }
    }
}

