/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.ca.server.utils.ywx;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.ca.common.dto.AccessTokenDTO;
import com.ebaiyihui.ca.common.dto.AccessTokenData;
import com.ebaiyihui.ca.server.common.database.JdbcTemplateDao;
import com.ebaiyihui.ca.server.common.properties.CommonProperties;
import com.ebaiyihui.ca.server.exception.BusinessException;
import com.ebaiyihui.ca.server.pojo.entity.ConfigDic;
import com.ebaiyihui.ca.server.pojo.hbca.AccessTokenReqVo;
import com.ebaiyihui.ca.server.pojo.ywx.GnTokenResVo;
import com.ebaiyihui.ca.server.service.ConfigDicService;
import com.ebaiyihui.ca.server.utils.BASE64DecodedMultipartFile;
import com.ebaiyihui.ca.server.utils.HttpClientUtil;
import com.ebaiyihui.ca.server.utils.JsonUtil;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    @Autowired
    private CommonProperties commonProperties;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private JdbcTemplateDao jdbcTemplateDao;
    @Autowired
    private ConfigDicService configDicService;
    private String token = null;
    private static final String CLIENT_ID = "hebcatest";
    private static final String SERCRET = "123456";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAccessToken(String url, String clientId, String secret) {
        if (url == null || clientId == null || secret == null) {
            throw new BusinessException("url\u6216clientId\u6216secret\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.token = this.jedisCluster.get(clientId);
        if (this.token != null && !"".equals(this.token.trim())) return this.token;
        Class<TokenUtil> clazz = TokenUtil.class;
        synchronized (TokenUtil.class) {
            if (this.token != null && !"".equals(this.token.trim())) return this.token;
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("clientId", clientId);
            paramMap.put("appSecret", secret);
            String convertObject = JsonUtil.convertObject(paramMap);
            String result = null;
            try {
                log.info("\u83b7\u53d6access_token - \u8bf7\u6c42 - url:{}, param:{}", (Object)url, (Object)convertObject);
                result = HttpClientUtil.doGet((String)url, paramMap);
                log.info("\u83b7\u53d6access_token - \u54cd\u5e94 - {}", (Object)result);
            }
            catch (Exception e) {
                log.info("clientId\uff1a" + clientId);
                log.info("secret\uff1a" + secret);
                throw new BusinessException("\u83b7\u53d6token\u7684\u8c03\u7528\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6\uff01" + e.getMessage());
            }
            if (StringUtils.isEmpty((String)result)) {
                throw new BusinessException("\u83b7\u53d6token\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01" + convertObject);
            }
            AccessTokenDTO accessTokenDTO = (AccessTokenDTO)JsonUtil.convertObject((String)result, AccessTokenDTO.class);
            if (accessTokenDTO == null || !"0".equals(accessTokenDTO.getStatus())) {
                throw new BusinessException("\u83b7\u53d6token\u5931\u8d25\uff01" + convertObject);
            }
            AccessTokenData accessTokenData = accessTokenDTO.getData();
            if (accessTokenData == null) {
                throw new BusinessException("\u83b7\u53d6token\u5931\u8d25\uff01" + convertObject);
            }
            this.token = accessTokenData.getAccessToken();
            this.jedisCluster.set(clientId, this.token);
            this.jedisCluster.expire(clientId, 300);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.token;
        }
    }

    public String getToken(String organId) {
        log.info("\u8bf7\u6c42\u533b\u9662code\uff1a" + organId);
        ConfigDic configDic = this.configDicService.getByHospitalId(Long.valueOf(organId));
        if (configDic == null) {
            throw new BusinessException("\u672c\u9662\u6ca1\u6709\u5f00\u901aCA\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\uff01");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("grant_type", "client_credentials");
        paramMap.put("scope", "all");
        String auth = BASE64DecodedMultipartFile.stringToBase64((String)(configDic.getClientId() + ":" + configDic.getSecret()));
        String convertObject = JsonUtil.convertObject(paramMap);
        String result = null;
        try {
            log.info("\u83b7\u53d6access_token - \u8bf7\u6c42 - url:{}, param:{}", (Object)(configDic.getUrl() + "/auth/oauth/token"), (Object)convertObject);
            result = HttpClientUtil.doPost((String)(configDic.getUrl() + "/auth/oauth/token"), paramMap, (String)("Basic " + auth));
            log.info("\u83b7\u53d6access_token - \u54cd\u5e94 - {}", (Object)result);
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6token\u7684\u8c03\u7528\u5f02\u5e38 \u7f51\u7edc\u9519\u8bef\u6216\u8bf7\u6c42\u8d85\u65f6\uff01" + e.getMessage());
        }
        if (StringUtils.isEmpty((String)result)) {
            throw new BusinessException("\u83b7\u53d6token\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01" + convertObject);
        }
        AccessTokenReqVo accessTokenReqVo = (AccessTokenReqVo)JsonUtil.convertObject((String)result, AccessTokenReqVo.class);
        if (accessTokenReqVo == null) {
            throw new BusinessException("\u83b7\u53d6token\u5931\u8d25\uff01" + convertObject);
        }
        String accessToken = accessTokenReqVo.getAccess_token();
        if (StringUtils.isBlank((String)accessToken)) {
            throw new BusinessException("\u83b7\u53d6token\u5931\u8d25\uff01" + convertObject);
        }
        return accessToken;
    }

    public static void main(String[] args) {
        String json = "{\"data\":\"3feb0643fe464ec9ae3f39c58fcbe057\",\"message\":\"success\",\"status\":\"0\"}";
        GnTokenResVo gnTokenResVo = (GnTokenResVo)JSON.parseObject((String)json, GnTokenResVo.class);
        System.out.println(gnTokenResVo.getData());
    }

    public String gnGetToken() {
        String url = "http://218.204.139.187:9999/gateway/common/getToken";
        String result = HttpClientUtil.doGet((String)url);
        log.info("\u8d63\u5357\u83b7\u53d6token\u8fd4\u56de\u503c" + result);
        if (StringUtils.isBlank((String)result)) {
            throw new BusinessException("\u83b7\u53d6token\u8fd4\u56de\u4e3a\u7a7a");
        }
        GnTokenResVo gnTokenResVo = (GnTokenResVo)JSON.parseObject((String)result, GnTokenResVo.class);
        if (StringUtils.isBlank((String)gnTokenResVo.getData())) {
            throw new BusinessException("\u83b7\u53d6token\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38");
        }
        if (!"0".equals(gnTokenResVo.getStatus())) {
            throw new BusinessException("\u83b7\u53d6token\u5931\u8d25" + gnTokenResVo.getMessage());
        }
        return gnTokenResVo.getData();
    }
}

