/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.cache.client;

import com.ebaiyihui.cache.client.error.RedisError;
import com.ebaiyihui.framework.common.ResultInfo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="service-cache-server", fallbackFactory=RedisError.class)
public interface RedisClient {
    @GetMapping(value={"/api/v1/redis/common/del"})
    public ResultInfo del(@RequestParam(value="key") String var1);

    @PostMapping(value={"/api/v1/redis/common/expire"})
    public ResultInfo expire(@RequestParam(value="key") String var1, @RequestParam(value="second") int var2);

    @GetMapping(value={"/api/v1/redis/common/gettimeoutbykey"})
    public ResultInfo getTimeoutByKey(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/common/type"})
    public ResultInfo type(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/common/pattern"})
    public ResultInfo keys(@RequestParam(value="pattern") String var1);

    @PostMapping(value={"/api/v1/redis/hash/hset"})
    public ResultInfo hset(@RequestParam(value="key") String var1, @RequestParam(value="field") String var2, @RequestParam(value="value") String var3);

    @PostMapping(value={"/api/v1/redis/hash/hsetandexpire"})
    public ResultInfo hset(@RequestParam(value="key") String var1, @RequestParam(value="field") String var2, @RequestParam(value="value") String var3, @RequestParam(value="second") int var4);

    @GetMapping(value={"/api/v1/redis/hash/hget"})
    public ResultInfo hget(@RequestParam(value="key") String var1, @RequestParam(value="field") String var2);

    @GetMapping(value={"/api/v1/redis/hash/hmget"})
    public ResultInfo<List<String>> hmget(@RequestParam(value="key") String var1, String ... var2);

    @PostMapping(value={"/api/v1/redis/hash/hmset"})
    public ResultInfo hmset(@RequestParam(value="key") String var1, @RequestBody(required=false) Map<String, String> var2);

    @PostMapping(value={"/api/v1/redis/hash/hmsetandexpire"})
    public ResultInfo hmset(@RequestParam(value="key") String var1, @RequestBody(required=false) Map<String, String> var2, @RequestParam(value="second") int var3);

    @PostMapping(value={"/api/v1/redis/hash/hincrby"})
    public ResultInfo hincrby(@RequestParam(value="key") String var1, @RequestParam(value="field") String var2, @RequestParam(value="value") long var3);

    @PostMapping(value={"/api/v1/redis/hash/hexists"})
    public ResultInfo hexists(@RequestParam(value="key") String var1, @RequestParam(value="field") String var2);

    @GetMapping(value={"/api/v1/redis/hash/hdel"})
    public ResultInfo hdel(@RequestParam(value="key") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/hash/hlen"})
    public ResultInfo hlen(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/hash/key"})
    public ResultInfo hkeys(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/hash/hvals"})
    public ResultInfo hvals(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/hash/hgetall"})
    public ResultInfo hgetall(@RequestParam(value="key") String var1);

    @PostMapping(value={"/api/v1/redis/list/rpush"})
    public ResultInfo rpush(@RequestParam(value="key") String var1, String ... var2);

    @PostMapping(value={"/api/v1/redis/list/lpushandexpire"})
    public ResultInfo lpush(@RequestParam(value="key") String var1, @RequestParam(value="second") int var2, String ... var3);

    @PostMapping(value={"/api/v1/redis/list/rpushandexpire"})
    public ResultInfo rpush(@RequestParam(value="key") String var1, @RequestParam(value="second") int var2, String ... var3);

    @PostMapping(value={"/api/v1/redis/list/lpush"})
    public ResultInfo lpush(@RequestParam(value="key") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/listllen"})
    public ResultInfo llen(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/list/lrange"})
    public ResultInfo lrange(@RequestParam(value="key") String var1, @RequestParam(value="start") Long var2, @RequestParam(value="end") Long var3);

    @GetMapping(value={"/api/v1/redis/list/ltrim"})
    public ResultInfo ltrim(@RequestParam(value="key") String var1, @RequestParam(value="start") Long var2, @RequestParam(value="end") Long var3);

    @GetMapping(value={"/api/v1/redis/list/lindex"})
    public ResultInfo lindex(@RequestParam(value="key") String var1, @RequestParam(value="index") Long var2);

    @PostMapping(value={"/api/v1/redis/list/lset"})
    public ResultInfo lset(@RequestParam(value="key") String var1, @RequestParam(value="index") Long var2, @RequestParam(value="value") String var3);

    @GetMapping(value={"/api/v1/redis/list/lrem"})
    public ResultInfo lrem(@RequestParam(value="key") String var1, @RequestParam(value="count") Long var2, @RequestParam(value="value") String var3);

    @GetMapping(value={"/api/v1/redis/list/lpop"})
    public ResultInfo lpop(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/list/rpop"})
    public ResultInfo rpop(@RequestParam(value="key") String var1);

    @PostMapping(value={"/api/v1/redis/set/sadd"})
    public ResultInfo sadd(@RequestParam(value="key") String var1, String ... var2);

    @PostMapping(value={"/api/v1/redis/set/saddandexpire"})
    public ResultInfo sadd(@RequestParam(value="key") String var1, @RequestParam(value="second") int var2, String ... var3);

    @GetMapping(value={"/api/v1/redis/set/srem"})
    public ResultInfo srem(@RequestParam(value="key") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/set/spop"})
    public ResultInfo spop(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/set/scard"})
    public ResultInfo scard(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/set/sismember"})
    public ResultInfo sismember(@RequestParam(value="key") String var1, @RequestParam(value="member") String var2);

    @GetMapping(value={"/api/v1/redis/set/sinter"})
    public ResultInfo sinter(String ... var1);

    @GetMapping(value={"/api/v1/redis/set/sinterstore"})
    public ResultInfo sinterstore(@RequestParam(value="dstkey") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/set/sunion"})
    public ResultInfo sunion(String ... var1);

    @GetMapping(value={"/api/v1/redis/set/sunionstore"})
    public ResultInfo sunionstore(@RequestParam(value="dstkey") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/set/sdiff"})
    public ResultInfo sdiff(String ... var1);

    @GetMapping(value={"/api/v1/redis/set/sdiffstore"})
    public ResultInfo sdiffstore(@RequestParam(value="dstkey") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/set/smembers"})
    public ResultInfo smembers(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/set/srandmember"})
    public ResultInfo srandmember(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/set/srandmemberandcount"})
    public ResultInfo srandmember(@RequestParam(value="key") String var1, @RequestParam(value="count") int var2);

    @PostMapping(value={"/api/v1/redis/string/set"})
    public ResultInfo set(@RequestParam(value="key") String var1, @RequestParam(value="value") String var2);

    @GetMapping(value={"/api/v1/redis/string/get"})
    public ResultInfo get(@RequestParam(value="key") String var1);

    @PostMapping(value={"/api/v1/redis/string/setandexpire"})
    public ResultInfo set(@RequestParam(value="key") String var1, @RequestParam(value="value") String var2, @RequestParam(value="second") int var3);

    @GetMapping(value={"/api/v1/redis/string/mget"})
    public ResultInfo mget(String ... var1);

    @PostMapping(value={"/api/v1/redis/string/mset"})
    public ResultInfo mset(String ... var1);

    @PostMapping(value={"/api/v1/redis/string/incr"})
    public ResultInfo incr(@RequestParam(value="key") String var1);

    @PostMapping(value={"/api/v1/redis/string/decr"})
    public ResultInfo decr(@RequestParam(value="keyValues") String var1);

    @GetMapping(value={"/api/v1/redis/string/haskey"})
    public ResultInfo hasKey(@RequestParam(value="key") String var1);

    @PostMapping(value={"/api/v1/redis/zset/zaddandexpire"})
    public ResultInfo zadd(@RequestParam(value="key") String var1, @RequestParam(value="score") double var2, @RequestParam(value="member") String var4, @RequestParam(value="second") int var5);

    @PostMapping(value={"/api/v1/redis/zset/zadd"})
    public ResultInfo zadd(@RequestParam(value="key") String var1, @RequestParam(value="score") double var2, @RequestParam(value="member") String var4);

    @GetMapping(value={"/api/v1/redis/zset/zrem"})
    public ResultInfo zrem(@RequestParam(value="key") String var1, String ... var2);

    @GetMapping(value={"/api/v1/redis/zset/zincrby"})
    public ResultInfo zincrby(@RequestParam(value="key") String var1, @RequestParam(value="score") double var2, @RequestParam(value="member") String var4);

    @GetMapping(value={"/api/v1/redis/zset/zrank"})
    public ResultInfo zrank(@RequestParam(value="key") String var1, @RequestParam(value="member") String var2);

    @GetMapping(value={"/api/v1/redis/zset/zrevrank"})
    public ResultInfo zrevrank(@RequestParam(value="key") String var1, @RequestParam(value="member") String var2);

    @GetMapping(value={"/api/v1/redis/zset/zrange"})
    public ResultInfo zrange(@RequestParam(value="key") String var1, @RequestParam(value="start") Long var2, @RequestParam(value="end") Long var3);

    @GetMapping(value={"/api/v1/redis/zset/zrevrange"})
    public ResultInfo zrevrange(@RequestParam(value="key") String var1, @RequestParam(value="start") Long var2, @RequestParam(value="end") Long var3);

    @GetMapping(value={"/api/v1/redis/zset/zrangebyscore"})
    public ResultInfo zrangeByScore(@RequestParam(value="key") String var1, @RequestParam(value="min") String var2, @RequestParam(value="max") String var3);

    @GetMapping(value={"/api/v1/redis/zset/zcard"})
    public ResultInfo zcard(@RequestParam(value="key") String var1);

    @GetMapping(value={"/api/v1/redis/zset/zscore"})
    public ResultInfo zscore(@RequestParam(value="key") String var1, @RequestParam(value="element") String var2);

    @GetMapping(value={"/api/v1/redis/zset/zremrangebyrank"})
    public ResultInfo zremrangeByRank(@RequestParam(value="key") String var1, @RequestParam(value="min") long var2, @RequestParam(value="max") long var4);

    @GetMapping(value={"/api/v1/redis/zset/zrevrangebyscore"})
    public ResultInfo zrevrangeByScore(@RequestParam(value="key") String var1, @RequestParam(value="min") long var2, @RequestParam(value="max") long var4);

    @GetMapping(value={"/api/v1/redis/zset/zremrangebyscore"})
    public ResultInfo zremrangeByScore(@RequestParam(value="key") String var1, @RequestParam(value="min") String var2, @RequestParam(value="max") String var3);
}

