/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.healthalliance.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.healthalliance.common.model.dto.HospitalHealthAllianceDto;
import com.ebaiyihui.healthalliance.common.model.dto.SuperHospitalHealthAllianceDto;
import com.ebaiyihui.healthalliance.common.model.dto.SuperHospitalHealthAllianceUpdateDto;
import com.ebaiyihui.healthalliance.common.model.entity.HospitalHealthAllianceMemberEntity;
import com.ebaiyihui.healthalliance.common.model.vo.HospitalHealthAllianceVo;
import com.ebaiyihui.healthalliance.common.model.vo.SuperHospitalHealthAllianceVo;
import com.ebaiyihui.healthalliance.server.manager.HealthAllianceManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u533b\u8054\u4f53\u670d\u52a1")
@RestController
@RequestMapping(value={"/api/v1/healthAlliance"})
public class HealthAllianceController
extends BaseController {
    @Autowired
    private HealthAllianceManager healthAllianceManager;

    @ApiOperation(value="\u7533\u8bf7\u533b\u8054\u4f53", notes="\u7533\u8bf7")
    @PostMapping(value={"insert_hospital_health_alliance"})
    public ResultInfo insertHospitalHealthAlliance(@RequestBody HospitalHealthAllianceDto hospitalHealthAllianceDto) {
        try {
            return this.healthAllianceManager.insertHospitalHealthAlliance(hospitalHealthAllianceDto);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u6240\u5728\u533b\u8054\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="20", dataType="int", paramType="query"), @ApiImplicitParam(name="searchParam", value="\u641c\u7d22", dataType="String", paramType="query")})
    @PostMapping(value={"/get_list_health_alliance_by_hospital_id"})
    public ResultInfo<List<HospitalHealthAllianceVo>> getListHealthAllianceByHospitalId(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="searchParam", required=false, defaultValue="") String searchParam) {
        try {
            return this.healthAllianceManager.getListHealthAllianceByHospitalId(hospitalId, pageIndex, pageSize, searchParam);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u533b\u8054\u4f53\u4e0b\u5355,\u5217\u8868\u5c55\u793a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="20", dataType="int", paramType="query"), @ApiImplicitParam(name="searchParam", value="\u641c\u7d22", dataType="String", paramType="query")})
    @PostMapping(value={"/get_list_hospital_health_alliance"})
    public ResultInfo<List<HospitalHealthAllianceVo>> getListHospitalHealthAlliance(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="searchParam", required=false, defaultValue="") String searchParam) {
        try {
            return this.healthAllianceManager.getListHospitalHealthAlliance(pageIndex, pageSize, searchParam);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u521b\u5efa")
    @PostMapping(value={"insert_super_hospital_healthAlliance"})
    public ResultInfo insertSuperHospitalHealthAlliance(@RequestBody SuperHospitalHealthAllianceDto superHospitalHealthAllianceDto) {
        try {
            return this.healthAllianceManager.insertSuperHospitalHealthAlliance(superHospitalHealthAllianceDto);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u6210\u5458\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="allianceUuid", value="\u533b\u8054\u4f53uuid", required=true, defaultValue="", paramType="query", dataType="String"), @ApiImplicitParam(name="hospitalId", value="\u6210\u5458\u533b\u9662id", required=true, defaultValue="0", dataType="Long", paramType="query"), @ApiImplicitParam(name="isLast", value="\u662f\u5426\u662f\u6700\u540e\u4e00\u4e2a\u6210\u5458\u533b\u9662 0:\u4e0d\u662f 1:\u662f", required=true, defaultValue="0", dataType="int", paramType="query")})
    @GetMapping(value={"delete_super_hospital_healthAlliance_menber"})
    public ResultInfo deleteSuperHospitalHealthAllianceMember(@RequestParam(value="allianceUuid", defaultValue="") String allianceUuid, @RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="isLast", defaultValue="0") Integer isLast) {
        if (allianceUuid == null || allianceUuid.equals("")) {
            return this.returnFailure("allianceUuid\u9519\u8bef");
        }
        if (hospitalId == null || hospitalId.intValue() == 0) {
            return this.returnFailure("hospitalId\u9519\u8bef");
        }
        try {
            return this.healthAllianceManager.deleteSuperHospitalHealthAllianceMember(allianceUuid, hospitalId, isLast);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="search", value="\u6a21\u7cca\u5b57\u6bb5", defaultValue="", paramType="query", dataType="String"), @ApiImplicitParam(name="type", value="\u533b\u8054\u4f53\u7c7b\u578b", defaultValue="0", dataType="int", paramType="query"), @ApiImplicitParam(name="status", value="\u533b\u8054\u4f53\u72b6\u6001", defaultValue="0", dataType="int", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="20", dataType="int", paramType="query"), @ApiImplicitParam(name="userViewId", value="\u5c0f\u8d85\u7ba1", paramType="query")})
    @GetMapping(value={"query_super_hospital_healthAlliance"})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> querySuperHospitalHealthAlliance(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="userViewId", required=false, defaultValue="") String userViewId) {
        try {
            return this.healthAllianceManager.querySuperHospitalHealthAlliance(search, type, status, pageIndex, pageSize, userViewId);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u6210\u5458\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="allianceUuid", value="\u533b\u8054\u4f53uuid", required=true, defaultValue="", paramType="query", dataType="Sting"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="20", dataType="int", paramType="query")})
    @GetMapping(value={"query_super_hospital_healthAlliance_detail"})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> querySuperHospitalHealthAllianceDetail(@RequestParam(value="allianceUuid", defaultValue="") String allianceUuid, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        try {
            return this.healthAllianceManager.querySuperHospitalHealthAllianceDetail(allianceUuid, pageIndex, pageSize);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u4e2d\u5fc3\u533b\u9662\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, defaultValue="0", paramType="query", dataType="Long"), @ApiImplicitParam(name="allianceUuid", value="\u533b\u8054\u4f53uuid", required=true, defaultValue="0", paramType="query", dataType="String")})
    @GetMapping(value={"query_super_hospital_detail"})
    public ResultInfo<SuperHospitalHealthAllianceVo> querySuperHospitalDetail(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="allianceUuid", defaultValue="") String allianceUuid) {
        if (hospitalId.intValue() == 0) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:hospitalId");
        }
        if (allianceUuid.equals("")) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:allianceUuid");
        }
        try {
            return this.healthAllianceManager.querySuperHospitalDetail(hospitalId, allianceUuid);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u7c7b\u578b\u5217\u8868")
    @GetMapping(value={"/get_healthAlliance_type"})
    public ResultInfo getHealthAllianceType() {
        try {
            return this.healthAllianceManager.getHealthAllianceType();
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u5224\u65ad\u533b\u9662\u662f\u5426\u5728\u533b\u8054\u4f53\u5185")
    @GetMapping(value={"/get_isHealthalliance"})
    public ResultInfo<List<HospitalHealthAllianceMemberEntity>> getIsHealthalliance(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId) {
        if (hospitalId.intValue() == 0) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:hospitalId\u9519\u8bef");
        }
        try {
            return this.healthAllianceManager.getIsHealthalliance(hospitalId);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u533b\u8054\u4f53\u5217\u8868_\u533b\u9662\u7aef")
    @ApiImplicitParams(value={@ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, defaultValue="0", paramType="query", dataType="Long"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="20", dataType="int", paramType="query"), @ApiImplicitParam(name="search", value="\u6a21\u7cca\u5b57\u6bb5", defaultValue="", paramType="query", dataType="String"), @ApiImplicitParam(name="type", value="\u533b\u8054\u4f53\u7c7b\u578b", defaultValue="0", dataType="int", paramType="query"), @ApiImplicitParam(name="status", value="\u533b\u8054\u4f53\u72b6\u6001", defaultValue="0", dataType="int", paramType="query")})
    @GetMapping(value={"/get_healthAllianceByHosId"})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> getHealthAllianceByHosId(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status) {
        if (hospitalId.intValue() == 0) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:hospitalId\u9519\u8bef");
        }
        try {
            return this.healthAllianceManager.getHealthAllianceByHosId(hospitalId, pageIndex, pageSize, search, type, status);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u533b\u8054\u4f53\u6210\u5458\u6dfb\u52a0")
    @PostMapping(value={"insert_super_hospital_healthAlliance_member"})
    public ResultInfo insertSuperHospitalHealthAllianceMember(@RequestBody SuperHospitalHealthAllianceUpdateDto superHospitalHealthAllianceUpdateDto) {
        try {
            return this.healthAllianceManager.insertSuperHospitalHealthAllianceMember(superHospitalHealthAllianceUpdateDto);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u4e0a\u4e0b\u7ebf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="allianceUuid", value="\u533b\u8054\u4f53uuid", required=true, defaultValue="", paramType="query", dataType="String"), @ApiImplicitParam(name="status", value="\u4e0a\u4e0b\u7ebf -2:\u4e0b\u7ebf 1:\u4e0a\u7ebf", required=true, defaultValue="0", paramType="query", dataType="int")})
    @PostMapping(value={"/isOnline_healthAlliance"})
    public ResultInfo isOnlineHealthAlliance(@RequestParam(value="allianceUuid", defaultValue="") String allianceUuid, @RequestParam(value="status", defaultValue="0") Integer status) {
        if (allianceUuid.equals("")) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:allianceUuid");
        }
        if (status == 0) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:status");
        }
        try {
            return this.healthAllianceManager.isOnlineHealthAlliance(allianceUuid, status);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u8054\u4f53\u6570\u91cf")
    @GetMapping(value={"/query_healthAlliance_count"})
    public ResultInfo<Integer> queryHealthAllianceCount(@RequestParam(value="userViewId", defaultValue="") String userViewId) {
        try {
            return this.healthAllianceManager.queryHealthAllianceCount(userViewId);
        }
        catch (Exception e) {
            return this.returnException(e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5")
    @GetMapping(value={"/test"})
    public ResultInfo isCoexistenceHealthAlliance() {
        System.out.println("test\u63a5\u53e3\u6267\u884c=======");
        return this.returnSucceed("test\u63a5\u53e3\u6267\u884c");
    }

    @ApiOperation(value="\u5224\u65ad\u8be5\u533b\u9662\u662f\u5426\u5728\u5b9c\u6625\u7684\u533b\u8054\u4f53\u5185")
    @GetMapping(value={"/isExistYiChun"})
    public ResultInfo<Boolean> isExistYiChun(@RequestParam(value="hosId", defaultValue="0") Long hosId) {
        if (hosId == 0L) {
            return this.returnFailure("\u53c2\u6570\u9519\u8befhosId:" + hosId);
        }
        Boolean flag = this.healthAllianceManager.isExistYiChun(hosId);
        return this.returnSucceed((Object)flag, "\u6210\u529f");
    }
}

