/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.healthalliance.server.exception;

import com.ebaiyihui.healthalliance.server.exception.ExceptionResponse;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@RestController
public class ByhResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    Logger logger = LoggerFactory.getLogger(ByhResponseEntityExceptionHandler.class);

    @ExceptionHandler(value={SQLException.class})
    public final ResponseEntity<ExceptionResponse> handleMybatisSqlException(SQLException ex, WebRequest request) {
        this.logger.error(ex.getMessage(), (Throwable)ex);
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), ex.getCause().toString(), request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.REQUEST_TIMEOUT);
    }
}

