/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.healthalliance.server.manager;

import com.ebaiyihui.cache.client.RedisClient;
import com.ebaiyihui.doctor.client.DoctorDetailInfoClient;
import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.utils.StringUtil;
import com.ebaiyihui.framework.utils.UuidUtils;
import com.ebaiyihui.healthalliance.common.model.dto.HospitalHealthAllianceDto;
import com.ebaiyihui.healthalliance.common.model.dto.SuperHospitaMemberlDto;
import com.ebaiyihui.healthalliance.common.model.dto.SuperHospitalHealthAllianceDto;
import com.ebaiyihui.healthalliance.common.model.dto.SuperHospitalHealthAllianceUpdateDto;
import com.ebaiyihui.healthalliance.common.model.entity.HospitalHealthAllianceEntity;
import com.ebaiyihui.healthalliance.common.model.entity.HospitalHealthAllianceMemberEntity;
import com.ebaiyihui.healthalliance.common.model.vo.HospitalHealthAllianceVo;
import com.ebaiyihui.healthalliance.common.model.vo.SuperHospitalHealthAllianceVo;
import com.ebaiyihui.healthalliance.server.enums.HealthAllianceEnum;
import com.ebaiyihui.healthalliance.server.enums.HealthAllianceTypeEnum;
import com.ebaiyihui.healthalliance.server.service.HealthAllianceMemberService;
import com.ebaiyihui.healthalliance.server.service.HealthAllianceService;
import com.ebaiyihui.hospital.client.HospitalDepartmentClient;
import com.ebaiyihui.hospital.client.HospitalInfoClient;
import com.ebaiyihui.hospital.common.model.HospitalInfoEntity;
import com.ebaiyihui.hospital.common.vo.HospitalDepartmentVo;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HealthAllianceManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(HealthAllianceManager.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HealthAllianceService healthAllianceService;
    @Autowired
    private HealthAllianceMemberService healthAllianceMemberService;
    @Autowired
    private HospitalInfoClient hospitalInfoClient;
    @Autowired
    private HospitalDepartmentClient hospitalDepartmentClient;
    @Autowired
    private DoctorDetailInfoClient doctorDetailInfoClient;
    @Autowired
    private RedisClient redisClient;

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo insertHospitalHealthAlliance(HospitalHealthAllianceDto hospitalHealthAllianceDto) {
        if (hospitalHealthAllianceDto.getApplicantId() == null || hospitalHealthAllianceDto.getApplicantId().intValue() == 0) {
            this.logger.info("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005id=========");
            return this.returnFailure("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005id");
        }
        if (hospitalHealthAllianceDto.getApplicantType() == null || hospitalHealthAllianceDto.getApplicantType() == 0) {
            this.logger.info("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005type=========");
            return this.returnFailure("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005type");
        }
        if (hospitalHealthAllianceDto.getHospitalId() == null || hospitalHealthAllianceDto.getHospitalId().intValue() == 0) {
            this.logger.info("\u8bf7\u8f93\u533b\u9662id=========");
            return this.returnFailure("\u8bf7\u8f93\u5165\u533b\u9662id");
        }
        if (hospitalHealthAllianceDto.getHospitalLevel() == null || hospitalHealthAllianceDto.getHospitalLevel() == 0) {
            this.logger.info("\u8bf7\u8f93\u5165\u533b\u9662\u7b49\u7ea7=========");
            return this.returnFailure("\u8bf7\u8f93\u5165\u533b\u9662\u7b49\u7ea7");
        }
        if (hospitalHealthAllianceDto.getYltName() == null || hospitalHealthAllianceDto.getYltName().equals("")) {
            this.logger.info("\u8bf7\u8f93\u5165\u533b\u8054\u4f53\u540d\u79f0=========");
            return this.returnFailure("\u8bf7\u8f93\u5165\u533b\u8054\u4f53\u540d\u79f0");
        }
        int i = this.healthAllianceService.insertHospitalHealthAlliance(hospitalHealthAllianceDto);
        if (i < 0) {
            this.logger.info("\u7533\u8bf7\u533b\u8054\u4f53\u5931\u8d25=========");
            return this.returnFailure("\u7533\u8bf7\u533b\u8054\u4f53\u5931\u8d25");
        }
        return this.returnSucceed("\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo updateHospitalHealthAlliance(Long auditorId, Integer auditorType, Integer status, Long hospitalId) {
        if (auditorId == null || auditorId.intValue() == 0) {
            this.logger.info("\u5ba1\u6838\u4ebaid\u4e3a\u7a7a=======");
            return this.returnFailure("\u5ba1\u6838\u4ebaid\u4e3a\u7a7a=======");
        }
        if (auditorType == null || auditorType == 0) {
            this.logger.info("\u5ba1\u6838\u4eba\u7c7b\u578b\u4e3a\u7a7a=======");
            return this.returnFailure("\u5ba1\u6838\u4eba\u7c7b\u578b\u4e3a\u7a7a=======");
        }
        if (status == null || status == 0) {
            this.logger.info("\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a=======");
            return this.returnFailure("\u5ba1\u6838\u4eba\u72b6\u6001\u4e3a\u7a7a=======");
        }
        if (hospitalId == null && hospitalId.intValue() == 0) {
            this.logger.info("\u533b\u9662id\u4e3a\u7a7a=======");
            return this.returnFailure("\u533b\u9662id\u4e3a\u7a7a=======");
        }
        int flag = this.healthAllianceService.updateHospitalHealthAlliance(auditorId, auditorType, status, hospitalId);
        if (flag == 0) {
            this.logger.info("\u72b6\u6001\u4fee\u6539\u8be5\u5931\u8d25======" + flag);
            return this.returnFailure("\u72b6\u6001\u4fee\u6539\u8be5\u5931\u8d25");
        }
        return this.returnSucceed("\u72b6\u6001\u4fee\u6539\u8be5\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<HospitalHealthAllianceVo>> getListHealthAllianceByHospitalId(Long hospitalId, Integer pageIndex, Integer pageSize, String searchParam) {
        if (hospitalId == null || hospitalId.intValue() == 0) {
            this.logger.info("\u8bf7\u4f20\u5165\u533b\u9662id========");
            return this.returnFailure("\u8bf7\u4f20\u5165\u533b\u9662id");
        }
        String flag = this.healthAllianceMemberService.getHealthAllianceByHospitalId(hospitalId, pageIndex, pageSize);
        if (flag == null) {
            return this.returnSucceed("\u6700\u540e\u4e00\u9875");
        }
        if (flag.equals("0")) {
            return this.returnFailure("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u5185");
        }
        String ids = flag;
        ResultInfo resultInfoReturn = this.hospitalInfoClient.getSelectedHospitalInfo(ids, searchParam);
        if (resultInfoReturn.getCode() == 200) {
            ArrayList<HospitalHealthAllianceVo> healthAllianceList = new ArrayList<HospitalHealthAllianceVo>();
            List hospitalInfoEntityList = (List)resultInfoReturn.getResult();
            if (hospitalInfoEntityList != null && hospitalInfoEntityList.size() > 0) {
                for (HospitalInfoEntity hospitalInfo : hospitalInfoEntityList) {
                    ResultInfo doctorDetailInfoReturn;
                    HospitalHealthAllianceVo hospitalHealthAllianceVo = new HospitalHealthAllianceVo();
                    hospitalHealthAllianceVo.setHospitalId(hospitalInfo.getId());
                    hospitalHealthAllianceVo.setHospitalName(hospitalInfo.getName());
                    hospitalHealthAllianceVo.setHospitalLogo(hospitalInfo.getHospitalLogo());
                    hospitalHealthAllianceVo.setHosType(hospitalInfo.getHosType());
                    ResultInfo hospitalDepartmentMapResult = this.hospitalDepartmentClient.getHospitalDepartmentMap(hospitalInfo.getId());
                    if (hospitalDepartmentMapResult.getCode() == 200) {
                        Map hospitalDepartmentMap = (Map)hospitalDepartmentMapResult.getResult();
                        int departmentNum = hospitalDepartmentMap.size();
                        hospitalHealthAllianceVo.setDepartmentNum(Integer.valueOf(departmentNum));
                    }
                    if ((doctorDetailInfoReturn = this.doctorDetailInfoClient.selectByProfession(hospitalInfo.getId())) == null || doctorDetailInfoReturn.getCode() != 200) {
                        log.info("\u533b\u751f\u670d\u52a1\u9519\u8bef:\u4e13\u5bb6\u6570\u91cf\u9519\u8bef");
                        return this.returnFailure("\u533b\u751f\u670d\u52a1\u9519\u8bef:\u4e13\u5bb6\u6570\u91cf\u9519\u8bef");
                    }
                    hospitalHealthAllianceVo.setDoctorNum(Integer.valueOf(((List)doctorDetailInfoReturn.getResult()).size()));
                    hospitalHealthAllianceVo.setHotDepartmentName(hospitalInfo.getHotDepartment());
                    healthAllianceList.add(hospitalHealthAllianceVo);
                }
                return this.returnSucceed(healthAllianceList, "\u6210\u529f");
            }
            this.logger.info("\u83b7\u53d6\u533b\u8054\u4f53\u5931\u8d25=========");
            return this.returnSucceed(healthAllianceList, "\u7a7a");
        }
        return this.returnFailure("\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<HospitalHealthAllianceVo>> getListHospitalHealthAlliance(Integer pageIndex, Integer pageSize, String searchParam) {
        ResultInfo resultInfoReturn;
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List list = this.healthAllianceService.getListHospitalHealthAlliance();
        if (list == null || list.size() < 1) {
            return this.returnSucceed("\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u9875\u4e86....");
        }
        String ids = "";
        for (HospitalHealthAllianceEntity hospitalHealthAllianceEntity : list) {
            ids = ids + hospitalHealthAllianceEntity.getHospitalId() + ",";
        }
        if (!ids.equals("")) {
            ids = ids.substring(0, ids.length() - 1);
        }
        if ((resultInfoReturn = this.hospitalInfoClient.getSelectedHospitalInfo(ids, searchParam)).getCode() == 200) {
            ArrayList<HospitalHealthAllianceVo> healthAllianceList = new ArrayList<HospitalHealthAllianceVo>();
            List hospitalInfoEntityList = (List)resultInfoReturn.getResult();
            if (hospitalInfoEntityList != null && hospitalInfoEntityList.size() > 0) {
                for (HospitalInfoEntity hospitalInfo : hospitalInfoEntityList) {
                    HospitalHealthAllianceVo hospitalHealthAllianceVo = new HospitalHealthAllianceVo();
                    hospitalHealthAllianceVo.setHospitalId(hospitalInfo.getId());
                    hospitalHealthAllianceVo.setHospitalName(hospitalInfo.getName());
                    hospitalHealthAllianceVo.setHospitalLogo(hospitalInfo.getHospitalLogo());
                    hospitalHealthAllianceVo.setHosType(hospitalInfo.getHosType());
                    Integer hosType = hospitalInfo.getHosType();
                    ResultInfo hospitalDepartmentMapResult = this.hospitalDepartmentClient.getHospitalDepartmentMap(hospitalInfo.getId());
                    if (hospitalDepartmentMapResult.getCode() == 200) {
                        Map hospitalDepartmentMap = (Map)hospitalDepartmentMapResult.getResult();
                        int departmentNum = hospitalDepartmentMap.size();
                        hospitalHealthAllianceVo.setDepartmentNum(Integer.valueOf(departmentNum));
                        int doctorNum = 0;
                        for (HospitalDepartmentVo hospitalDepartmentVo : hospitalDepartmentMap.values()) {
                            if (hospitalDepartmentVo.getDoctorNum() == null) {
                                doctorNum = 0;
                                continue;
                            }
                            doctorNum += hospitalDepartmentVo.getDoctorNum().intValue();
                        }
                        hospitalHealthAllianceVo.setDoctorNum(Integer.valueOf(doctorNum));
                    }
                    hospitalHealthAllianceVo.setHotDepartmentName(hospitalInfo.getHotDepartment());
                    healthAllianceList.add(hospitalHealthAllianceVo);
                }
                return this.returnSucceed(healthAllianceList, "\u6210\u529f");
            }
            this.logger.info("\u83b7\u53d6\u533b\u8054\u4f53\u5931\u8d25=========");
            return this.returnSucceed("\u7a7a");
        }
        return this.returnFailure("\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo insertSuperHospitalHealthAlliance(SuperHospitalHealthAllianceDto superHospitalHealthAllianceDto) {
        Long hospitalId = superHospitalHealthAllianceDto.getHospitalId();
        HospitalHealthAllianceEntity hospitalHealthAlliance = new HospitalHealthAllianceEntity();
        hospitalHealthAlliance.setViewId(UuidUtils.generateUUID());
        hospitalHealthAlliance.setType(superHospitalHealthAllianceDto.getType());
        hospitalHealthAlliance.setAllianceType(superHospitalHealthAllianceDto.getAllianceType());
        hospitalHealthAlliance.setHospitalId(superHospitalHealthAllianceDto.getHospitalId());
        hospitalHealthAlliance.setHospitalLevel(superHospitalHealthAllianceDto.getHospitalLevel());
        hospitalHealthAlliance.setYltName(superHospitalHealthAllianceDto.getHospitalName());
        hospitalHealthAlliance.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
        int i = this.healthAllianceService.insertHospitalHealthAllianceEntity(hospitalHealthAlliance);
        if (i > 0) {
            log.info("\u65b0\u5efa\u6210\u529f======");
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = new HospitalHealthAllianceMemberEntity();
            hospitalHealthAllianceMemberEntity.setViewId(hospitalHealthAlliance.getViewId());
            hospitalHealthAllianceMemberEntity.setAllianceUuid(hospitalHealthAlliance.getViewId());
            hospitalHealthAllianceMemberEntity.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            hospitalHealthAllianceMemberEntity.setHospitalId(superHospitalHealthAllianceDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setHospitalLevel(superHospitalHealthAllianceDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setRole(Integer.valueOf(1));
            int j = this.healthAllianceMemberService.insertHealthAllianceMember(hospitalHealthAllianceMemberEntity);
            if (j <= 0) {
                return this.returnFailure("\u6210\u5458\u8868\u6dfb\u52a0\u5931\u8d25");
            }
        } else {
            return this.returnFailure("\u65b0\u5efa\u5931\u8d25");
        }
        log.info("\u6210\u5458\u8868\u6dfb\u52a0\u6210\u529f======");
        List memberList = superHospitalHealthAllianceDto.getMemberList();
        for (SuperHospitaMemberlDto superHospitaMemberlDto : memberList) {
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = this.healthAllianceMemberService.queryHospitalHealthAllianceMember(hospitalHealthAlliance.getViewId(), superHospitaMemberlDto.getHospitalId(), HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            if (hospitalHealthAllianceMember != null) continue;
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = new HospitalHealthAllianceMemberEntity();
            hospitalHealthAllianceMemberEntity.setViewId(UuidUtils.generateUUID());
            hospitalHealthAllianceMemberEntity.setAllianceUuid(hospitalHealthAlliance.getViewId());
            hospitalHealthAllianceMemberEntity.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            hospitalHealthAllianceMemberEntity.setHospitalId(superHospitaMemberlDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setHospitalLevel(superHospitaMemberlDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setParentHosId(superHospitalHealthAllianceDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setParentHosLevel(superHospitalHealthAllianceDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setRole(Integer.valueOf(2));
            int j = this.healthAllianceMemberService.insertHealthAllianceMember(hospitalHealthAllianceMemberEntity);
            if (j > 0) {
                log.info("\u6210\u5458\u8868\u6dfb\u52a0\u6210\u529f======");
                continue;
            }
            return this.returnFailure("\u6210\u5458\u8868\u6dfb\u52a0\u5931\u8d25");
        }
        return this.returnSucceed((Object)hospitalHealthAlliance.getViewId(), "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo deleteSuperHospitalHealthAllianceMember(String allianceUuid, Long hospitalId, Integer isLast) {
        int i;
        if (isLast == 1) {
            i = this.healthAllianceService.deleteHealthAlliance(allianceUuid, HealthAllianceEnum.DETELE.getValue());
            if (i > 0) {
                log.info("\u4e2d\u5fc3\u533b\u9662\u5220\u9664\u6210\u529f=============");
            } else {
                log.info("\u4e2d\u5fc3\u533b\u9662\u5220\u9664\u5931\u8d25=============");
            }
        }
        if ((i = this.healthAllianceMemberService.updateHospitalHealthAllianceMemberByAllianceUuidAndHosId(allianceUuid, hospitalId, HealthAllianceEnum.DETELE.getValue())) <= 0) {
            return this.returnFailure("\u6210\u5458\u5220\u9664\u5931\u8d25");
        }
        log.info("\u6210\u5458\u5220\u9664\u6210\u529f======");
        return this.returnSucceed("\u6210\u5458\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> querySuperHospitalHealthAlliance(String search, Integer type, Integer status, Integer pageIndex, Integer pageSize, String userViewId) {
        List hospitalHealthAllianceEntityList;
        int total = 0;
        String key = "";
        List<Object> hosList = new ArrayList();
        if (StringUtil.isNotEmpty((String)userViewId)) {
            ResultInfo resultInfo = this.redisClient.get("auth_web_super_user_hospital_permission_" + userViewId);
            if (resultInfo.getCode() != 200) {
                return this.returnFailure("\u83b7\u53d6\u6743\u9650\u5931\u8d25!");
            }
            key = resultInfo.getResult().toString();
            log.info("\u6743\u9650\u7684\u8fd4\u56de\u503c:" + key);
            if (StringUtil.isNotEmpty((String)key) && !key.equals("-1")) {
                String[] keys = key.split(",");
                hosList = Arrays.asList(keys);
            }
        }
        if (hosList != null && hosList.size() > 0) {
            PageHelper.startPage((int)pageIndex, (int)pageSize);
            hospitalHealthAllianceEntityList = this.healthAllianceService.queryHosHealthallianceJurisdiction(search, type, status, hosList);
            if (hospitalHealthAllianceEntityList == null) {
                return this.returnFailure("\u7a7a\u7a7a\u5982\u4e5f");
            }
            total = this.healthAllianceService.queryHosHealthallianceJurisdiction(search, type, status, hosList).size();
        } else {
            PageHelper.startPage((int)pageIndex, (int)pageSize);
            hospitalHealthAllianceEntityList = this.healthAllianceService.queryHospitalHealthAlliance(search, type, status);
            if (hospitalHealthAllianceEntityList == null) {
                return this.returnFailure("\u7a7a\u7a7a\u5982\u4e5f");
            }
            total = this.healthAllianceService.queryHospitalHealthAlliance(search, type, status).size();
        }
        ArrayList<SuperHospitalHealthAllianceVo> list = new ArrayList<SuperHospitalHealthAllianceVo>();
        for (HospitalHealthAllianceEntity hospitalHealthAllianceEntity : hospitalHealthAllianceEntityList) {
            List hospitalHealthAllianceMemberEntityList;
            ResultInfo DoctorDetailInfoEntityListReturn;
            SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
            superHospitalHealthAllianceVo.setId(hospitalHealthAllianceEntity.getId());
            superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceEntity.getHospitalId());
            superHospitalHealthAllianceVo.setYltName(hospitalHealthAllianceEntity.getYltName());
            superHospitalHealthAllianceVo.setAllianceType(hospitalHealthAllianceEntity.getAllianceType());
            superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceEntity.getStatus());
            superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceEntity.getViewId());
            superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceEntity.getHospitalLevel());
            ResultInfo hospitalInfoReturn = this.hospitalInfoClient.getHospitalInfo(hospitalHealthAllianceEntity.getHospitalId());
            if (hospitalInfoReturn.getCode() != 200) {
                return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef:" + hospitalInfoReturn.getMsg());
            }
            HospitalInfoEntity hospitalInfoEntity = (HospitalInfoEntity)hospitalInfoReturn.getResult();
            if (hospitalInfoEntity != null) {
                superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getName());
                superHospitalHealthAllianceVo.setHosType(hospitalInfoEntity.getHosType());
            }
            if ((DoctorDetailInfoEntityListReturn = this.doctorDetailInfoClient.selectByHospitalId(hospitalHealthAllianceEntity.getHospitalId().toString())).getCode() != 200) {
                return this.returnFailure("\u533b\u751f\u670d\u52a1\u51fa\u9519:" + DoctorDetailInfoEntityListReturn.getMsg());
            }
            List DoctorDetailInfoEntityList = (List)DoctorDetailInfoEntityListReturn.getResult();
            if (DoctorDetailInfoEntityList != null) {
                superHospitalHealthAllianceVo.setDoctorNum(Integer.valueOf(DoctorDetailInfoEntityList.size()));
            }
            if ((hospitalHealthAllianceMemberEntityList = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(hospitalHealthAllianceEntity.getViewId(), hospitalHealthAllianceEntity.getHospitalId())) == null) {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(0));
            } else {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(hospitalHealthAllianceMemberEntityList.size()));
            }
            superHospitalHealthAllianceVo.setTotal(Integer.valueOf(total));
            list.add(superHospitalHealthAllianceVo);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> querySuperHospitalHealthAllianceDetail(String allianceUuid, Integer pageIndex, Integer pageSize) {
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.getHospitalHealthAllianceByViewId1(allianceUuid);
        if (hospitalHealthAllianceEntity == null) {
            return this.returnFailure("\u8be5\u533b\u8054\u4f53\u672a\u7533\u8bf7\u533b\u8054\u4f53");
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List hospitalHealthAllianceMemberEntityList = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(allianceUuid, hospitalHealthAllianceEntity.getHospitalId());
        ArrayList<SuperHospitalHealthAllianceVo> list = new ArrayList<SuperHospitalHealthAllianceVo>();
        for (HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity : hospitalHealthAllianceMemberEntityList) {
            ResultInfo DoctorDetailInfoEntityListReturn;
            if (hospitalHealthAllianceEntity.getHospitalId().intValue() == hospitalHealthAllianceMemberEntity.getHospitalId().intValue()) {
                log.info("\u4e2d\u5fc3\u533b\u9662");
                continue;
            }
            SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
            superHospitalHealthAllianceVo.setId(hospitalHealthAllianceMemberEntity.getId());
            superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceMemberEntity.getHospitalId());
            superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceMemberEntity.getStatus());
            superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceMemberEntity.getHospitalLevel());
            superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceMemberEntity.getViewId());
            if (hospitalHealthAllianceEntity.getStatus() == 1) {
                superHospitalHealthAllianceVo.setTotal(Integer.valueOf(this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(allianceUuid, hospitalHealthAllianceEntity.getHospitalId()).size()));
            } else {
                superHospitalHealthAllianceVo.setTotal(Integer.valueOf(this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid1(allianceUuid, hospitalHealthAllianceEntity.getHospitalId()).size()));
            }
            ResultInfo hospitalInfoReturn = this.hospitalInfoClient.getHospitalInfo(hospitalHealthAllianceMemberEntity.getHospitalId());
            if (hospitalInfoReturn.getCode() != 200) {
                return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef" + hospitalInfoReturn.getMsg());
            }
            HospitalInfoEntity hospitalInfoEntity = (HospitalInfoEntity)hospitalInfoReturn.getResult();
            if (hospitalInfoEntity != null) {
                superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getName());
                superHospitalHealthAllianceVo.setHosType(hospitalInfoEntity.getHosType());
            }
            if ((DoctorDetailInfoEntityListReturn = this.doctorDetailInfoClient.selectByHospitalId(hospitalHealthAllianceMemberEntity.getHospitalId().toString())).getCode() != 200) {
                return this.returnFailure("\u533b\u751f\u670d\u52a1\u9519\u8bef" + DoctorDetailInfoEntityListReturn.getMsg());
            }
            List DoctorDetailInfoEntityList = (List)DoctorDetailInfoEntityListReturn.getResult();
            if (DoctorDetailInfoEntityList != null) {
                superHospitalHealthAllianceVo.setDoctorNum(Integer.valueOf(DoctorDetailInfoEntityList.size()));
            }
            list.add(superHospitalHealthAllianceVo);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<SuperHospitalHealthAllianceVo> querySuperHospitalDetail(Long hospitalId, String allianceUuid) {
        ResultInfo DoctorDetailInfoEntityListReturn;
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.queryHospitalHealthAllianceByHosIdAndAllianceUuid(hospitalId, allianceUuid);
        if (hospitalHealthAllianceEntity == null) {
            log.info("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u5185===========" + hospitalId);
            return this.returnFailure("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u5185" + hospitalId);
        }
        SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
        superHospitalHealthAllianceVo.setId(hospitalHealthAllianceEntity.getId());
        superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceEntity.getHospitalId());
        superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceEntity.getStatus());
        superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceEntity.getHospitalLevel());
        superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceEntity.getViewId());
        superHospitalHealthAllianceVo.setAllianceType(hospitalHealthAllianceEntity.getAllianceType());
        int size = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(hospitalHealthAllianceEntity.getViewId(), hospitalId).size();
        superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(size));
        ResultInfo hospitalInfoReturn = this.hospitalInfoClient.getHospitalInfo(hospitalHealthAllianceEntity.getHospitalId());
        if (hospitalInfoReturn.getCode() != 200) {
            return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef" + hospitalInfoReturn.getMsg());
        }
        HospitalInfoEntity hospitalInfoEntity = (HospitalInfoEntity)hospitalInfoReturn.getResult();
        if (hospitalInfoEntity != null) {
            superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getName());
            superHospitalHealthAllianceVo.setHosType(hospitalInfoEntity.getHosType());
        }
        if ((DoctorDetailInfoEntityListReturn = this.doctorDetailInfoClient.selectByHospitalId(hospitalHealthAllianceEntity.getHospitalId().toString())).getCode() != 200) {
            return this.returnFailure("\u533b\u751f\u670d\u52a1\u9519\u8bef" + DoctorDetailInfoEntityListReturn.getMsg());
        }
        List DoctorDetailInfoEntityList = (List)DoctorDetailInfoEntityListReturn.getResult();
        if (DoctorDetailInfoEntityList != null) {
            superHospitalHealthAllianceVo.setDoctorNum(Integer.valueOf(DoctorDetailInfoEntityList.size()));
        }
        return this.returnSucceed((Object)superHospitalHealthAllianceVo, "\u6210\u529f");
    }

    public ResultInfo getHealthAllianceType() {
        ArrayList list = new ArrayList();
        for (HealthAllianceTypeEnum e : HealthAllianceTypeEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", e.getValue());
            map.put("typeName", e.getDisplay());
            if (e.getValue() == 0) continue;
            list.add(map);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<HospitalHealthAllianceMemberEntity>> getIsHealthalliance(Long hospitalId) {
        List healthAllianceMemberEntityList = this.healthAllianceMemberService.getListHealthAllianceMemberByHospitalId(hospitalId);
        if (healthAllianceMemberEntityList == null || healthAllianceMemberEntityList.size() < 1) {
            return this.returnSucceed((Object)healthAllianceMemberEntityList, "\u4e0d\u5728\u533b\u8054\u4f53\u5185");
        }
        return this.returnSucceed((Object)healthAllianceMemberEntityList, "\u5728\u533b\u8054\u4f53\u5185");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> getHealthAllianceByHosId(Long hospitalId, Integer pageIndex, Integer pageSize, String search, Integer type, Integer status) {
        List healthAllianceMemberEntityList = this.healthAllianceMemberService.getListHealthAllianceMemberByHospitalId(hospitalId);
        if (healthAllianceMemberEntityList == null || healthAllianceMemberEntityList.size() == 0) {
            return this.returnFailure("\u4e0d\u5728\u533b\u8054\u4f53\u5185");
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List hospitalHealthAllianceEntityList = this.healthAllianceService.queryHospitalHealthAllianceByAlliance(healthAllianceMemberEntityList, search, type, status);
        if (hospitalHealthAllianceEntityList == null || hospitalHealthAllianceEntityList.size() == 0) {
            return this.returnSucceed("\u7a7a\u7a7a\u5982\u4e5f");
        }
        int total = this.healthAllianceService.getCountHospitalHealthAlliance1(healthAllianceMemberEntityList, search, type, status);
        ArrayList<SuperHospitalHealthAllianceVo> list = new ArrayList<SuperHospitalHealthAllianceVo>();
        for (HospitalHealthAllianceEntity hospitalHealthAllianceEntity : hospitalHealthAllianceEntityList) {
            List hospitalHealthAllianceMemberEntityList;
            ResultInfo DoctorDetailInfoEntityListReturn;
            SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
            superHospitalHealthAllianceVo.setId(hospitalHealthAllianceEntity.getId());
            superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceEntity.getHospitalId());
            superHospitalHealthAllianceVo.setYltName(hospitalHealthAllianceEntity.getYltName());
            superHospitalHealthAllianceVo.setAllianceType(hospitalHealthAllianceEntity.getAllianceType());
            superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceEntity.getStatus());
            superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceEntity.getViewId());
            superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceEntity.getHospitalLevel());
            ResultInfo hospitalInfoReturn = this.hospitalInfoClient.getHospitalInfo(hospitalHealthAllianceEntity.getHospitalId());
            if (hospitalInfoReturn.getCode() != 200) {
                return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef:" + hospitalInfoReturn.getMsg());
            }
            HospitalInfoEntity hospitalInfoEntity = (HospitalInfoEntity)hospitalInfoReturn.getResult();
            if (hospitalInfoEntity != null) {
                superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getName());
                superHospitalHealthAllianceVo.setHosType(hospitalInfoEntity.getHosType());
            }
            if ((DoctorDetailInfoEntityListReturn = this.doctorDetailInfoClient.selectByHospitalId(hospitalHealthAllianceEntity.getHospitalId().toString())).getCode() != 200) {
                return this.returnFailure("\u533b\u751f\u670d\u52a1\u51fa\u9519:" + DoctorDetailInfoEntityListReturn.getMsg());
            }
            List DoctorDetailInfoEntityList = (List)DoctorDetailInfoEntityListReturn.getResult();
            if (DoctorDetailInfoEntityList != null) {
                superHospitalHealthAllianceVo.setDoctorNum(Integer.valueOf(DoctorDetailInfoEntityList.size()));
            }
            if ((hospitalHealthAllianceMemberEntityList = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(hospitalHealthAllianceEntity.getViewId(), hospitalHealthAllianceEntity.getHospitalId())) == null) {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(0));
            } else {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(hospitalHealthAllianceMemberEntityList.size()));
            }
            superHospitalHealthAllianceVo.setTotal(Integer.valueOf(total));
            list.add(superHospitalHealthAllianceVo);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo insertSuperHospitalHealthAllianceMember(SuperHospitalHealthAllianceUpdateDto superHospitalHealthAllianceUpdateDto) {
        String allianceUuid;
        Long hospitalId = superHospitalHealthAllianceUpdateDto.getHospitalId();
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.queryHospitalHealthAllianceByHosIdAndAllianceUuid(hospitalId, allianceUuid = superHospitalHealthAllianceUpdateDto.getAllianceUuid());
        if (hospitalHealthAllianceEntity == null) {
            log.info("\u8be5\u4e2d\u5fc3\u533b\u9662\u5df2\u7ecf\u4e0b\u7ebf\u6216\u8005\u88ab\u5220\u9664====================");
            return this.returnFailure("\u8be5\u4e2d\u5fc3\u533b\u9662\u5df2\u7ecf\u4e0b\u7ebf\u6216\u8005\u88ab\u5220\u9664");
        }
        List memberList = superHospitalHealthAllianceUpdateDto.getMemberList();
        for (SuperHospitaMemberlDto superHospitaMemberlDto : memberList) {
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = this.healthAllianceMemberService.queryHospitalHealthAllianceMember(allianceUuid, superHospitaMemberlDto.getHospitalId(), HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            if (hospitalHealthAllianceMember != null) continue;
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = new HospitalHealthAllianceMemberEntity();
            hospitalHealthAllianceMemberEntity.setViewId(UuidUtils.generateUUID());
            hospitalHealthAllianceMemberEntity.setAllianceUuid(allianceUuid);
            hospitalHealthAllianceMemberEntity.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            hospitalHealthAllianceMemberEntity.setHospitalId(superHospitaMemberlDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setHospitalLevel(superHospitaMemberlDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setParentHosId(superHospitalHealthAllianceUpdateDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setParentHosLevel(hospitalHealthAllianceEntity.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setRole(Integer.valueOf(2));
            int j = this.healthAllianceMemberService.insertHealthAllianceMember(hospitalHealthAllianceMemberEntity);
            if (j > 0) {
                log.info("\u6210\u5458\u8868\u6dfb\u52a0\u6210\u529f======");
                continue;
            }
            return this.returnFailure("\u6210\u5458\u8868\u6dfb\u52a0\u5931\u8d25");
        }
        return this.returnSucceed("\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo isOnlineHealthAlliance(String allianceUuid, Integer status) {
        int i = this.healthAllianceService.updateHospitalHealthAllianceIsOnline(allianceUuid, status);
        if (i > 0) {
            int j = this.healthAllianceMemberService.updateHospitalHealthAllianceMemberIsOnline(allianceUuid, status);
            if (j > 0) {
                return this.returnSucceed("\u6210\u529f");
            }
            return this.returnFailure("\u5931\u8d25");
        }
        log.info("\u5931\u8d25:\u4e2d\u5fc3\u533b\u9662========");
        return this.returnFailure("\u5931\u8d25:\u4e2d\u5fc3\u533b\u9662");
    }

    public ResultInfo<Integer> queryHealthAllianceCount(String userViewId) {
        String key = "";
        List<Object> hosList = new ArrayList();
        if (StringUtil.isNotEmpty((String)userViewId)) {
            ResultInfo resultInfo = this.redisClient.get("auth_web_super_user_hospital_permission_" + userViewId);
            if (resultInfo.getCode() != 200) {
                return this.returnFailure("\u83b7\u53d6\u6743\u9650\u5931\u8d25!");
            }
            key = resultInfo.getResult().toString();
            log.info("\u6743\u9650\u7684\u8fd4\u56de\u503c:" + key);
            if (StringUtil.isNotEmpty((String)key) && !key.equals("-1")) {
                String[] keys = key.split(",");
                hosList = Arrays.asList(keys);
            }
        }
        int count = this.healthAllianceService.queryHealthAllianceCount(hosList);
        return this.returnSucceed((Object)count, "\u83b7\u53d6\u533b\u8054\u4f53\u6570\u91cf\u6210\u529f");
    }

    public Boolean isExistYiChun(Long hosId) {
        String search = "\u5b9c\u6625\u5e02\u4eba\u6c11\u533b\u9662";
        String viewIdStr = this.healthAllianceService.getHosHealthAllianceByName(search);
        if (StringUtil.isEmpty((String)viewIdStr)) {
            return false;
        }
        String[] viewIdSplit = viewIdStr.split(",");
        List<String> viewIdList = Arrays.asList(viewIdSplit);
        List list = this.healthAllianceMemberService.isExistYiChun(hosId, viewIdList);
        if (list == null || list.size() == 0) {
            return false;
        }
        return true;
    }
}

