/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.healthalliance.server.service.impl;

import com.ebaiyihui.healthalliance.common.model.dto.HospitalHealthAllianceDto;
import com.ebaiyihui.healthalliance.common.model.entity.HospitalHealthAllianceEntity;
import com.ebaiyihui.healthalliance.common.model.entity.HospitalHealthAllianceMemberEntity;
import com.ebaiyihui.healthalliance.server.dao.HospitalHealthAllianceMapper;
import com.ebaiyihui.healthalliance.server.dao.HospitalHealthAllianceMemberMapper;
import com.ebaiyihui.healthalliance.server.enums.HealthAllianceEnum;
import com.ebaiyihui.healthalliance.server.service.HealthAllianceService;
import com.ebaiyihui.healthalliance.server.utils.UUIDUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HealthAllianceServiceImpl
implements HealthAllianceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HospitalHealthAllianceMapper hospitalHealthAllianceMapper;
    @Autowired
    private HospitalHealthAllianceMemberMapper hospitalHealthAllianceMemberMapper;

    @Transactional(rollbackFor={Exception.class})
    public int insertHospitalHealthAlliance(HospitalHealthAllianceDto hospitalHealthAllianceDto) {
        int flag = 0;
        hospitalHealthAllianceDto.setViewId(UUIDUtil.getUUID());
        hospitalHealthAllianceDto.setStatus(HealthAllianceEnum.PENDING_REVIEW.getValue());
        int k = this.hospitalHealthAllianceMapper.insert(hospitalHealthAllianceDto);
        if (k > 0) {
            flag = 1;
            this.logger.info("\u7533\u8bf7\u533b\u8054\u4f53\u6210\u529f========" + flag);
            if (hospitalHealthAllianceDto.getParentHosId() != null && hospitalHealthAllianceDto.getParentHosId().intValue() != 0) {
                this.logger.info("\u6709\u7236\u533b\u9662============");
                HospitalHealthAllianceMemberEntity parentHospitalHealthAllianceMember = this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByHospitalId(hospitalHealthAllianceDto.getParentHosId());
                if (hospitalHealthAllianceDto != null) {
                    flag = 1;
                    this.logger.info("\u83b7\u53d6\u7236\u533b\u9662\u4fe1\u606f\u6210\u529f=========" + flag);
                    HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = new HospitalHealthAllianceMemberEntity();
                    hospitalHealthAllianceMember.setViewId(hospitalHealthAllianceDto.getViewId());
                    hospitalHealthAllianceMember.setAllianceUuid(parentHospitalHealthAllianceMember.getAllianceUuid());
                    hospitalHealthAllianceMember.setHospitalId(hospitalHealthAllianceDto.getHospitalId());
                    hospitalHealthAllianceMember.setHospitalLevel(hospitalHealthAllianceDto.getHospitalLevel());
                    hospitalHealthAllianceMember.setParentHosId(hospitalHealthAllianceDto.getParentHosId());
                    hospitalHealthAllianceMember.setParentHosLevel(hospitalHealthAllianceDto.getParentHosLevel());
                    hospitalHealthAllianceMember.setRole(Integer.valueOf(2));
                    hospitalHealthAllianceMember.setStatus(HealthAllianceEnum.PENDING_REVIEW.getValue());
                    int j = this.hospitalHealthAllianceMemberMapper.insert(hospitalHealthAllianceMember);
                    if (j > 0) {
                        this.logger.info("\u6dfb\u52a0\u4e2d\u95f4\u8868\u6210\u529f=======" + flag);
                    } else {
                        flag = 0;
                        this.logger.info("\u6dfb\u52a0\u4e2d\u95f4\u8868\u6210\u529f=======" + flag);
                    }
                } else {
                    flag = 0;
                    this.logger.info("\u83b7\u53d6\u7236\u533b\u9662\u4fe1\u606f\u5931\u8d25=========" + flag);
                }
            } else {
                this.logger.info("\u65e0\u7236\u533b\u8054\u4f53========");
                HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = new HospitalHealthAllianceMemberEntity();
                hospitalHealthAllianceMember.setViewId(hospitalHealthAllianceDto.getViewId());
                hospitalHealthAllianceMember.setAllianceUuid(hospitalHealthAllianceDto.getViewId());
                hospitalHealthAllianceMember.setHospitalId(hospitalHealthAllianceDto.getHospitalId());
                hospitalHealthAllianceMember.setHospitalLevel(hospitalHealthAllianceDto.getHospitalLevel());
                hospitalHealthAllianceMember.setRole(Integer.valueOf(1));
                hospitalHealthAllianceMember.setStatus(HealthAllianceEnum.PENDING_REVIEW.getValue());
                int j = this.hospitalHealthAllianceMemberMapper.insert(hospitalHealthAllianceMember);
                if (j > 0) {
                    flag = 1;
                    this.logger.info("\u6dfb\u52a0\u4e2d\u95f4\u8868\u6210\u529f=======" + flag);
                } else {
                    flag = 0;
                    this.logger.info("\u6dfb\u52a0\u4e2d\u95f4\u8868\u6210\u529f=======" + flag);
                }
            }
        } else {
            flag = 0;
            this.logger.info("\u7533\u8bf7\u533b\u8054\u4f53\u5931\u8d25=========" + flag);
        }
        return flag;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateHospitalHealthAlliance(Long auditorId, Integer auditorType, Integer status, Long hospitalId) {
        int flag = 0;
        HospitalHealthAllianceEntity hospitalHealthAlliance = this.hospitalHealthAllianceMapper.selectByHosptialId(hospitalId);
        if (hospitalHealthAlliance == null) {
            this.logger.info("\u8be5\u533b\u9662\u672a\u7533\u8bf7\u533b\u8054\u4f53=========" + flag);
            return flag;
        }
        int i = this.hospitalHealthAllianceMapper.updateByHospitalId(auditorId, auditorType, status, hospitalId);
        if (i > 0) {
            this.logger.info("\u533b\u8054\u4f53\u4fee\u6539\u72b6\u6001\u6210\u529f=======" + flag);
            int j = this.hospitalHealthAllianceMemberMapper.updateByHospitalId(status, hospitalId);
            if (j > 0) {
                flag = 1;
                this.logger.info("\u4e2d\u95f4\u8868\u72b6\u6001\u4fee\u6539\u6210\u529f=======" + flag);
            } else {
                flag = 0;
                this.logger.info("\u4e2d\u95f4\u8868\u72b6\u6001\u4fee\u6539\u5931\u8d25=======" + flag);
            }
        } else {
            flag = 1;
            this.logger.info("\u533b\u8054\u4f53\u4fee\u6539\u72b6\u6001\u5931\u8d25=======" + flag);
        }
        return flag;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<HospitalHealthAllianceEntity> getListHospitalHealthAlliance() {
        List list = this.hospitalHealthAllianceMapper.getListHospitalHealthAlliance();
        return list;
    }

    public HospitalHealthAllianceEntity queryHospitalHealthAllianceByHosId(Long hospitalId) {
        return this.hospitalHealthAllianceMapper.selectByHosptialId(hospitalId);
    }

    public int saveHospitalHealthAllianceEntity(Long hospitalId, String hospitalName, Integer hospitalLevel) {
        return this.hospitalHealthAllianceMapper.saveHospitalHealthAllianceEntity(hospitalId, hospitalName, hospitalLevel);
    }

    public int insertHospitalHealthAllianceEntity(HospitalHealthAllianceEntity hospitalHealthAlliance) {
        return this.hospitalHealthAllianceMapper.insertHospitalHealthAllianceEntity(hospitalHealthAlliance);
    }

    public List<HospitalHealthAllianceEntity> queryHospitalHealthAlliance(String search, Integer type, Integer status) {
        return this.hospitalHealthAllianceMapper.queryHospitalHealthAlliance(search, type, status);
    }

    public int getCountHospitalHealthAlliance(String search, Integer type, Integer status) {
        return this.hospitalHealthAllianceMapper.getCountHospitalHealthAlliance(search, type, status);
    }

    public HospitalHealthAllianceEntity getHospitalHealthAllianceByViewId(String allianceUuid) {
        return this.hospitalHealthAllianceMapper.getHospitalHealthAllianceByViewId(allianceUuid);
    }

    public HospitalHealthAllianceEntity getHospitalHealthAllianceByViewId1(String allianceUuid) {
        return this.hospitalHealthAllianceMapper.getHospitalHealthAllianceByViewId1(allianceUuid);
    }

    public int deleteHealthAlliance(String allianceUuid, Integer status) {
        return this.hospitalHealthAllianceMapper.deleteHealthAlliance(allianceUuid, status);
    }

    public List<HospitalHealthAllianceEntity> queryHospitalHealthAllianceByAlliance(List<HospitalHealthAllianceMemberEntity> healthAllianceMemberEntityList, String search, Integer type, Integer status) {
        return this.hospitalHealthAllianceMapper.queryHospitalHealthAllianceByAlliance(healthAllianceMemberEntityList, search, type, status);
    }

    public int getCountHospitalHealthAlliance1(List<HospitalHealthAllianceMemberEntity> healthAllianceMemberEntityList, String search, Integer type, Integer status) {
        return this.hospitalHealthAllianceMapper.getCountHospitalHealthAlliance1(healthAllianceMemberEntityList, search, type, status);
    }

    public HospitalHealthAllianceEntity queryHospitalHealthAllianceByHosIdAndAllianceUuid(Long hospitalId, String allianceUuid) {
        return this.hospitalHealthAllianceMapper.queryHospitalHealthAllianceByHosIdAndAllianceUuid(hospitalId, allianceUuid);
    }

    public int updateHospitalHealthAllianceIsOnline(String allianceUuid, Integer status) {
        return this.hospitalHealthAllianceMapper.deleteHealthAlliance(allianceUuid, status);
    }

    public int queryHealthAllianceCount(List<String> hosList) {
        return this.hospitalHealthAllianceMapper.queryHealthAllianceCount(hosList);
    }

    public List<HospitalHealthAllianceEntity> queryHosHealthallianceJurisdiction(String search, Integer type, Integer status, List<String> hosList) {
        return this.hospitalHealthAllianceMapper.queryHosHealthallianceJurisdiction(search, type, status, hosList);
    }

    public String getHosHealthAllianceByName(String search) {
        return this.hospitalHealthAllianceMapper.getHosHealthAllianceByName(search);
    }
}

