/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.healthalliance.server.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.ebaiyihui.healthalliance.server.exception.ImgException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class OSSClientUtil {
    public static final Logger logger = LoggerFactory.getLogger(OSSClientUtil.class);
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private String fileDir = "";
    private OSSClient ossClient;

    public OSSClientUtil() {
        this.ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    public OSSClientUtil(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
        this.ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        this.bucketName = bucketName;
    }

    public void init() {
        this.ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    public void destory() {
        this.ossClient.shutdown();
    }

    public void uploadImgFile(String url) throws ImgException {
        File fileOnServer = new File(url);
        try {
            FileInputStream fin = new FileInputStream(fileOnServer);
            String[] split = url.split("/");
            this.uploadFile((InputStream)fin, split[split.length - 1]);
        }
        catch (FileNotFoundException e) {
            throw new ImgException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public String uploadFile(MultipartFile file) throws ImgException {
        if (file.getSize() > 0xA00000L) {
            throw new ImgException("\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710M\uff01");
        }
        String originalFilename = file.getOriginalFilename();
        String substring = originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase();
        Random random = new Random();
        String name = (long)random.nextInt(10000) + System.currentTimeMillis() + substring;
        try {
            InputStream inputStream = file.getInputStream();
            this.uploadFile(inputStream, name);
            return name;
        }
        catch (Exception e) {
            throw new ImgException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public String getImgUrl(String fileUrl) {
        if (!StringUtils.isEmpty((Object)fileUrl)) {
            String[] split = fileUrl.split("/");
            return this.getUrl(this.fileDir + split[split.length - 1]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(InputStream inputStream, String fileName) {
        String ret = "";
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(OSSClientUtil.getContentType((String)fileName.substring(fileName.lastIndexOf("."))));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            PutObjectResult putResult = this.ossClient.putObject(this.bucketName, this.fileDir + fileName, inputStream, objectMetadata);
            ret = putResult.getETag();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String getContentType(String filenameExtension) {
        if (filenameExtension.equalsIgnoreCase("bmp")) {
            return "image/bmp";
        }
        if (filenameExtension.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        if (filenameExtension.equalsIgnoreCase("jpeg") || filenameExtension.equalsIgnoreCase("jpg") || filenameExtension.equalsIgnoreCase("png")) {
            return "image/jpeg";
        }
        if (filenameExtension.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (filenameExtension.equalsIgnoreCase("txt")) {
            return "text/plain";
        }
        if (filenameExtension.equalsIgnoreCase("vsd")) {
            return "application/vnd.visio";
        }
        if (filenameExtension.equalsIgnoreCase("pptx") || filenameExtension.equalsIgnoreCase("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (filenameExtension.equalsIgnoreCase("docx") || filenameExtension.equalsIgnoreCase("doc")) {
            return "application/msword";
        }
        if (filenameExtension.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        return "image/jpeg";
    }

    public String getUrl(String key) {
        Date expiration = new Date(System.currentTimeMillis() + 315360000000L);
        URL url = this.ossClient.generatePresignedUrl(this.bucketName, key, expiration);
        if (url != null) {
            return url.toString();
        }
        return null;
    }
}

