/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.patient.client.error;

import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.utils.ClientErrorUtil;
import com.ebaiyihui.patient.client.PatientOrderClient;
import com.ebaiyihui.patient.common.model.PatientOrderEntity;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PatientOrderError
implements FallbackFactory<PatientOrderClient> {
    private static final Logger log = LoggerFactory.getLogger(PatientOrderError.class);

    public PatientOrderClient create(final Throwable cause) {
        return new PatientOrderClient(){

            @Override
            public ResultInfo save(PatientOrderEntity patientOrder) {
                log.error(cause.getMessage());
                throw new RuntimeException(cause);
            }

            @Override
            public ResultInfo batchSave(List<PatientOrderEntity> patientOrderEntityList) {
                log.error(cause.getMessage());
                throw new RuntimeException(cause);
            }

            @Override
            public ResultInfo<PageResult<List<PatientOrderEntity>>> findPatientOrderPageByPatientId(int pageNo, int pageSize, Long patientId, String userViewId) {
                return ClientErrorUtil.byError((Throwable)cause, (String)"service-patient-server");
            }

            @Override
            public ResultInfo<Long> findCountByHospitalIdAndServiceCode(Long hospitalId, Integer serviceCode) {
                return ClientErrorUtil.byError((Throwable)cause, (String)"service-patient-server");
            }
        };
    }
}

