/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.interceptor;

import com.ebaiyihui.framework.common.UserInfo;
import com.ebaiyihui.payment.utils.StringUtil;
import com.ebaiyihui.payment.wechat.config.WxPayConfig;
import com.ebaiyihui.payment.wechat.model.WechatPayConfigEntity;
import com.ebaiyihui.payment.wechat.service.WechatPayConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class WechatPayInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private WechatPayConfigService wechatPayConfigService;
    Logger logger = LoggerFactory.getLogger(WechatPayInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long startTime = System.currentTimeMillis();
        request.setAttribute("startTime", (Object)startTime);
        String uri = request.getRequestURI();
        this.logger.info("===URI===: " + uri);
        String domain = request.getServerName();
        this.logger.info(request.getSession().getId());
        this.logger.info("===domain===: " + domain);
        UserInfo userInfo = (UserInfo)request.getSession().getAttribute("userInfo");
        WechatPayConfigEntity wechatPayConfigEntity = this.wechatPayConfigService.getByHospitalId(Long.valueOf(21L));
        WxPayConfig wxPayConfig = new WxPayConfig();
        BeanUtils.copyProperties((Object)wechatPayConfigEntity, (Object)wxPayConfig);
        request.setAttribute("wxPayConfig", (Object)wxPayConfig);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        long startTime = StringUtil.toLongValue((Object)request.getAttribute("startTime"));
        this.logger.info("URI:" + request.getRequestURI() + " ,cost: " + (System.currentTimeMillis() - startTime));
    }
}

