/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.wechat.api;

import com.ebaiyihui.common.model.RabbitInfo;
import com.ebaiyihui.common.model.RabbitMqConstants;
import com.ebaiyihui.common.model.WechatRefundRequestVo;
import com.ebaiyihui.common.model.WechatUnifiedOrderRequestVo;
import com.ebaiyihui.common.model.WechatUnifiedOrderResultVo;
import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.framework.utils.DateUtils;
import com.ebaiyihui.payment.rabbitmq.RabbitMqSend;
import com.ebaiyihui.payment.wechat.bean.notify.WxPayNotifyResponse;
import com.ebaiyihui.payment.wechat.bean.notify.WxPayOrderNotifyResult;
import com.ebaiyihui.payment.wechat.bean.notify.WxPayRefundNotifyResult;
import com.ebaiyihui.payment.wechat.bean.order.WxPayMpOrderResult;
import com.ebaiyihui.payment.wechat.bean.order.WxPayNativeOrderResult;
import com.ebaiyihui.payment.wechat.bean.request.WxPayRefundRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayUnifiedOrderRequest;
import com.ebaiyihui.payment.wechat.bean.result.WxPayOrderCloseResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayRefundResult;
import com.ebaiyihui.payment.wechat.config.WxPayConfig;
import com.ebaiyihui.payment.wechat.exception.WxPayException;
import com.ebaiyihui.payment.wechat.model.PayInfoEntity;
import com.ebaiyihui.payment.wechat.model.RefundInfoEntity;
import com.ebaiyihui.payment.wechat.model.WechatPayConfigEntity;
import com.ebaiyihui.payment.wechat.service.WechatPayConfigService;
import com.ebaiyihui.payment.wechat.service.WechatRefundInfoService;
import com.ebaiyihui.payment.wechat.service.WxPayInfoService;
import com.ebaiyihui.payment.wechat.service.WxPayService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5fae\u4fe1\u652f\u4ed8\u63a5\u53e3")
@RestController
@RequestMapping(value={"/api/v1/payment/wechat"})
public class WechatController
extends BaseController {
    @Autowired
    private WechatPayConfigService wechatPayConfigService;
    @Autowired
    private WxPayInfoService wxPayInfoService;
    @Autowired
    private RabbitMqSend rabbitMqSend;
    Logger logger = LoggerFactory.getLogger(WechatController.class);
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private WechatRefundInfoService wechatRefundInfoService;
    @Autowired
    private TopicExchange topicExchange;

    @ApiOperation(value="\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355", notes="\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u8d77\u8c03\u652f\u4ed8\u6240\u9700\u53c2\u6570")
    @PostMapping(value={"/unifiedorder"})
    public ResultInfo<WechatUnifiedOrderResultVo> unifiedOrder(@RequestBody WechatUnifiedOrderRequestVo wechatUnifiedOrderRequest, @RequestParam(value="hospitalId", required=false) Long hospitalId) {
        WxPayUnifiedOrderRequest request = new WxPayUnifiedOrderRequest();
        BeanUtils.copyProperties((Object)wechatUnifiedOrderRequest, (Object)request);
        this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u4e0b\u5355\u53c2\u6570\uff1a" + wechatUnifiedOrderRequest.toString());
        WxPayConfig wxPayConfig = null;
        WechatUnifiedOrderResultVo resultVo = new WechatUnifiedOrderResultVo();
        try {
            WechatPayConfigEntity wechatPayConfigEntity = this.wechatPayConfigService.getByHospitalId(hospitalId);
            wxPayConfig = new WxPayConfig();
            BeanUtils.copyProperties((Object)wechatPayConfigEntity, (Object)wxPayConfig);
            this.wxPayService.setConfig(wxPayConfig);
            switch (request.getTradeType()) {
                case "JSAPI": {
                    WxPayMpOrderResult result = (WxPayMpOrderResult)this.wxPayService.createOrder(request);
                    resultVo.setAppId(result.getAppId());
                    resultVo.setNonceStr(result.getNonceStr());
                    resultVo.setPrepayId(result.getPackageValue());
                    resultVo.setPaySign(result.getPaySign());
                    resultVo.setSingType(wxPayConfig.getSignType());
                    resultVo.setTimeStamp(String.valueOf(System.currentTimeMillis() / 1000L));
                    break;
                }
                case "NATIVE": {
                    WxPayNativeOrderResult wxPayNativeOrderResult = (WxPayNativeOrderResult)this.wxPayService.createOrder(request);
                    resultVo.setCodeUrl(wxPayNativeOrderResult.getCodeUrl());
                    break;
                }
            }
        }
        catch (WxPayException e) {
            this.logger.error(request.getOutTradeNo() + "\u4e0b\u5355\u5931\u8d25:", (Throwable)e);
            return this.returnFailure(e.getMessage());
        }
        this.logger.info("\u4e0b\u5355\u6210\u529f\uff1a" + wechatUnifiedOrderRequest.getOutTradeNo());
        return this.returnSucceed((Object)resultVo, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @PostMapping(value={"/refund"})
    public ResultInfo refund(@RequestBody WechatRefundRequestVo wechatRefundRequestVo, @RequestParam(value="hospitalId") Long hospitalId) {
        WxPayRefundRequest refundRequest = new WxPayRefundRequest();
        BeanUtils.copyProperties((Object)wechatRefundRequestVo, (Object)refundRequest);
        this.logger.info("\u9000\u6b3e\u7533\u8bf7\u53c2\u6570\uff1a" + wechatRefundRequestVo.toString());
        WxPayConfig wxPayConfig = null;
        WxPayRefundResult refundResult = null;
        WechatPayConfigEntity wechatPayConfigEntity = this.wechatPayConfigService.getByHospitalId(hospitalId);
        wxPayConfig = new WxPayConfig();
        BeanUtils.copyProperties((Object)wechatPayConfigEntity, (Object)wxPayConfig);
        wxPayConfig.setNotifyUrl(wechatPayConfigEntity.getRefundNotifyUrl());
        this.wxPayService.setConfig(wxPayConfig);
        String result = null;
        try {
            refundResult = this.wxPayService.refund(refundRequest);
            result = refundResult.getResultCode();
            if (!result.equals("SUCCESS")) {
                return this.returnFailure(refundResult.getErrCodeDes());
            }
        }
        catch (WxPayException e) {
            this.logger.error("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff1a" + e.getCustomErrorMsg());
            return this.returnFailure(e.getMessage());
        }
        return this.returnSucceed((Object)"SUCCESS", ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @PostMapping(value={"/refundnotifyurl"})
    public String refundNotifyUrl(HttpServletRequest request) {
        String xmlResult = null;
        try {
            xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            WxPayRefundNotifyResult refundResult = this.wxPayService.parseRefundNotifyResult(xmlResult);
            this.logger.info("\u9000\u6b3e\u7ed3\u679c\uff1a" + refundResult.toString());
            RefundInfoEntity refundInfoEntity = this.wechatRefundInfoService.getByOutRefundNo(refundResult.getReqInfo().getOutRefundNo());
            if (refundInfoEntity == null) {
                refundInfoEntity = new RefundInfoEntity();
                refundInfoEntity.setOutRefundNo(refundResult.getReqInfo().getOutRefundNo());
                refundInfoEntity.setRefundId(refundResult.getReqInfo().getRefundId());
                refundInfoEntity.setRefundFee(refundResult.getReqInfo().getRefundFee());
                refundInfoEntity.setOutTradeNo(refundResult.getReqInfo().getOutTradeNo());
                refundInfoEntity.setTransactionId(refundResult.getReqInfo().getTransactionId());
                refundInfoEntity.setTotalFee(refundResult.getReqInfo().getTotalFee());
                refundInfoEntity.setSettlementRefundFee(refundResult.getReqInfo().getSettlementRefundFee());
                refundInfoEntity.setRefundStatus(refundResult.getReqInfo().getRefundStatus());
                refundInfoEntity.setRefundRecvAccout(refundResult.getReqInfo().getRefundRecvAccout());
                refundInfoEntity.setSuccessTime(refundResult.getReqInfo().getSuccessTime());
                this.wechatRefundInfoService.save(refundInfoEntity);
            }
            RabbitInfo rabbitInfo = new RabbitInfo();
            rabbitInfo.setTransactionId(refundResult.getReqInfo().getTransactionId());
            rabbitInfo.setTradeNo(refundResult.getReqInfo().getOutTradeNo());
            rabbitInfo.setTotalFee(refundResult.getReqInfo().getTotalFee().intValue());
            rabbitInfo.setType(RabbitMqConstants.REFUND);
            Boolean flag = false;
            if (refundResult.getReqInfo().getRefundStatus().equals("SUCCESS")) {
                flag = true;
                rabbitInfo.setDateTime(DateUtils.convertStringToDate((String)"", (String)refundResult.getReqInfo().getSuccessTime()));
            }
            rabbitInfo.setIsSuccess(flag);
            this.rabbitMqSend.send(rabbitInfo);
        }
        catch (Exception e) {
            this.logger.error("\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u9519\u8bef\uff1a" + e.getMessage());
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
        return WxPayNotifyResponse.success((String)"OK");
    }

    @PostMapping(value={"/notifyurl"})
    public String notifyUrl(HttpServletRequest request) {
        String xmlResult = null;
        try {
            xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            WxPayOrderNotifyResult result = this.wxPayService.parseOrderNotifyResult(xmlResult);
            this.logger.info("\u652f\u4ed8\u7ed3\u679c\uff1a" + result.toString());
            PayInfoEntity payInfoEntity = this.wxPayInfoService.getByOutTradeNo(result.getOutTradeNo());
            if (null == payInfoEntity) {
                payInfoEntity = new PayInfoEntity();
                BeanUtils.copyProperties((Object)result, (Object)payInfoEntity);
                this.wxPayInfoService.insert(payInfoEntity);
            }
            RabbitInfo rabbitInfo = new RabbitInfo();
            if (result.getResultCode().equals("SUCCESS")) {
                this.logger.info("\u652f\u4ed8\u6210\u529f\uff1a" + result.getOutTradeNo());
                rabbitInfo.setIsSuccess(Boolean.valueOf(true));
            } else {
                rabbitInfo.setIsSuccess(Boolean.valueOf(false));
                this.logger.error("\u652f\u4ed8\u5931\u8d25\uff1a" + result.getOutTradeNo() + "\n" + result.getErrCode() + result.getErrCodeDes());
            }
            rabbitInfo.setTradeNo(result.getOutTradeNo());
            rabbitInfo.setTransactionId(result.getTransactionId());
            rabbitInfo.setTotalFee(result.getTotalFee().intValue());
            rabbitInfo.setDateTime(DateUtils.convertStringToDate((String)"yyyyMMddHHmmss", (String)result.getTimeEnd()));
            rabbitInfo.setType(RabbitMqConstants.PAY);
            this.rabbitMqSend.send(rabbitInfo);
            return WxPayNotifyResponse.success((String)"OK");
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u6536\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u9519\u8bef", (Throwable)e);
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/closeorder"})
    public ResultInfo closeOrder(@RequestParam(value="outTradeNo") String outTradeNo, @RequestParam(value="hospitalId") Long hospitalId) {
        this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u5173\u95ed\u8ba2\u5355\uff1a" + outTradeNo);
        WechatPayConfigEntity wechatPayConfigEntity = this.wechatPayConfigService.getByHospitalId(hospitalId);
        WxPayConfig wxPayConfig = null;
        wxPayConfig = new WxPayConfig();
        BeanUtils.copyProperties((Object)wechatPayConfigEntity, (Object)wxPayConfig);
        this.wxPayService.setConfig(wxPayConfig);
        WxPayOrderCloseResult wxPayOrderCloseResult = null;
        try {
            wxPayOrderCloseResult = this.wxPayService.closeOrder(outTradeNo);
        }
        catch (WxPayException e) {
            this.logger.error("\u5173\u95ed\u8ba2\u5355\u5931\u8d25\uff1a" + (Object)((Object)e));
            e.printStackTrace();
            return this.returnFailure("\u5173\u95ed\u8ba2\u5355\u5931\u8d25" + (Object)((Object)e));
        }
        return this.returnSucceed((Object)wxPayOrderCloseResult, ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

