/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.wechat.bean.request;

import com.ebaiyihui.common.annotation.Required;
import com.ebaiyihui.payment.wechat.bean.request.BaseWxPayRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayRefundRequest;
import com.ebaiyihui.payment.wechat.config.WxPayConfig;
import com.ebaiyihui.payment.wechat.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayRefundRequest
extends BaseWxPayRequest {
    private static final String[] REFUND_ACCOUNT = new String[]{"REFUND_SOURCE_RECHARGE_FUNDS", "REFUND_SOURCE_UNSETTLED_FUNDS"};
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @Required
    @XStreamAlias(value="out_refund_no")
    private String outRefundNo;
    @Required
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @Required
    @XStreamAlias(value="refund_fee")
    private Integer refundFee;
    @XStreamAlias(value="refund_fee_type")
    private String refundFeeType;
    @XStreamAlias(value="op_user_id")
    private String opUserId;
    @XStreamAlias(value="refund_account")
    private String refundAccount;
    @XStreamAlias(value="refund_desc")
    private String refundDesc;
    @XStreamAlias(value="notify_url")
    private String notifyUrl;

    public void checkAndSign(WxPayConfig config) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.getOpUserId())) {
            this.setOpUserId(config.getMchId());
        }
        super.checkAndSign(config);
    }

    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.getRefundAccount()) && !ArrayUtils.contains((Object[])REFUND_ACCOUNT, (Object)this.getRefundAccount())) {
            throw new WxPayException(String.format("refund_account\u76ee\u524d\u5fc5\u987b\u4e3a%s\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a%s", Arrays.toString(REFUND_ACCOUNT), this.getRefundAccount()));
        }
        if (StringUtils.isBlank((CharSequence)this.getOutTradeNo()) && StringUtils.isBlank((CharSequence)this.getTransactionId())) {
            throw new WxPayException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u63d0\u4f9b\u4e00\u4e2a");
        }
    }

    public static WxPayRefundRequestBuilder newBuilder() {
        return new WxPayRefundRequestBuilder();
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public Integer getRefundFee() {
        return this.refundFee;
    }

    public String getRefundFeeType() {
        return this.refundFeeType;
    }

    public String getOpUserId() {
        return this.opUserId;
    }

    public String getRefundAccount() {
        return this.refundAccount;
    }

    public String getRefundDesc() {
        return this.refundDesc;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }

    public void setRefundFeeType(String refundFeeType) {
        this.refundFeeType = refundFeeType;
    }

    public void setOpUserId(String opUserId) {
        this.opUserId = opUserId;
    }

    public void setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String toString() {
        return "WxPayRefundRequest(deviceInfo=" + this.getDeviceInfo() + ", transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", outRefundNo=" + this.getOutRefundNo() + ", totalFee=" + this.getTotalFee() + ", refundFee=" + this.getRefundFee() + ", refundFeeType=" + this.getRefundFeeType() + ", opUserId=" + this.getOpUserId() + ", refundAccount=" + this.getRefundAccount() + ", refundDesc=" + this.getRefundDesc() + ", notifyUrl=" + this.getNotifyUrl() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundRequest)) {
            return false;
        }
        WxPayRefundRequest other = (WxPayRefundRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$outRefundNo = this.getOutRefundNo();
        String other$outRefundNo = other.getOutRefundNo();
        if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        Integer this$refundFee = this.getRefundFee();
        Integer other$refundFee = other.getRefundFee();
        if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
            return false;
        }
        String this$refundFeeType = this.getRefundFeeType();
        String other$refundFeeType = other.getRefundFeeType();
        if (this$refundFeeType == null ? other$refundFeeType != null : !this$refundFeeType.equals(other$refundFeeType)) {
            return false;
        }
        String this$opUserId = this.getOpUserId();
        String other$opUserId = other.getOpUserId();
        if (this$opUserId == null ? other$opUserId != null : !this$opUserId.equals(other$opUserId)) {
            return false;
        }
        String this$refundAccount = this.getRefundAccount();
        String other$refundAccount = other.getRefundAccount();
        if (this$refundAccount == null ? other$refundAccount != null : !this$refundAccount.equals(other$refundAccount)) {
            return false;
        }
        String this$refundDesc = this.getRefundDesc();
        String other$refundDesc = other.getRefundDesc();
        if (this$refundDesc == null ? other$refundDesc != null : !this$refundDesc.equals(other$refundDesc)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        return !(this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $outRefundNo = this.getOutRefundNo();
        result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        Integer $refundFee = this.getRefundFee();
        result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
        String $refundFeeType = this.getRefundFeeType();
        result = result * 59 + ($refundFeeType == null ? 43 : $refundFeeType.hashCode());
        String $opUserId = this.getOpUserId();
        result = result * 59 + ($opUserId == null ? 43 : $opUserId.hashCode());
        String $refundAccount = this.getRefundAccount();
        result = result * 59 + ($refundAccount == null ? 43 : $refundAccount.hashCode());
        String $refundDesc = this.getRefundDesc();
        result = result * 59 + ($refundDesc == null ? 43 : $refundDesc.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        return result;
    }

    public WxPayRefundRequest() {
    }

    public WxPayRefundRequest(String deviceInfo, String transactionId, String outTradeNo, String outRefundNo, Integer totalFee, Integer refundFee, String refundFeeType, String opUserId, String refundAccount, String refundDesc, String notifyUrl) {
        this.deviceInfo = deviceInfo;
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
        this.outRefundNo = outRefundNo;
        this.totalFee = totalFee;
        this.refundFee = refundFee;
        this.refundFeeType = refundFeeType;
        this.opUserId = opUserId;
        this.refundAccount = refundAccount;
        this.refundDesc = refundDesc;
        this.notifyUrl = notifyUrl;
    }
}

