/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.wechat.bean.result;

import com.ebaiyihui.payment.wechat.bean.result.BaseWxPayResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayRefundCouponInfo;
import com.ebaiyihui.payment.wechat.bean.result.WxPayRefundQueryResult;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="xml")
public class WxPayRefundQueryResult
extends BaseWxPayResult {
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @XStreamAlias(value="settlement_total_fee")
    private Integer settlementTotalFee;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="cash_fee")
    private Integer cashFee;
    @XStreamAlias(value="refund_count")
    private Integer refundCount;
    private List<RefundRecord> refundRecords;

    public void composeRefundRecords() {
        if (this.refundCount != null && this.refundCount > 0) {
            this.refundRecords = Lists.newArrayList();
            for (int i = 0; i < this.refundCount; ++i) {
                RefundRecord refundRecord = new RefundRecord();
                this.refundRecords.add(refundRecord);
                refundRecord.setOutRefundNo(this.getXmlValue(new String[]{"xml/out_refund_no_" + i}));
                refundRecord.setRefundId(this.getXmlValue(new String[]{"xml/refund_id_" + i}));
                refundRecord.setRefundChannel(this.getXmlValue(new String[]{"xml/refund_channel_" + i}));
                refundRecord.setRefundFee(this.getXmlValueAsInt(new String[]{"xml/refund_fee_" + i}));
                refundRecord.setSettlementRefundFee(this.getXmlValueAsInt(new String[]{"xml/settlement_refund_fee_" + i}));
                refundRecord.setCouponRefundFee(this.getXmlValueAsInt(new String[]{"xml/coupon_refund_fee_" + i}));
                refundRecord.setCouponRefundCount(this.getXmlValueAsInt(new String[]{"xml/coupon_refund_count_" + i}));
                refundRecord.setRefundStatus(this.getXmlValue(new String[]{"xml/refund_status_" + i}));
                refundRecord.setRefundRecvAccount(this.getXmlValue(new String[]{"xml/refund_recv_accout_" + i}));
                refundRecord.setRefundSuccessTime(this.getXmlValue(new String[]{"xml/refund_success_time_" + i}));
                if (refundRecord.getCouponRefundCount() == null || refundRecord.getCouponRefundCount() == 0) continue;
                ArrayList coupons = Lists.newArrayList();
                for (int j = 0; j < refundRecord.getCouponRefundCount(); ++j) {
                    coupons.add(new WxPayRefundCouponInfo(this.getXmlValue(new String[]{"xml/coupon_refund_id_" + i + "_" + j}), this.getXmlValueAsInt(new String[]{"xml/coupon_refund_fee_" + i + "_" + j}), this.getXmlValue(new String[]{"xml/coupon_type_" + i + "_" + j})));
                }
                refundRecord.setRefundCoupons((List)coupons);
            }
        }
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public Integer getSettlementTotalFee() {
        return this.settlementTotalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public Integer getCashFee() {
        return this.cashFee;
    }

    public Integer getRefundCount() {
        return this.refundCount;
    }

    public List<RefundRecord> getRefundRecords() {
        return this.refundRecords;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setSettlementTotalFee(Integer settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public void setRefundCount(Integer refundCount) {
        this.refundCount = refundCount;
    }

    public void setRefundRecords(List<RefundRecord> refundRecords) {
        this.refundRecords = refundRecords;
    }

    public String toString() {
        return "WxPayRefundQueryResult(deviceInfo=" + this.getDeviceInfo() + ", transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", totalFee=" + this.getTotalFee() + ", settlementTotalFee=" + this.getSettlementTotalFee() + ", feeType=" + this.getFeeType() + ", cashFee=" + this.getCashFee() + ", refundCount=" + this.getRefundCount() + ", refundRecords=" + this.getRefundRecords() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundQueryResult)) {
            return false;
        }
        WxPayRefundQueryResult other = (WxPayRefundQueryResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        Integer this$settlementTotalFee = this.getSettlementTotalFee();
        Integer other$settlementTotalFee = other.getSettlementTotalFee();
        if (this$settlementTotalFee == null ? other$settlementTotalFee != null : !((Object)this$settlementTotalFee).equals(other$settlementTotalFee)) {
            return false;
        }
        String this$feeType = this.getFeeType();
        String other$feeType = other.getFeeType();
        if (this$feeType == null ? other$feeType != null : !this$feeType.equals(other$feeType)) {
            return false;
        }
        Integer this$cashFee = this.getCashFee();
        Integer other$cashFee = other.getCashFee();
        if (this$cashFee == null ? other$cashFee != null : !((Object)this$cashFee).equals(other$cashFee)) {
            return false;
        }
        Integer this$refundCount = this.getRefundCount();
        Integer other$refundCount = other.getRefundCount();
        if (this$refundCount == null ? other$refundCount != null : !((Object)this$refundCount).equals(other$refundCount)) {
            return false;
        }
        List this$refundRecords = this.getRefundRecords();
        List other$refundRecords = other.getRefundRecords();
        return !(this$refundRecords == null ? other$refundRecords != null : !((Object)this$refundRecords).equals(other$refundRecords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundQueryResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        Integer $settlementTotalFee = this.getSettlementTotalFee();
        result = result * 59 + ($settlementTotalFee == null ? 43 : ((Object)$settlementTotalFee).hashCode());
        String $feeType = this.getFeeType();
        result = result * 59 + ($feeType == null ? 43 : $feeType.hashCode());
        Integer $cashFee = this.getCashFee();
        result = result * 59 + ($cashFee == null ? 43 : ((Object)$cashFee).hashCode());
        Integer $refundCount = this.getRefundCount();
        result = result * 59 + ($refundCount == null ? 43 : ((Object)$refundCount).hashCode());
        List $refundRecords = this.getRefundRecords();
        result = result * 59 + ($refundRecords == null ? 43 : ((Object)$refundRecords).hashCode());
        return result;
    }
}

