/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.wechat.exception;

import com.ebaiyihui.common.enums.WechatPayErrorMsgEnum;
import com.ebaiyihui.common.enums.WxMpErrorMsgEnum;
import com.ebaiyihui.common.enums.WxType;
import com.ebaiyihui.payment.wechat.exception.WxError;
import com.ebaiyihui.payment.wechat.util.WxGsonBuilder;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class WxError
implements Serializable {
    private static final long serialVersionUID = 7869786563361406291L;
    private int errorCode;
    private String errorMsg;
    private String errorMsgEn;
    private String json;

    public static WxError fromJson(String json) {
        return WxError.fromJson((String)json, null);
    }

    public static WxError fromJson(String json, WxType type) {
        String msg;
        WxError wxError = (WxError)WxGsonBuilder.create().fromJson(json, WxError.class);
        if (StringUtils.isNotEmpty((CharSequence)wxError.getErrorMsg())) {
            wxError.setErrorMsgEn(wxError.getErrorMsg());
        }
        if (type == null) {
            return wxError;
        }
        if (type == WxType.MP) {
            String msg2 = WxMpErrorMsgEnum.findMsgByCode((int)wxError.getErrorCode());
            if (msg2 != null) {
                wxError.setErrorMsg(msg2);
            }
        } else if (type == WxType.Pay && (msg = WechatPayErrorMsgEnum.findMsgByCode((int)wxError.getErrorCode())) != null) {
            wxError.setErrorMsg(msg);
        }
        return wxError;
    }

    public String toString() {
        if (this.json != null) {
            return this.json;
        }
        return "\u9519\u8bef: Code=" + this.errorCode + ", Msg=" + this.errorMsg;
    }

    WxError(int errorCode, String errorMsg, String errorMsgEn, String json) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.errorMsgEn = errorMsgEn;
        this.json = json;
    }

    public static WxErrorBuilder builder() {
        return new WxErrorBuilder();
    }

    private WxError() {
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorMsgEn() {
        return this.errorMsgEn;
    }

    public String getJson() {
        return this.json;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setErrorMsgEn(String errorMsgEn) {
        this.errorMsgEn = errorMsgEn;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxError)) {
            return false;
        }
        WxError other = (WxError)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$errorMsgEn = this.getErrorMsgEn();
        String other$errorMsgEn = other.getErrorMsgEn();
        if (this$errorMsgEn == null ? other$errorMsgEn != null : !this$errorMsgEn.equals(other$errorMsgEn)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        return !(this$json == null ? other$json != null : !this$json.equals(other$json));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getErrorCode();
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $errorMsgEn = this.getErrorMsgEn();
        result = result * 59 + ($errorMsgEn == null ? 43 : $errorMsgEn.hashCode());
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        return result;
    }
}

