/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.wechat.service.impl;

import com.ebaiyihui.payment.wechat.bean.WxPayApiData;
import com.ebaiyihui.payment.wechat.bean.coupon.WxPayCouponInfoQueryRequest;
import com.ebaiyihui.payment.wechat.bean.coupon.WxPayCouponInfoQueryResult;
import com.ebaiyihui.payment.wechat.bean.coupon.WxPayCouponSendRequest;
import com.ebaiyihui.payment.wechat.bean.coupon.WxPayCouponSendResult;
import com.ebaiyihui.payment.wechat.bean.coupon.WxPayCouponStockQueryRequest;
import com.ebaiyihui.payment.wechat.bean.coupon.WxPayCouponStockQueryResult;
import com.ebaiyihui.payment.wechat.bean.notify.WxPayOrderNotifyResult;
import com.ebaiyihui.payment.wechat.bean.notify.WxPayRefundNotifyResult;
import com.ebaiyihui.payment.wechat.bean.notify.WxScanPayNotifyResult;
import com.ebaiyihui.payment.wechat.bean.order.WxPayAppOrderResult;
import com.ebaiyihui.payment.wechat.bean.order.WxPayMpOrderResult;
import com.ebaiyihui.payment.wechat.bean.order.WxPayMwebOrderResult;
import com.ebaiyihui.payment.wechat.bean.order.WxPayNativeOrderResult;
import com.ebaiyihui.payment.wechat.bean.request.WxPayAuthcode2OpenidRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayDefaultRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayDownloadBillRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayDownloadFundFlowRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayMicropayRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayOrderCloseRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayOrderQueryRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayOrderReverseRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayQueryCommentRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayRedpackQueryRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayRefundQueryRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayRefundRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayReportRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPaySendRedpackRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayShorturlRequest;
import com.ebaiyihui.payment.wechat.bean.request.WxPayUnifiedOrderRequest;
import com.ebaiyihui.payment.wechat.bean.result.BaseWxPayResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayAuthcode2OpenidResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayBillBaseResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayBillResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayCommonResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayFundFlowBaseResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayFundFlowResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayMicropayResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayOrderCloseResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayOrderQueryResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayOrderReverseResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayRedpackQueryResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayRefundQueryResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayRefundResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPaySandboxSignKeyResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPaySendRedpackResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayShorturlResult;
import com.ebaiyihui.payment.wechat.bean.result.WxPayUnifiedOrderResult;
import com.ebaiyihui.payment.wechat.config.WxPayConfig;
import com.ebaiyihui.payment.wechat.constant.WxPayConstants;
import com.ebaiyihui.payment.wechat.exception.WxPayException;
import com.ebaiyihui.payment.wechat.service.WxPayService;
import com.ebaiyihui.payment.wechat.util.SignUtils;
import com.github.binarywang.utils.qrcode.QrcodeUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import jodd.io.ZipUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxPayServiceImpl
implements WxPayService {
    private static final String PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static ThreadLocal<WxPayApiData> wxApiData = new ThreadLocal();
    protected WxPayConfig config;

    public WxPayConfig getConfig() {
        return this.config;
    }

    public void setConfig(WxPayConfig config) {
        this.config = config;
    }

    public String getPayBaseUrl() {
        if (this.getConfig().isUseSandboxEnv()) {
            return "https://api.mch.weixin.qq.com/sandboxnew";
        }
        return PAY_BASE_URL;
    }

    public WxPayRefundResult refund(WxPayRefundRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/refund";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRefundResult result = (WxPayRefundResult)BaseWxPayResult.fromXML((String)responseContent, WxPayRefundResult.class);
        result.composeRefundCoupons();
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayRefundQueryResult refundQuery(String transactionId, String outTradeNo, String outRefundNo, String refundId) throws WxPayException {
        WxPayRefundQueryRequest request = new WxPayRefundQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setOutRefundNo(StringUtils.trimToNull((String)outRefundNo));
        request.setRefundId(StringUtils.trimToNull((String)refundId));
        return this.refundQuery(request);
    }

    public WxPayRefundQueryResult refundQuery(WxPayRefundQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/refundquery";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayRefundQueryResult result = (WxPayRefundQueryResult)BaseWxPayResult.fromXML((String)responseContent, WxPayRefundQueryResult.class);
        result.composeRefundRecords();
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayOrderNotifyResult parseOrderNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML((String)xmlData);
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult((WxPayService)this, this.getConfig().getSignType(), false);
            return result;
        }
        catch (WxPayException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public WxPayRefundNotifyResult parseRefundNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxPayRefundNotifyResult result = WxPayRefundNotifyResult.fromXML((String)xmlData, (String)this.getConfig().getMchKey());
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public WxScanPayNotifyResult parseScanPayNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxScanPayNotifyResult result = (WxScanPayNotifyResult)BaseWxPayResult.fromXML((String)xmlData, WxScanPayNotifyResult.class);
            this.log.debug("\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult((WxPayService)this, this.getConfig().getSignType(), false);
            return result;
        }
        catch (WxPayException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public WxPaySendRedpackResult sendRedpack(WxPaySendRedpackRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendredpack";
        if (request.getAmtType() != null) {
            url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendgroupredpack";
        }
        String responseContent = this.post(url, request.toXML(), true);
        return (WxPaySendRedpackResult)BaseWxPayResult.fromXML((String)responseContent, WxPaySendRedpackResult.class);
    }

    public WxPayRedpackQueryResult queryRedpack(String mchBillNo) throws WxPayException {
        WxPayRedpackQueryRequest request = new WxPayRedpackQueryRequest();
        request.setMchBillNo(mchBillNo);
        request.setBillType("MCHT");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gethbinfo";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRedpackQueryResult result = (WxPayRedpackQueryResult)BaseWxPayResult.fromXML((String)responseContent, WxPayRedpackQueryResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxPayException {
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        return this.queryOrder(request);
    }

    public WxPayOrderQueryResult queryOrder(WxPayOrderQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/orderquery";
        String responseContent = this.post(url, request.toXML(), false);
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new WxPayException("\u65e0\u54cd\u5e94\u7ed3\u679c");
        }
        WxPayOrderQueryResult result = (WxPayOrderQueryResult)BaseWxPayResult.fromXML((String)responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new WxPayException("out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        return this.closeOrder(request);
    }

    public WxPayOrderCloseResult closeOrder(WxPayOrderCloseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/closeorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayOrderCloseResult result = (WxPayOrderCloseResult)BaseWxPayResult.fromXML((String)responseContent, WxPayOrderCloseResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public <T> T createOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new WxPayException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        switch (request.getTradeType()) {
            case "MWEB": {
                return (T)new WxPayMwebOrderResult(unifiedOrderResult.getMwebUrl());
            }
            case "NATIVE": {
                return (T)new WxPayNativeOrderResult(unifiedOrderResult.getCodeURL());
            }
            case "APP": {
                String appId = unifiedOrderResult.getAppId();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubAppId())) {
                    appId = unifiedOrderResult.getSubAppId();
                }
                HashMap<String, String> configMap = new HashMap<String, String>(8);
                String partnerId = StringUtils.isEmpty((CharSequence)request.getMchId()) ? this.getConfig().getMchId() : request.getMchId();
                configMap.put("prepayid", prepayId);
                configMap.put("partnerid", partnerId);
                String packageValue = "Sign=WXPay";
                configMap.put("package", packageValue);
                configMap.put("timestamp", timestamp);
                configMap.put("noncestr", nonceStr);
                configMap.put("appid", appId);
                WxPayAppOrderResult result = WxPayAppOrderResult.builder().sign(SignUtils.createSign(configMap, null, (String)this.getConfig().getMchKey(), null)).prepayId(prepayId).partnerId(partnerId).appId(appId).packageValue(packageValue).timeStamp(timestamp).nonceStr(nonceStr).build();
                return (T)result;
            }
            case "JSAPI": {
                String signType = "MD5";
                String appid = unifiedOrderResult.getAppId();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubAppId())) {
                    appid = unifiedOrderResult.getSubAppId();
                }
                WxPayMpOrderResult payResult = WxPayMpOrderResult.builder().appId(appid).timeStamp(timestamp).nonceStr(nonceStr).packageValue("prepay_id=" + prepayId).signType(signType).build();
                payResult.setPaySign(SignUtils.createSign((Object)payResult, (String)signType, (String)this.getConfig().getMchKey(), null));
                return (T)payResult;
            }
        }
        throw new WxPayException("\u8be5\u4ea4\u6613\u7c7b\u578b\u6682\u4e0d\u652f\u6301");
    }

    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/unifiedorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayUnifiedOrderResult result = (WxPayUnifiedOrderResult)BaseWxPayResult.fromXML((String)responseContent, WxPayUnifiedOrderResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public byte[] createScanPayQrcodeMode1(String productId, File logoFile, Integer sideLength) {
        String content = this.createScanPayQrcodeMode1(productId);
        return this.createQrcode(content, logoFile, sideLength);
    }

    public String createScanPayQrcodeMode1(String productId) {
        StringBuilder codeUrl = new StringBuilder("weixin://wxpay/bizpayurl?");
        HashMap params = Maps.newHashMap();
        params.put("appid", this.getConfig().getAppId());
        params.put("mch_id", this.getConfig().getMchId());
        params.put("product_id", productId);
        params.put("time_stamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = SignUtils.createSign((Map)params, null, (String)this.getConfig().getMchKey(), null);
        params.put("sign", sign);
        for (String key : params.keySet()) {
            codeUrl.append(key).append("=").append((String)params.get(key)).append("&");
        }
        String content = codeUrl.toString().substring(0, codeUrl.length() - 1);
        this.log.debug("\u626b\u7801\u652f\u4ed8\u6a21\u5f0f\u4e00\u751f\u6210\u4e8c\u7ef4\u7801\u7684URL:{}", (Object)content);
        return content;
    }

    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        return this.createQrcode(codeUrl, logoFile, sideLength);
    }

    private byte[] createQrcode(String content, File logoFile, Integer sideLength) {
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)content, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)content, (int)sideLength, (File)logoFile);
    }

    public void report(WxPayReportRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/payitil/report";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCommonResult result = (WxPayCommonResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCommonResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
    }

    public WxPayBillResult downloadBill(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        if (!"ALL".equals(billType)) {
            throw new WxPayException("\u76ee\u524d\u4ec5\u652f\u6301ALL\u7c7b\u578b\u7684\u5bf9\u8d26\u5355\u4e0b\u8f7d");
        }
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillType(billType);
        request.setBillDate(billDate);
        request.setTarType(tarType);
        request.setDeviceInfo(deviceInfo);
        return this.downloadBill(request);
    }

    public WxPayBillResult downloadBill(WxPayDownloadBillRequest request) throws WxPayException {
        String responseContent;
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadbill";
        if ("GZIP".equals(request.getTarType())) {
            responseContent = this.handleGzipBill(url, request.toXML());
        } else {
            responseContent = this.post(url, request.toXML(), false);
            if (responseContent.startsWith("<")) {
                throw WxPayException.from((BaseWxPayResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCommonResult.class));
            }
        }
        return this.handleBill(request.getBillType(), responseContent);
    }

    private WxPayBillResult handleBill(String billType, String responseContent) {
        if (!"ALL".equals(billType)) {
            return null;
        }
        return this.handleAllBill(responseContent);
    }

    private String handleGzipBill(String url, String requestStr) throws WxPayException {
        try {
            byte[] responseBytes = this.postForBytes(url, requestStr, false);
            Path tempDirectory = Files.createTempDirectory("bill", new FileAttribute[0]);
            Path path = Paths.get(tempDirectory.toString(), System.currentTimeMillis() + ".gzip");
            Files.write(path, responseBytes, new OpenOption[0]);
            try {
                List<String> allLines = Files.readAllLines(ZipUtil.ungzip((File)path.toFile()).toPath(), StandardCharsets.UTF_8);
                return Joiner.on((String)"\n").join(allLines);
            }
            catch (ZipException e) {
                if (e.getMessage().contains("Not in GZIP format")) {
                    throw WxPayException.from((BaseWxPayResult)BaseWxPayResult.fromXML((String)new String(responseBytes, StandardCharsets.UTF_8), WxPayCommonResult.class));
                }
                this.log.error("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.log.error("\u89e3\u6790\u5bf9\u8d26\u5355\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    private WxPayBillResult handleAllBill(String responseContent) {
        WxPayBillResult wxPayBillResult = new WxPayBillResult();
        String listStr = "";
        String objStr = "";
        if (responseContent.contains("\u603b\u4ea4\u6613\u5355\u6570")) {
            listStr = responseContent.substring(0, responseContent.indexOf("\u603b\u4ea4\u6613\u5355\u6570"));
            objStr = responseContent.substring(responseContent.indexOf("\u603b\u4ea4\u6613\u5355\u6570"));
        }
        LinkedList<WxPayBillBaseResult> wxPayBillBaseResultLst = new LinkedList<WxPayBillBaseResult>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayBillBaseResult wxPayBillBaseResult = new WxPayBillBaseResult();
            wxPayBillBaseResult.setTradeTime(tempStr[k].trim());
            wxPayBillBaseResult.setAppId(tempStr[k + 1].trim());
            wxPayBillBaseResult.setMchId(tempStr[k + 2].trim());
            wxPayBillBaseResult.setSubMchId(tempStr[k + 3].trim());
            wxPayBillBaseResult.setDeviceInfo(tempStr[k + 4].trim());
            wxPayBillBaseResult.setTransactionId(tempStr[k + 5].trim());
            wxPayBillBaseResult.setOutTradeNo(tempStr[k + 6].trim());
            wxPayBillBaseResult.setOpenId(tempStr[k + 7].trim());
            wxPayBillBaseResult.setTradeType(tempStr[k + 8].trim());
            wxPayBillBaseResult.setTradeState(tempStr[k + 9].trim());
            wxPayBillBaseResult.setBankType(tempStr[k + 10].trim());
            wxPayBillBaseResult.setFeeType(tempStr[k + 11].trim());
            wxPayBillBaseResult.setTotalFee(tempStr[k + 12].trim());
            wxPayBillBaseResult.setCouponFee(tempStr[k + 13].trim());
            wxPayBillBaseResult.setRefundId(tempStr[k + 14].trim());
            wxPayBillBaseResult.setOutRefundNo(tempStr[k + 15].trim());
            wxPayBillBaseResult.setSettlementRefundFee(tempStr[k + 16].trim());
            wxPayBillBaseResult.setCouponRefundFee(tempStr[k + 17].trim());
            wxPayBillBaseResult.setRefundChannel(tempStr[k + 18].trim());
            wxPayBillBaseResult.setRefundState(tempStr[k + 19].trim());
            wxPayBillBaseResult.setBody(tempStr[k + 20].trim());
            wxPayBillBaseResult.setAttach(tempStr[k + 21].trim());
            wxPayBillBaseResult.setPoundage(tempStr[k + 22].trim());
            wxPayBillBaseResult.setPoundageRate(tempStr[k + 23].trim());
            wxPayBillBaseResultLst.add(wxPayBillBaseResult);
            k += t.length;
        }
        wxPayBillResult.setWxPayBillBaseResultLst(wxPayBillBaseResultLst);
        String totalStr = objStr.replaceAll(",", " ");
        String[] totalTempStr = totalStr.split("`");
        wxPayBillResult.setTotalRecord(totalTempStr[1]);
        wxPayBillResult.setTotalFee(totalTempStr[2]);
        wxPayBillResult.setTotalRefundFee(totalTempStr[3]);
        wxPayBillResult.setTotalCouponFee(totalTempStr[4]);
        wxPayBillResult.setTotalPoundageFee(totalTempStr[5]);
        return wxPayBillResult;
    }

    public WxPayFundFlowResult downloadFundFlow(String billDate, String accountType, String tarType) throws WxPayException {
        WxPayDownloadFundFlowRequest request = new WxPayDownloadFundFlowRequest();
        request.setBillDate(billDate);
        request.setAccountType(accountType);
        request.setTarType(tarType);
        return this.downloadFundFlow(request);
    }

    public WxPayFundFlowResult downloadFundFlow(WxPayDownloadFundFlowRequest request) throws WxPayException {
        String responseContent;
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadfundflow";
        if ("GZIP".equals(request.getTarType())) {
            responseContent = this.handleGzipFundFlow(url, request.toXML());
        } else {
            responseContent = this.post(url, request.toXML(), true);
            if (responseContent.startsWith("<")) {
                throw WxPayException.from((BaseWxPayResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCommonResult.class));
            }
        }
        return this.handleFundFlow(responseContent);
    }

    private String handleGzipFundFlow(String url, String requestStr) throws WxPayException {
        try {
            byte[] responseBytes = this.postForBytes(url, requestStr, true);
            Path tempDirectory = Files.createTempDirectory("fundFlow", new FileAttribute[0]);
            Path path = Paths.get(tempDirectory.toString(), System.currentTimeMillis() + ".gzip");
            Files.write(path, responseBytes, new OpenOption[0]);
            try {
                List<String> allLines = Files.readAllLines(ZipUtil.ungzip((File)path.toFile()).toPath(), StandardCharsets.UTF_8);
                return Joiner.on((String)"\n").join(allLines);
            }
            catch (ZipException e) {
                if (e.getMessage().contains("Not in GZIP format")) {
                    throw WxPayException.from((BaseWxPayResult)BaseWxPayResult.fromXML((String)new String(responseBytes, StandardCharsets.UTF_8), WxPayCommonResult.class));
                }
                this.log.error("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519");
            }
        }
        catch (WxPayException wxPayException) {
            throw wxPayException;
        }
        catch (Exception e) {
            this.log.error("\u89e3\u6790\u5bf9\u8d26\u5355\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
            throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519");
        }
    }

    private WxPayFundFlowResult handleFundFlow(String responseContent) {
        WxPayFundFlowResult wxPayFundFlowResult = new WxPayFundFlowResult();
        String listStr = "";
        String objStr = "";
        if (StringUtils.isNotBlank((CharSequence)responseContent) && responseContent.contains("\u8d44\u91d1\u6d41\u6c34\u603b\u7b14\u6570")) {
            listStr = responseContent.substring(0, responseContent.indexOf("\u8d44\u91d1\u6d41\u6c34\u603b\u7b14\u6570"));
            objStr = responseContent.substring(responseContent.indexOf("\u8d44\u91d1\u6d41\u6c34\u603b\u7b14\u6570"));
        }
        LinkedList<WxPayFundFlowBaseResult> wxPayFundFlowBaseResultList = new LinkedList<WxPayFundFlowBaseResult>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayFundFlowBaseResult wxPayFundFlowBaseResult = new WxPayFundFlowBaseResult();
            wxPayFundFlowBaseResult.setBillingTime(tempStr[k].trim());
            wxPayFundFlowBaseResult.setBizTransactionId(tempStr[k + 1].trim());
            wxPayFundFlowBaseResult.setFundFlowId(tempStr[k + 2].trim());
            wxPayFundFlowBaseResult.setBizName(tempStr[k + 3].trim());
            wxPayFundFlowBaseResult.setBizType(tempStr[k + 4].trim());
            wxPayFundFlowBaseResult.setFinancialType(tempStr[k + 5].trim());
            wxPayFundFlowBaseResult.setFinancialFee(tempStr[k + 6].trim());
            wxPayFundFlowBaseResult.setAccountBalance(tempStr[k + 7].trim());
            wxPayFundFlowBaseResult.setFundApplicant(tempStr[k + 8].trim());
            wxPayFundFlowBaseResult.setMemo(tempStr[k + 9].trim());
            wxPayFundFlowBaseResult.setBizVoucherId(tempStr[k + 10].trim());
            wxPayFundFlowBaseResultList.add(wxPayFundFlowBaseResult);
            k += t.length;
        }
        wxPayFundFlowResult.setWxPayFundFlowBaseResultList(wxPayFundFlowBaseResultList);
        String totalStr = objStr.replaceAll(",", " ");
        String[] totalTempStr = totalStr.split("`");
        wxPayFundFlowResult.setTotalRecord(totalTempStr[1]);
        wxPayFundFlowResult.setIncomeRecord(totalTempStr[2]);
        wxPayFundFlowResult.setIncomeAmount(totalTempStr[3]);
        wxPayFundFlowResult.setExpenditureRecord(totalTempStr[4]);
        wxPayFundFlowResult.setExpenditureAmount(totalTempStr[5]);
        return wxPayFundFlowResult;
    }

    public WxPayMicropayResult micropay(WxPayMicropayRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/micropay";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayMicropayResult result = (WxPayMicropayResult)BaseWxPayResult.fromXML((String)responseContent, WxPayMicropayResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayOrderReverseResult reverseOrder(WxPayOrderReverseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/reverse";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayOrderReverseResult result = (WxPayOrderReverseResult)BaseWxPayResult.fromXML((String)responseContent, WxPayOrderReverseResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public String shorturl(WxPayShorturlRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/shorturl";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayShorturlResult result = (WxPayShorturlResult)BaseWxPayResult.fromXML((String)responseContent, WxPayShorturlResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result.getShortUrl();
    }

    public String shorturl(String longUrl) throws WxPayException {
        return this.shorturl(new WxPayShorturlRequest(longUrl));
    }

    public String authcode2Openid(WxPayAuthcode2OpenidRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/authcodetoopenid";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayAuthcode2OpenidResult result = (WxPayAuthcode2OpenidResult)BaseWxPayResult.fromXML((String)responseContent, WxPayAuthcode2OpenidResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result.getOpenid();
    }

    public String authcode2Openid(String authCode) throws WxPayException {
        return this.authcode2Openid(new WxPayAuthcode2OpenidRequest(authCode));
    }

    public String getSandboxSignKey() throws WxPayException {
        WxPayDefaultRequest request = new WxPayDefaultRequest();
        request.checkAndSign(this.getConfig());
        String url = "https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey";
        String responseContent = this.post(url, request.toXML(), false);
        WxPaySandboxSignKeyResult result = (WxPaySandboxSignKeyResult)BaseWxPayResult.fromXML((String)responseContent, WxPaySandboxSignKeyResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result.getSandboxSignKey();
    }

    public WxPayCouponSendResult sendCoupon(WxPayCouponSendRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/send_coupon";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayCouponSendResult result = (WxPayCouponSendResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCouponSendResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayCouponStockQueryResult queryCouponStock(WxPayCouponStockQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/query_coupon_stock";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCouponStockQueryResult result = (WxPayCouponStockQueryResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCouponStockQueryResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayCouponInfoQueryResult queryCouponInfo(WxPayCouponInfoQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/querycouponsinfo";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCouponInfoQueryResult result = (WxPayCouponInfoQueryResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCouponInfoQueryResult.class);
        result.checkResult((WxPayService)this, request.getSignType(), true);
        return result;
    }

    public WxPayApiData getWxApiData() {
        try {
            WxPayApiData wxPayApiData = (WxPayApiData)wxApiData.get();
            return wxPayApiData;
        }
        finally {
            wxApiData.remove();
        }
    }

    public String queryComment(Date beginDate, Date endDate, Integer offset, Integer limit) throws WxPayException {
        WxPayQueryCommentRequest request = new WxPayQueryCommentRequest();
        request.setBeginTime(WxPayConstants.QUERY_COMMENT_DATE_FORMAT.format(beginDate));
        request.setEndTime(WxPayConstants.QUERY_COMMENT_DATE_FORMAT.format(endDate));
        request.setOffset(offset);
        request.setLimit(limit);
        request.setSignType("HMAC-SHA256");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/billcommentsp/batchquerycomment";
        String responseContent = this.post(url, request.toXML(), true);
        if (responseContent.startsWith("<")) {
            throw WxPayException.from((BaseWxPayResult)BaseWxPayResult.fromXML((String)responseContent, WxPayCommonResult.class));
        }
        return responseContent;
    }
}

