/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.payment.wechat.service.impl;

import com.ebaiyihui.payment.wechat.bean.WxPayApiData;
import com.ebaiyihui.payment.wechat.exception.WxPayException;
import com.ebaiyihui.payment.wechat.service.impl.BaseWxPayServiceImpl;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.net.SSLSocketHttpConnectionProvider;
import jodd.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class WxPayServiceJoddHttpImpl
extends BaseWxPayServiceImpl {
    public byte[] postForBytes(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr, useKey);
            byte[] responseBytes = request.send().bodyBytes();
            String responseString = Base64.encodeToString((byte[])responseBytes);
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e(Base64\u7f16\u7801\u540e)\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            wxApiData.set(new WxPayApiData(url, requestStr, responseString, null));
            return responseBytes;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), (Throwable)e);
        }
    }

    public String post(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr, useKey);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            wxApiData.set(new WxPayApiData(url, requestStr, responseString, null));
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), (Throwable)e);
        }
    }

    private HttpRequest buildHttpRequest(String url, String requestStr, boolean useKey) throws WxPayException {
        HttpRequest request = (HttpRequest)HttpRequest.post((String)url).timeout(this.getConfig().getHttpTimeout()).connectionTimeout(this.getConfig().getHttpConnectionTimeout()).bodyText(requestStr);
        if (useKey) {
            SSLContext sslContext = this.getConfig().getSslContext();
            if (null == sslContext) {
                sslContext = this.getConfig().initSSLContext();
            }
            SSLSocketHttpConnectionProvider provider = new SSLSocketHttpConnectionProvider(sslContext);
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        return request;
    }

    private String getResponseString(HttpResponse response) throws WxPayException {
        try {
            this.log.debug("\u3010\u5fae\u4fe1\u670d\u52a1\u5668\u54cd\u5e94\u5934\u4fe1\u606f\u3011\uff1a\n{}", (Object)response.toString(false));
        }
        catch (NullPointerException e) {
            this.log.warn("HttpResponse.toString() \u5c45\u7136\u629b\u51fa\u7a7a\u6307\u9488\u5f02\u5e38\u4e86", (Throwable)e);
        }
        String responseString = response.bodyText();
        if (StringUtils.isBlank((CharSequence)responseString)) {
            throw new WxPayException("\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)response.charset())) {
            responseString = new String(responseString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return responseString;
    }
}

