/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.pushmsg.server.api.appmessage;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.pushmsg.common.model.SystemPushInfoEntity;
import com.ebaiyihui.pushmsg.common.model.UserDevicesRecordEntity;
import com.ebaiyihui.pushmsg.common.vo.SystemPushAddTagVo;
import com.ebaiyihui.pushmsg.common.vo.SystemPushToAllVo;
import com.ebaiyihui.pushmsg.server.common.Constants;
import com.ebaiyihui.pushmsg.server.enums.ReturnCodeEnum;
import com.ebaiyihui.pushmsg.server.enums.ServiceCodeEnum;
import com.ebaiyihui.pushmsg.server.model.NotyPushInputVo;
import com.ebaiyihui.pushmsg.server.service.AppPushService;
import com.ebaiyihui.pushmsg.server.utils.GeTuiPushUtils;
import com.ebaiyihui.pushmsg.server.utils.UUIDUtil;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/userdevices"})
@Api(tags={"\u63a8\u9001\u670d\u52a1"})
public class AppPushController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AppPushController.class);
    @Autowired
    private AppPushService appPushService;

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u8bbe\u5907\u4fe1\u606f")
    @PostMapping(value={"/save_userdevices_record"})
    public ResultInfo saveUserDevicesRecord(@RequestBody UserDevicesRecordEntity userDevicesRecord) {
        log.info("======app\u63a8\u9001\u5f00\u59cb\u7ed1\u5b9a======");
        int insert = this.appPushService.saveUserDevicesRecord(userDevicesRecord);
        if (insert != 0) {
            log.info("======\u66f4\u65b0\u7528\u6237\u8bbe\u5907\u6210\u529f======");
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="clientId\u8fde\u63a5\u6dfb\u52a0\u6807\u7b7e")
    @PostMapping(value={"/addtagtoclientid"})
    public ResultInfo addTagToClientId(@RequestBody SystemPushAddTagVo systemPushAddTag) {
        List<String> tagList = Arrays.asList(systemPushAddTag.getTagArr());
        IQueryResult iQueryResult = this.appPushService.addTagToClientId(systemPushAddTag.getClientId(), tagList);
        Map response = iQueryResult.getResponse();
        String result = (String)response.get("result");
        if ("Success".equalsIgnoreCase(result)) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237id\u63a8\u9001\u6d88\u606f")
    @PostMapping(value={"/pushmessagetosomeone"})
    public ResultInfo pushMessageToSomeone(@RequestBody SystemPushInfoEntity pushInfo) {
        log.info("======\u901a\u8fc7\u7528\u6237id\u63a8\u9001app\u6d88\u606f\u5f00\u59cb======");
        log.info("======\u5185\u5bb9:" + pushInfo.getUserId() + "===" + pushInfo.getContent() + "======");
        if (pushInfo.getUserType() == 2) {
            pushInfo.setUserType(Integer.valueOf(3));
        }
        pushInfo.setStatus(1);
        pushInfo.setPushType(Constants.PUSH_ONE);
        pushInfo.setIsRead(Constants.MSG_NOT_READ);
        pushInfo.setPushKey(UUIDUtil.getUUID());
        IPushResult iPushResult = this.appPushService.pushMessageToSomeone(pushInfo);
        if (iPushResult == null) {
            return this.returnFailure("\u63a8\u9001\u5931\u8d25");
        }
        Map response = iPushResult.getResponse();
        String result = (String)response.get("result");
        if ("ok".equals(result)) {
            log.info("======\u901a\u8fc7\u7528\u6237id\u63a8\u9001app\u6d88\u606f\u6210\u529f======");
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        log.error("======\u901a\u8fc7\u7528\u6237id\u63a8\u9001app\u6d88\u606f\u5931\u8d25======");
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u53d1\u9001\u7fa4\u63a8\u6d88\u606f")
    @PostMapping(value={"/pushmessagetoall"})
    public ResultInfo pushMessageToAll(@RequestBody SystemPushToAllVo pushInfo) {
        List<String> tagList = Arrays.asList(pushInfo.getTagArr());
        pushInfo.setStatus(1);
        pushInfo.setPushType(Constants.PUSH_ALL);
        IPushResult iPushResult = this.appPushService.pushMessageToAll(tagList, (SystemPushInfoEntity)pushInfo);
        Map response = iPushResult.getResponse();
        String result = (String)response.get("result");
        if ("ok".equalsIgnoreCase(result)) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u8bbe\u5907\u4fe1\u606f")
    @GetMapping(value={"/get_user_device"})
    public ResultInfo getUserDevice(@RequestParam(value="userId") Long userId, @RequestParam(value="userType") Integer userType) {
        UserDevicesRecordEntity userDevice = this.appPushService.getUserDevice(userId, userType);
        return this.returnSucceed((Object)userDevice, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u63a8\u9001app\u4e0b\u8f7d\u66f4\u65b0\u901a\u77e5")
    @PostMapping(value={"/push_app_update_message"})
    public ResultInfo pushMessageToApp(@RequestBody NotyPushInputVo notyPushInputVo) {
        IPushResult iPushResult = GeTuiPushUtils.PushToApp((NotyPushInputVo)notyPushInputVo);
        Map response = iPushResult.getResponse();
        String result = (String)response.get("result");
        if ("ok".equalsIgnoreCase(result)) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u63a8\u9001\u5217\u8868")
    @GetMapping(value={"/get_message_record_list"})
    public ResultInfo getMessageRecordList(@RequestParam(value="userId") Long userId, @RequestParam(value="userType") Integer userType, @RequestParam(value="pushType", required=false) String pushType, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="size", defaultValue="20") int size) {
        PageResult pageResult = this.appPushService.getMessageRecordList(userId, userType, pushType, page, size);
        return this.returnSucceed((Object)pageResult, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u6d88\u606f\u5927\u7c7b\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    @GetMapping(value={"/get_message_unread"})
    public ResultInfo getMessageUnreadNum(@RequestParam(value="userId") Long userId, @RequestParam(value="userType") Integer userType, @RequestParam(value="pushType", required=false) String pushType) {
        Long count = this.appPushService.getMessageUnreadNum(userId, userType, pushType);
        return this.returnSucceed((Object)count, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u6d88\u606f\u4e3a\u5df2\u8bfb")
    @PostMapping(value={"/update_message_isread"})
    public ResultInfo batchUpdateMessageIsRead(@RequestParam(value="userId") Long userId, @RequestParam(value="userType") Integer userType, @RequestParam(value="pushType", required=false) String pushType) {
        try {
            this.appPushService.batchUpdateMessageIsRead(userId, userType, pushType);
        }
        catch (RuntimeException e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u66f4\u65b0\u5355\u6761\u6d88\u606f\u4e3a\u5df2\u8bfb")
    @PostMapping(value={"/update_message_is_read"})
    public ResultInfo updateMessageIsRead(@RequestParam(value="pushKey") String pushKey) {
        int update = this.appPushService.updateMessageIsRead(pushKey);
        if (update == ServiceCodeEnum.OPERATE_SUCCESS.getValue()) {
            return this.returnSucceed(ServiceCodeEnum.OPERATE_SUCCESS.getDisplay());
        }
        return this.returnFailure(ServiceCodeEnum.OPERATE_FAILURE.getDisplay());
    }

    @ApiOperation(value="\u5355\u6761\u5220\u9664\u6d88\u606f")
    @PostMapping(value={"/delete_push_message"})
    public ResultInfo deletePushMessage(@RequestParam(value="pushKey") String pushKey) {
        int delete = this.appPushService.deletePushMessage(pushKey);
        if (delete == ServiceCodeEnum.OPERATE_SUCCESS.getValue()) {
            return this.returnSucceed(ServiceCodeEnum.OPERATE_SUCCESS.getDisplay());
        }
        return this.returnFailure(ServiceCodeEnum.OPERATE_FAILURE.getDisplay());
    }

    @ApiOperation(value="\u533b\u751fweb\u7aef\u83b7\u53d6\u901a\u77e5\u96c6\u5408")
    @GetMapping(value={"/get_push_message_list"})
    public ResultInfo getPushMessageList(@RequestParam(value="userId") Long userId, @RequestParam(value="userType") Integer userType, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="start", required=false) String start, @RequestParam(value="end", required=false) String end) {
        LocalDate startTime = null;
        LocalDate endTime = null;
        if (start != null) {
            startTime = LocalDate.parse(start);
        }
        if (end != null) {
            endTime = LocalDate.parse(end);
        }
        PageResult pageResult = this.appPushService.getPushMessageList(userId, userType, startTime, endTime, page, size);
        return this.returnSucceed((Object)pageResult, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u672a\u8bfb\u6d88\u606f\u5217\u8868")
    @GetMapping(value={"/get_unread_message_all"})
    public ResultInfo getUnreadMessageAll(@RequestParam(value="userId") Long userId, @RequestParam(value="userType") Integer userType) {
        List messageList = this.appPushService.getUnreadMessageAll(userId, userType);
        return this.returnSucceed((Object)messageList, ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

