/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.pushmsg.server.api.shortmessage;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.pushmsg.server.service.SendMessageService;
import com.ebaiyihui.pushmsg.server.utils.AliSmsTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e13\u5bb6\u4fe1\u606f\u901a\u77e5\u63a5\u53e3"})
@RequestMapping(value={"/api/v1/expert_msg"})
public class SendExpertMsgController {
    private static final Logger log = LoggerFactory.getLogger(SendExpertMsgController.class);
    @Autowired
    private SendMessageService sendMessageService;

    @ApiOperation(value="\u65b0\u89c6\u9891\u4f1a\u8bca\u63a5\u8bca\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/video_consultation_apply"})
    public ResultInfo videoConsultationApplyToExpert(@RequestParam(value="phoneNumbers") String phoneNumbers) {
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.videoConsultationApplyToExpert);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.videoConsultationApplyToExpert, "");
    }

    @ApiOperation(value="\u65b0\u56fe\u6587\u4f1a\u8bca\u63a5\u8bca\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/photo_consultation_apply"})
    public ResultInfo photoConsultationApplyToExpert(@RequestParam(value="phoneNumbers") String phoneNumbers) {
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.photoConsultationApplyToExpert);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.photoConsultationApplyToExpert, "");
    }

    @ApiOperation(value="\u4f1a\u8bca\u8f6c\u51fa\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/consultation_out"})
    public ResultInfo consultationOutMsgToExpert(@RequestParam(value="phoneNumbers") String phoneNumbers, @RequestParam(value="doctorName") String doctorName) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("doctorname", doctorName);
        String templateParam = JSON.toJSONString(map);
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.consultationOutMsgToExpert + "==" + templateParam);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.consultationOutMsgToExpert, templateParam);
    }

    @ApiOperation(value="\u89c6\u9891\u4f1a\u8bca\u5f00\u59cb\u524d\u4e00\u5c0f\u65f6\u63d0\u9192\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/consultation_start_expert"})
    public ResultInfo consultationStartMsgToExpert(@RequestParam(value="phoneNumbers") String phoneNumbers, @RequestParam(value="doctorName") String doctorName, @RequestParam(value="patientName") String patientName) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("patientname", patientName);
        map.put("doctorname", doctorName);
        String templateParam = JSON.toJSONString(map);
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.consultationStartMsgToExpert + "==" + templateParam);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.consultationStartMsgToExpert, templateParam);
    }

    @ApiOperation(value="\u89c6\u9891\u4f1a\u8bca\u5f00\u59cb\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/consultation_started_expert"})
    public ResultInfo consultationStartedMsgToExpert(@RequestParam(value="phoneNumbers") String phoneNumbers, @RequestParam(value="doctorName") String doctorName, @RequestParam(value="patientName") String patientName) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("patientname", patientName);
        map.put("doctorname", doctorName);
        String templateParam = JSON.toJSONString(map);
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.consultationStartedMsgToExpert + "==" + templateParam);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.consultationStartedMsgToExpert, templateParam);
    }

    @ApiOperation(value="\u89c6\u9891\u4f1a\u8bca\u5206\u914d\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/video_consultation_from_admin"})
    public ResultInfo videoConsultationFromAdminMsgToReport(@RequestParam(value="phoneNumbers") String phoneNumbers) {
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.videoConsultationFromAdminMsgToReport);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.videoConsultationFromAdminMsgToReport, "");
    }

    @ApiOperation(value="\u56fe\u6587\u4f1a\u8bca\u5206\u914d\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/photo_consultation_from_admin"})
    public ResultInfo photoConsultationFromAdminMsgToReport(@RequestParam(value="phoneNumbers") String phoneNumbers) {
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.photoConsultationFromAdminMsgToReport);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.photoConsultationFromAdminMsgToReport, "");
    }

    @ApiOperation(value="\u63d0\u9192\u63d0\u4ea4\u62a5\u544a\u901a\u77e5(\u4e13\u5bb6)")
    @PostMapping(value={"/remind_submit_report"})
    public ResultInfo remindExpertSubmitReportMsg(@RequestParam(value="phoneNumbers") String phoneNumbers, @RequestParam(value="patientName") String patientName, @RequestParam(value="doctorName") String doctorName) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("patientname", patientName);
        map.put("doctorname", doctorName);
        String templateParam = JSON.toJSONString(map);
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.remindExpertSubmitReportMsg + "==" + templateParam);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.remindExpertSubmitReportMsg, templateParam);
    }

    @ApiOperation(value="\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u4e0d\u901a\u8fc7(\u4e13\u5bb6)")
    @PostMapping(value={"/expert_report_refused"})
    public ResultInfo expertConsultationReportRefused(@RequestParam(value="phoneNumbers") String phoneNumbers, @RequestParam(value="reason") String reason) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("reason", reason);
        String templateParam = JSON.toJSONString(map);
        log.info("===\u77ed\u4fe1\u8be6\u60c5:" + phoneNumbers + "==" + AliSmsTemplate.expertConsultationReportRefused + "==" + templateParam);
        return this.sendMessageService.sendMessage(phoneNumbers, AliSmsTemplate.expertConsultationReportRefused, templateParam);
    }
}

