/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.pushmsg.server.service.impl;

import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.enums.PushCodeEnum;
import com.ebaiyihui.framework.enums.PushTypeEnum;
import com.ebaiyihui.pushmsg.common.model.SystemPushInfoEntity;
import com.ebaiyihui.pushmsg.common.model.UserDevicesRecordEntity;
import com.ebaiyihui.pushmsg.server.common.Constants;
import com.ebaiyihui.pushmsg.server.dao.SystemPushInfoMapper;
import com.ebaiyihui.pushmsg.server.dao.UserDevicesRecordMapper;
import com.ebaiyihui.pushmsg.server.model.PushTemplate;
import com.ebaiyihui.pushmsg.server.service.AppPushService;
import com.ebaiyihui.pushmsg.server.utils.GeTuiPushUtils;
import com.ebaiyihui.pushmsg.server.utils.UUIDUtil;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppPushServiceImpl
implements AppPushService {
    private static final Logger log = LoggerFactory.getLogger(AppPushServiceImpl.class);
    @Autowired
    private UserDevicesRecordMapper userDevicesRecordMapper;
    @Autowired
    private SystemPushInfoMapper systemPushInfoMapper;
    @Value(value="${app-push.enable}")
    private boolean appPushSwitch;

    public int saveUserDevicesRecord(UserDevicesRecordEntity userDevicesRecord) {
        UserDevicesRecordEntity userDevices = this.userDevicesRecordMapper.getUserDeviceByCid(userDevicesRecord.getClientId(), Integer.valueOf(1));
        if (userDevices != null) {
            userDevicesRecord.setLastLoginTime(new Date());
            userDevicesRecord.setId(userDevices.getId());
            return this.userDevicesRecordMapper.updateByPrimaryKeySelective(userDevicesRecord);
        }
        userDevicesRecord.setStatus(1);
        return this.userDevicesRecordMapper.insertSelective(userDevicesRecord);
    }

    public IQueryResult addTagToClientId(String clientId, List<String> tagList) {
        return GeTuiPushUtils.setTagToClientId((String)clientId, tagList);
    }

    public IPushResult pushMessageToOne(String clientId, String platform, SystemPushInfoEntity pushInfo) {
        IPushResult iPushResult = GeTuiPushUtils.pushToOne((String)clientId, (String)platform, (SystemPushInfoEntity)pushInfo);
        Map response = iPushResult.getResponse();
        pushInfo.setPushState(Integer.valueOf("ok".equals((String)response.get("result")) ? 1 : -1));
        this.systemPushInfoMapper.insertSelective(pushInfo);
        return iPushResult;
    }

    public IPushResult pushMessageToAll(List<String> tagList, SystemPushInfoEntity pushInfo) {
        IPushResult iPushResult = GeTuiPushUtils.pushToAll(tagList, (SystemPushInfoEntity)pushInfo);
        Map response = iPushResult.getResponse();
        pushInfo.setPushState(Integer.valueOf("ok".equals((String)response.get("result")) ? 1 : -1));
        pushInfo.setRemark(tagList.toString());
        SystemPushInfoEntity systemPushInfo = new SystemPushInfoEntity();
        BeanUtils.copyProperties((Object)pushInfo, (Object)systemPushInfo);
        int i = this.systemPushInfoMapper.insertSelective(systemPushInfo);
        if (i == 0) {
            log.error("=====\u7fa4\u4f53\u63a8\u9001\u6d88\u606f\u5b58\u5e93\u5931\u8d25=====");
        }
        return iPushResult;
    }

    public UserDevicesRecordEntity getUserDevice(Long userId, Integer userType) {
        return this.userDevicesRecordMapper.getUserDeviceByUserId(userId, userType);
    }

    public IPushResult pushMessageToSomeone(SystemPushInfoEntity pushInfo) {
        try {
            if (!this.appPushSwitch) {
                log.info("=====\u5f53\u524d\u73af\u5883\u63a8\u9001\u529f\u80fd\u5173\u95ed=====");
                return null;
            }
            UserDevicesRecordEntity userDevice = this.userDevicesRecordMapper.getUserDeviceByUserId(pushInfo.getUserId(), pushInfo.getUserType());
            if (userDevice == null) {
                log.error("=====\u7528\u6237" + pushInfo.getUserId() + "\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b58\u5728=====");
                return null;
            }
            IPushResult iPushResult = GeTuiPushUtils.pushToOne((String)userDevice.getClientId(), (String)userDevice.getPlatform(), (SystemPushInfoEntity)pushInfo);
            if (pushInfo.getBusinessType() != null && pushInfo.getBusinessType().intValue() != PushTypeEnum.NEW_NOTICE.getValue().intValue()) {
                Map response = iPushResult.getResponse();
                pushInfo.setPushState(Integer.valueOf("ok".equalsIgnoreCase((String)response.get("result")) ? 1 : -1));
                pushInfo.setType(Constants.APP_PUSH_TYPE);
                pushInfo.setRemark(response.get("status") + "|" + response.get("taskId"));
                int i = this.systemPushInfoMapper.insertSelective(pushInfo);
                if (i == 0) {
                    log.error("=====\u5355\u72ec\u63a8\u9001\u6d88\u606f\u5b58\u5e93\u5931\u8d25=====");
                }
            }
            return iPushResult;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public PageResult<PushTemplate> getMessageRecordList(Long userId, Integer userType, String pushType, int pageNum, int size) {
        PageHelper.startPage((int)pageNum, (int)size);
        Page page = this.systemPushInfoMapper.getMessageRecordList(userId, userType, pushType, Integer.valueOf(1), Constants.APP_PUSH_TYPE);
        for (PushTemplate pushTemplate : page.getResult()) {
            pushTemplate.setTitle(PushCodeEnum.getByValue((Integer)pushTemplate.getPushCode()).getDisplay());
        }
        return new PageResult((Object)page.getResult(), page.getTotal());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void batchUpdateMessageIsRead(Long userId, Integer userType, String pushType) {
        this.systemPushInfoMapper.batchUpdateMessageIsRead(userId, userType, pushType, Constants.MSG_IS_READ, Integer.valueOf(1), Constants.APP_PUSH_TYPE);
    }

    public int updateMessageIsRead(String pushKey) {
        return this.systemPushInfoMapper.updateMessageIsRead(pushKey, Constants.MSG_IS_READ);
    }

    public int deletePushMessage(String pushKey) {
        return this.systemPushInfoMapper.deletePushMessage(pushKey, Integer.valueOf(-1));
    }

    public PageResult<PushTemplate> getPushMessageList(Long userId, Integer userType, LocalDate startTime, LocalDate endTime, int pageNum, int size) {
        PageHelper.startPage((int)pageNum, (int)size);
        Page page = this.systemPushInfoMapper.getPushMessageList(userId, userType, startTime, endTime, Constants.WEB_PUSH_TYPE);
        for (PushTemplate pushTemplate : page.getResult()) {
            pushTemplate.setTitle(PushCodeEnum.getByValue((Integer)pushTemplate.getPushCode()).getDisplay());
        }
        return new PageResult((Object)page.getResult(), page.getTotal());
    }

    public Long getMessageUnreadNum(Long userId, Integer userType, String pushType) {
        return this.systemPushInfoMapper.getMessageUnreadNum(userId, userType, pushType, Constants.MSG_NOT_READ, Integer.valueOf(1), Constants.APP_PUSH_TYPE);
    }

    public List<PushTemplate> getUnreadMessageAll(Long userId, Integer userType) {
        return this.systemPushInfoMapper.getUnreadMessageAll(userId, userType, Constants.MSG_NOT_READ, 1, Constants.APP_PUSH_TYPE);
    }

    @RabbitListener(queues={"queue_app_push_message"})
    public void pushMessageListener(SystemPushInfoEntity pushInfo) {
        try {
            if (!this.appPushSwitch) {
                log.info("=====\u5f53\u524d\u73af\u5883\u63a8\u9001\u529f\u80fd\u5173\u95ed=====");
                return;
            }
            if (pushInfo.getUserType() == 2) {
                pushInfo.setUserType(Integer.valueOf(3));
            }
            pushInfo.setStatus(1);
            pushInfo.setPushType(Constants.PUSH_ONE);
            pushInfo.setIsRead(Constants.MSG_NOT_READ);
            pushInfo.setPushKey(UUIDUtil.getUUID());
            UserDevicesRecordEntity userDevice = this.userDevicesRecordMapper.getUserDeviceByUserId(pushInfo.getUserId(), pushInfo.getUserType());
            if (userDevice == null) {
                log.error("=====\u7528\u6237" + pushInfo.getUserId() + "\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b58\u5728=====");
                return;
            }
            IPushResult iPushResult = GeTuiPushUtils.pushToOne((String)userDevice.getClientId(), (String)userDevice.getPlatform(), (SystemPushInfoEntity)pushInfo);
            if (pushInfo.getBusinessType() != null && pushInfo.getBusinessType().intValue() != PushTypeEnum.NEW_NOTICE.getValue().intValue()) {
                Map response = iPushResult.getResponse();
                pushInfo.setPushState(Integer.valueOf("ok".equalsIgnoreCase((String)response.get("result")) ? 1 : -1));
                pushInfo.setType(Constants.APP_PUSH_TYPE);
                pushInfo.setRemark(response.get("status") + "|" + response.get("taskId"));
                int i = this.systemPushInfoMapper.insertSelective(pushInfo);
                if (i == 0) {
                    log.info("=====\u5355\u72ec\u63a8\u9001\u6d88\u606f\u5b58\u5e93\u5931\u8d25=====");
                }
            }
            return;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
    }
}

