/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.pushmsg.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.pushmsg.common.model.MessageRecordEntity;
import com.ebaiyihui.pushmsg.server.common.Constants;
import com.ebaiyihui.pushmsg.server.dao.MessageRecordMapper;
import com.ebaiyihui.pushmsg.server.enums.ServiceCodeEnum;
import com.ebaiyihui.pushmsg.server.service.SendMessageService;
import com.ebaiyihui.pushmsg.server.utils.AliSmsTemplate;
import com.ebaiyihui.pushmsg.server.utils.AliSmsUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SendMessageServiceImpl
implements SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);
    @Autowired
    private MessageRecordMapper messageRecordMapper;
    @Value(value="${short-message.enable}")
    private boolean ShortMessageSwitch;

    public ResultInfo sendMessage(String phoneNumbers, String templateCode, String templateParam) {
        try {
            log.info("======\u77ed\u4fe1\u5f00\u5173:" + this.ShortMessageSwitch + "======");
            if (!this.ShortMessageSwitch && templateCode.equals(AliSmsTemplate.loginValidateCodeMsg)) {
                this.ShortMessageSwitch = true;
            }
            if (!this.ShortMessageSwitch && templateCode.equals(AliSmsTemplate.registerValidateCodeMsg)) {
                this.ShortMessageSwitch = true;
            }
            if (!this.ShortMessageSwitch) {
                log.info("=====\u5f53\u524d\u73af\u5883\u77ed\u4fe1\u529f\u80fd\u5173\u95ed=====");
                return new ResultInfo(ServiceCodeEnum.OPERATE_SUCCESS.getValue().intValue(), ServiceCodeEnum.OPERATE_SUCCESS.getDisplay(), (Object)"");
            }
            SendSmsResponse sendSmsResponse = AliSmsUtil.sendSmsAli((String)phoneNumbers, (String)templateCode, (String)templateParam);
            if (sendSmsResponse != null) {
                String[] phoneNumber;
                ArrayList<MessageRecordEntity> messageList = new ArrayList<MessageRecordEntity>();
                for (String phoneNum : phoneNumber = phoneNumbers.split(",")) {
                    MessageRecordEntity messageRecord = new MessageRecordEntity();
                    messageRecord.setReceivePhone(phoneNum);
                    messageRecord.setBizId(sendSmsResponse.getBizId());
                    messageRecord.setTemplateCode(templateCode);
                    messageRecord.setStatus("OK".equals(sendSmsResponse.getCode()) ? 1 : -1);
                    messageRecord.setContent(templateParam);
                    messageList.add(messageRecord);
                }
                if (messageList.size() > 0) {
                    int batch = this.messageRecordMapper.batchInsertMessage(messageList);
                    log.info("======\u77ed\u4fe1\u8bb0\u5f55\u5b58\u5e93:" + batch + "\u6761======");
                }
                if ("OK".equalsIgnoreCase(sendSmsResponse.getCode())) {
                    return new ResultInfo(ServiceCodeEnum.OPERATE_SUCCESS.getValue().intValue(), ServiceCodeEnum.OPERATE_SUCCESS.getDisplay(), (Object)"");
                }
                if ("isv.BUSINESS_LIMIT_CONTROL".equalsIgnoreCase(sendSmsResponse.getCode())) {
                    return new ResultInfo(ServiceCodeEnum.OPERATE_FAILURE.getValue().intValue(), "\u53d1\u9001\u592a\u8fc7\u9891\u7e41,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object)"");
                }
                return new ResultInfo(ServiceCodeEnum.OPERATE_FAILURE.getValue().intValue(), ServiceCodeEnum.OPERATE_FAILURE.getDisplay(), (Object)"");
            }
            return new ResultInfo(ServiceCodeEnum.OPERATE_FAILURE.getValue().intValue(), ServiceCodeEnum.OPERATE_FAILURE.getDisplay(), (Object)"");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ResultInfo(ServiceCodeEnum.OPERATE_FAILURE.getValue().intValue(), ServiceCodeEnum.OPERATE_FAILURE.getDisplay(), (Object)"");
        }
    }

    public PageResult<MessageRecordEntity> getShortMessageList(int pageNum, int size, String searchParam, LocalDate startTime, LocalDate endTime) {
        PageHelper.startPage((int)pageNum, (int)size);
        Page page = this.messageRecordMapper.getShortMessageList(searchParam, startTime, endTime, Constants.VALIDATE_MSG);
        for (MessageRecordEntity messageRecord : page.getResult()) {
            String content = messageRecord.getContent();
            if (content == null || content.equals("")) continue;
            HashMap hashMap = (HashMap)JSON.parseObject((String)content, HashMap.class);
            messageRecord.setContent((String)hashMap.get("code"));
        }
        return new PageResult((Object)page.getResult(), page.getTotal());
    }
}

