/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.pushmsg.server.utils;

import com.ebaiyihui.framework.enums.PushCodeEnum;
import com.ebaiyihui.framework.enums.PushTypeEnum;
import com.ebaiyihui.pushmsg.common.model.SystemPushInfoEntity;
import com.ebaiyihui.pushmsg.server.model.GeTuiConfigure;
import com.ebaiyihui.pushmsg.server.model.NotyPushInputVo;
import com.ebaiyihui.pushmsg.server.model.PushTemplate;
import com.gexin.fastjson.JSON;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.base.uitls.AppConditions;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.NotyPopLoadTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class GeTuiPushUtils {
    private static final Logger log = LoggerFactory.getLogger(GeTuiPushUtils.class);
    private static String Host = "http://sdk.open.api.igexin.com/apiex.htm";
    private static String appId;
    private static String appKey;
    private static String masterSecret;

    @Value(value="${geTui.appId}")
    public void setAppId(String appId) {
        GeTuiPushUtils.appId = appId;
    }

    @Value(value="${geTui.appKey}")
    public void setAppKey(String appKey) {
        GeTuiPushUtils.appKey = appKey;
    }

    @Value(value="${geTui.masterSecret}")
    public void setMasterSecret(String masterSecret) {
        GeTuiPushUtils.masterSecret = masterSecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPushResult pushToOne(String clientId, String platform, SystemPushInfoEntity pushInfo) {
        if (null == pushInfo) {
            return null;
        }
        GeTuiConfigure configure = new GeTuiConfigure(appId, appKey, masterSecret);
        PushTemplate pushTemplate = GeTuiPushUtils.createPushMessage((SystemPushInfoEntity)pushInfo);
        IGtPush push = new IGtPush(Host, configure.getAppKey(), configure.getMasterSecret());
        Boolean isSilent = "Android".equalsIgnoreCase(platform);
        SingleMessage message = new SingleMessage();
        message.setOffline(true);
        if (PushCodeEnum.LOGOUT.getValue().equals(pushInfo.getPushCode())) {
            message.setOfflineExpireTime(1000L);
        } else {
            message.setOfflineExpireTime(172800000L);
        }
        message.setData((ITemplate)GeTuiPushUtils.getTransmissionTemplate((String)configure.getAppId(), (String)configure.getAppKey(), (String)JSON.toJSONString((Object)pushTemplate), (String)pushInfo.getContent(), (Boolean)isSilent));
        message.setPushNetWorkType(0);
        Target target = new Target();
        target.setAppId(configure.getAppId());
        target.setClientId(clientId);
        target.setAlias("WenZhenId");
        IPushResult ret = null;
        try {
            ret = push.pushMessageToSingle(message, target);
        }
        catch (RequestException e) {
            log.error("\u53d1\u9001\u4e2a\u63a8\u6d88\u606f\u5931\u8d25,\u91cd\u65b0\u53d1\u9001", (Throwable)e);
            ret = push.pushMessageToSingle(message, target, e.getRequestId());
        }
        finally {
            if (null != ret) {
                log.info("====PushMessage:====" + ret.getResponse().toString());
            } else {
                log.info("\u53d1\u9001\u4e2a\u63a8\u6d88\u606f\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
            }
        }
        return ret;
    }

    private static TransmissionTemplate getTransmissionTemplate(String appId, String appKey, String obj, String alertMsg, Boolean isSilent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setTransmissionContent(obj);
        template.setTransmissionType(2);
        if (!isSilent.booleanValue()) {
            APNPayload payload = new APNPayload();
            payload.setContentAvailable(1);
            payload.setCategory("$\u7531\u5ba2\u6237\u7aef\u5b9a\u4e49");
            PushTemplate pushTemplate = (PushTemplate)JSON.parseObject((String)obj, PushTemplate.class);
            Integer businessType = pushTemplate.getBusinessType();
            if (businessType != null && businessType.intValue() != PushTypeEnum.DELETE_FRIEND.getValue().intValue()) {
                payload.setSound("default");
                payload.setAlertMsg((APNPayload.AlertMsg)new APNPayload.SimpleAlertMsg(alertMsg));
            }
            payload.addCustomMsg("info", (Object)obj);
            payload.setAutoBadge("0");
            template.setAPNInfo((Payload)payload);
        }
        return template;
    }

    public static NotyPopLoadTemplate getNotyPopLoadTemplate(String appId, String appKey, NotyPushInputVo notyPushInputVo) {
        NotyPopLoadTemplate template = new NotyPopLoadTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        Style0 style = new Style0();
        style.setTitle(notyPushInputVo.getTitle());
        style.setText(notyPushInputVo.getText());
        style.setLogo("icon.png");
        style.setLogoUrl("");
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        template.setPopTitle(notyPushInputVo.getPopTitle());
        template.setPopContent(notyPushInputVo.getPopContent());
        template.setPopImage("");
        template.setPopButton1("\u4e0b\u8f7d");
        template.setPopButton2("\u53d6\u6d88");
        template.setLoadTitle(notyPushInputVo.getLoadTitle());
        template.setLoadIcon("file://icon.png");
        template.setLoadUrl(notyPushInputVo.getLoadUrl());
        template.setAutoInstall(true);
        try {
            template.setDuration(notyPushInputVo.getStartTime(), notyPushInputVo.getEndTime());
        }
        catch (Exception e) {
            log.error("====\u5c55\u793a\u65f6\u95f4\u8bbe\u7f6e\u5931\u8d25====");
        }
        return template;
    }

    public static IPushResult pushToAll(List<String> tagList, SystemPushInfoEntity pushInfo) {
        GeTuiConfigure configure = new GeTuiConfigure(appId, appKey, masterSecret);
        PushTemplate pushTemplate = GeTuiPushUtils.createPushMessage((SystemPushInfoEntity)pushInfo);
        IGtPush push = new IGtPush(Host, configure.getAppKey(), configure.getMasterSecret());
        TransmissionTemplate template = GeTuiPushUtils.getTransmissionTemplate((String)configure.getAppId(), (String)configure.getAppKey(), (String)configure.getMasterSecret(), (String)JSON.toJSONString((Object)pushTemplate), (Boolean)false);
        AppMessage message = new AppMessage();
        message.setData((ITemplate)template);
        message.setOffline(true);
        message.setOfflineExpireTime(86400000L);
        AppConditions cdt = new AppConditions();
        ArrayList<String> appIdList = new ArrayList<String>();
        appIdList.add(configure.getAppId());
        cdt.addCondition("tag", tagList);
        message.setAppIdList(appIdList);
        message.setConditions(cdt);
        IPushResult iPushResult = push.pushMessageToApp(message);
        return iPushResult;
    }

    public static IQueryResult setTagToClientId(String clientId, List<String> tagList) {
        if (tagList != null && tagList.size() == 0) {
            return null;
        }
        GeTuiConfigure configure = new GeTuiConfigure(appId, appKey, masterSecret);
        IGtPush push = new IGtPush(Host, configure.getAppKey(), configure.getMasterSecret());
        return push.setClientTag(configure.getAppId(), clientId, tagList);
    }

    public static void main(String[] args) {
        ArrayList<String> tagList = new ArrayList<String>();
        tagList.add("\u6d4b\u8bd5\u6807\u7b7e");
        IQueryResult iQueryResult = GeTuiPushUtils.setTagToClientId((String)"123456", tagList);
        System.out.println(iQueryResult.getResponse().toString());
    }

    public static PushTemplate createPushMessage(SystemPushInfoEntity pushInfo) {
        PushTemplate pushTemplate = new PushTemplate();
        pushTemplate.setPushKey(pushInfo.getPushKey());
        pushTemplate.setPushCode(pushInfo.getPushCode());
        pushTemplate.setBusinessKey(pushInfo.getBusinessKey());
        pushTemplate.setBusinessType(pushInfo.getBusinessType());
        pushTemplate.setBusinessExtend(pushInfo.getBusinessExtend());
        pushTemplate.setContent(pushInfo.getContent());
        pushTemplate.setCreateTime(pushInfo.getCreateTime());
        if (pushInfo.getTitle() == null && pushInfo.getPushCode() != null) {
            try {
                pushTemplate.setTitle(PushCodeEnum.getByValue((Integer)pushInfo.getPushCode()).getDisplay());
            }
            catch (Exception e) {
                log.error("======\u7ffb\u8bd1\u63a8\u9001\u679a\u4e3etitle\u5931\u8d25======");
            }
        } else {
            pushTemplate.setTitle(pushInfo.getTitle());
        }
        return pushTemplate;
    }

    public static IPushResult PushToApp(NotyPushInputVo notyPushInputVo) {
        IGtPush push = new IGtPush(Host, appKey, masterSecret);
        NotyPopLoadTemplate notyPopLoadTemplate = GeTuiPushUtils.getNotyPopLoadTemplate((String)appId, (String)appKey, (NotyPushInputVo)notyPushInputVo);
        AppMessage message = new AppMessage();
        message.setData((ITemplate)notyPopLoadTemplate);
        message.setOffline(true);
        message.setOfflineExpireTime(86400000L);
        AppConditions cdt = new AppConditions();
        ArrayList<String> appIdList = new ArrayList<String>();
        appIdList.add(appId);
        message.setAppIdList(appIdList);
        return push.pushMessageToApp(message);
    }
}

