/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.QueryMedicalRecordDto;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.RegisteredRecordReqVo;
import com.ebaiyihui.his.pojo.vo.card.RegisteredRecordResVo;
import com.ebaiyihui.his.pojo.vo.medicalVisit.InvoiceRespVo;
import com.ebaiyihui.his.pojo.vo.medicalVisit.MoreVisitRegisterReqQo;
import com.ebaiyihui.his.pojo.vo.medicalVisit.MoreVisitRegisterSubQo;
import com.ebaiyihui.his.pojo.vo.medicalVisit.RefundReqQo;
import com.ebaiyihui.his.pojo.vo.medicalVisit.RegisterAndPayReqQo;
import com.ebaiyihui.his.pojo.vo.medicalVisit.RegisterAndPayRespVo;
import com.ebaiyihui.his.pojo.vo.outPatient.OutPatientDetailReqQo;
import com.ebaiyihui.his.pojo.vo.outPatient.OutPatientRefundReqQo;
import com.ebaiyihui.his.service.IMoreVisitService;
import com.ebaiyihui.his.service.IMoreVisitServiceImpl;
import com.ebaiyihui.his.utils.DateUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMoreVisitServiceImpl
implements IMoreVisitService {
    private static final Logger log = LoggerFactory.getLogger(IMoreVisitServiceImpl.class);
    @Autowired
    NodeConfig nodeConfig;
    private static final String ADM_TYPE = "O";
    private static final String FIVE = "5";
    private static final String ZERO_THREE = "03";
    private static final String PRE = "PRE";
    private static final String DATA = "Data";

    public FrontResponse<RegisterAndPayRespVo> registerInfo(FrontRequest<RegisterAndPayReqQo> param) {
        log.info("\u590d\u8bca\u6302\u53f7\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        try {
            QuickResigisterInvoke quickResigisterInvoke = new QuickResigisterInvoke(this, param).invoke();
            if (quickResigisterInvoke.is()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5feb\u901f\u6302\u53f7\u5f02\u5e38");
            }
            SaveMedicalAdviceInvoke saveMedicalAdviceInvoke = new SaveMedicalAdviceInvoke(this, param, quickResigisterInvoke).invoke();
            if (saveMedicalAdviceInvoke.is()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u533b\u5631\u4fdd\u5b58\u5f02\u5e38");
            }
            FrontResponse response = this.outPatientPayNotify(param, quickResigisterInvoke, saveMedicalAdviceInvoke);
            if (response != null) {
                return response;
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
        }
        catch (Exception e) {
            log.info("\u590d\u8bca\u6302\u53f7\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u590d\u8bca\u6302\u53f7\u5f02\u5e38");
        }
    }

    private FrontResponse<RegisterAndPayRespVo> outPatientPayNotify(FrontRequest<RegisterAndPayReqQo> param, QuickResigisterInvoke quickResigisterInvoke, SaveMedicalAdviceInvoke saveMedicalAdviceInvoke) {
        JSONObject jsonObject;
        CallHisOutPatientDetail callHisOutPatientDetail = new CallHisOutPatientDetail(this, param, saveMedicalAdviceInvoke).invoke();
        if (callHisOutPatientDetail.is()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u95e8\u8bca\u7f34\u8d39\u660e\u7ec6\u63a5\u53e3\u5f02\u5e38");
        }
        String oeOrdItemID = callHisOutPatientDetail.getOeOrdItemID();
        OutPatientDetailReqQo outPatientDetailReqQo = callHisOutPatientDetail.getOutPatientDetailReqQo();
        CallHisOutPatient callHisOutPatient = new CallHisOutPatient(this, param, outPatientDetailReqQo, jsonObject = callHisOutPatientDetail.getJsonObject()).invoke();
        if (callHisOutPatient.is()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u95e8\u8bca\u7f34\u8d39\u63a5\u53e3\u5f02\u5e38");
        }
        RegisterAndPayRespVo registerAndPayRespVo = this.getRegisterAndPayRespVo(oeOrdItemID, callHisOutPatient);
        registerAndPayRespVo.setInvoiceId(quickResigisterInvoke.getEpisodeID());
        return FrontResponse.success((String)param.getTransactionId(), (Object)registerAndPayRespVo);
    }

    private RegisterAndPayRespVo getRegisterAndPayRespVo(String oeOrdItemID, CallHisOutPatient callHisOutPatient) {
        JSONObject jsonObject1 = callHisOutPatient.getJsonObject1();
        Object o = jsonObject1.get((Object)DATA);
        JSONObject jsonObject2 = JSON.parseObject((String)JSON.toJSONString((Object)o));
        Object opBillInvs = jsonObject2.get((Object)"OPBillInvs");
        List invoiceRespVos = JSON.parseArray((String)JSON.toJSONString((Object)opBillInvs), InvoiceRespVo.class);
        String invoiceNo = ((InvoiceRespVo)invoiceRespVos.get(0)).getInvoiceNo();
        RegisterAndPayRespVo registerAndPayRespVo = new RegisterAndPayRespVo();
        registerAndPayRespVo.setInvoiceId(invoiceNo);
        registerAndPayRespVo.setOEOrdItemStr(oeOrdItemID);
        return registerAndPayRespVo;
    }

    private MoreVisitRegisterReqQo setMoreVisitReg(RegisterAndPayReqQo body) {
        MoreVisitRegisterReqQo registerReqQo = new MoreVisitRegisterReqQo();
        registerReqQo.setAdmType(ADM_TYPE);
        registerReqQo.setCardNo(body.getCardNo());
        registerReqQo.setCardType(FIVE);
        registerReqQo.setLocCode(body.getDeptCode());
        registerReqQo.setDocCode(body.getDoctCode());
        registerReqQo.setClientType("CHINACHDU");
        registerReqQo.setAdmDate(DateUtil.dateToSimpleString((Date)new Date()));
        MoreVisitRegisterSubQo subQo = new MoreVisitRegisterSubQo();
        subQo.setDiagnosStatus(ZERO_THREE);
        subQo.setDiagnosType(PRE);
        registerReqQo.setRegisterSubQo(subQo);
        return registerReqQo;
    }

    public FrontResponse<List<RegisteredRecordResVo>> allowCheck(FrontRequest<RegisteredRecordReqVo> param) {
        try {
            RegisteredRecordReqVo body = (RegisteredRecordReqVo)param.getBody();
            QueryMedicalRecordDto queryMedicalRecordDto = this.getQueryMedicalRecordDto(body);
            String url = this.nodeConfig.getRemoteUrl() + "31022";
            String paramStr = JSON.toJSONString((Object)queryMedicalRecordDto);
            log.info("\u95e8\u8bca\u75c5\u5386\u63a5\u53e3\u5730\u5740\uff1a{},\u5165\u53c2:{}", (Object)url, (Object)paramStr);
            String response = HttpUtil.post((String)url, (String)paramStr);
            log.info("\u95e8\u8bca\u75c5\u5386\u63a5\u53e3\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8d44\u683c\u786e\u8ba4\u5f02\u5e38");
            }
            JSONArray jsonArray = jsonObject.getJSONArray(DATA);
            ArrayList recordResVos = Lists.newArrayList();
            for (Object json : jsonArray) {
                JSONObject o = (JSONObject)json;
                RegisteredRecordResVo vo = new RegisteredRecordResVo();
                vo.setRegDate(o.getString("AdmDate") + " " + o.getString("AdmTime"));
                vo.setDeptCode(o.getString("LocCode"));
                vo.setDoctName(o.getString("AdmDoctorDesc"));
                vo.setDoctCode(o.getString("AdmDoctorCode"));
                recordResVos.add(vo);
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)recordResVos);
        }
        catch (Exception e) {
            log.info("\u8d44\u683c\u786e\u8ba4\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8d44\u683c\u786e\u8ba4\u5f02\u5e38");
        }
    }

    public FrontResponse refund(FrontRequest<RefundReqQo> param) {
        log.info("ya-his\u9000\u53f7\u5165\u53c2\u6570\uff1a" + JSON.toJSONString((Object)param.getBody()));
        try {
            RefundReqQo reqQo = (RefundReqQo)param.getBody();
            OutPatientRefundReqQo refundReqQo = new OutPatientRefundReqQo();
            refundReqQo.setInvoiceID(reqQo.getInvoiceId());
            refundReqQo.setOEOrdItemSTR(refundReqQo.getOEOrdItemSTR());
            log.info("his\u9000\u53f7\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)refundReqQo));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "12014"), (String)JSON.toJSONString((Object)refundReqQo));
            log.info("his\u9000\u53f7\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resultCode);
        }
        catch (Exception e) {
            log.info("his\u9000\u53f7\u5f02\u5e38 {}", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u9000\u53f7\u5f02\u5e38");
        }
    }

    private QueryMedicalRecordDto getQueryMedicalRecordDto(RegisteredRecordReqVo body) {
        QueryMedicalRecordDto queryMedicalRecordDto = new QueryMedicalRecordDto();
        queryMedicalRecordDto.setCardNo(body.getCardNo());
        queryMedicalRecordDto.setClientType("CHINACHDU");
        queryMedicalRecordDto.setCardType("3");
        queryMedicalRecordDto.setStartDate(body.getBgDate());
        queryMedicalRecordDto.setEndDate(body.getEdDate());
        return queryMedicalRecordDto;
    }

    static /* synthetic */ MoreVisitRegisterReqQo access$000(IMoreVisitServiceImpl x0, RegisterAndPayReqQo x1) {
        return x0.setMoreVisitReg(x1);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

