/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.QueryRegisterRemoteVo;
import com.ebaiyihui.his.common.RegisterHisDto;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.pojo.dto.YaRegisterCardDto;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.service.impl.CardServiceImpl;
import com.ebaiyihui.his.utils.DobUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    NodeConfig nodeConfig;
    private static final String M_SEX = "M";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String THREE = "3";
    private static final String F_SEX = "F";

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            QueryCardHisInfo queryCardHisInfo = new QueryCardHisInfo(this, param).invoke();
            if (queryCardHisInfo.is()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
            }
            JSONObject jsonObject = queryCardHisInfo.getJsonObject();
            Object data = jsonObject.get((Object)"Data");
            QueryCardInfoResVO queryCardInfoResVO = this.getQueryCardInfoResVO(data);
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    private QueryCardInfoResVO getQueryCardInfoResVO(Object data) {
        List queryRegisterRemoteVos = JSON.parseArray((String)JSON.toJSONString((Object)data), QueryRegisterRemoteVo.class);
        QueryRegisterRemoteVo queryRegisterRemoteVo = (QueryRegisterRemoteVo)queryRegisterRemoteVos.get(0);
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        queryCardInfoResVO.setTelephone(queryRegisterRemoteVo.getTelephone());
        queryCardInfoResVO.setCardType(THREE);
        queryCardInfoResVO.setPinyin(PinyinUtil.getPinyin((String)queryRegisterRemoteVo.getPatientName(), (String)""));
        queryCardInfoResVO.setCardNo(queryRegisterRemoteVo.getCredentialNo());
        queryCardInfoResVO.setPatientId(queryRegisterRemoteVo.getPatRowID());
        queryCardInfoResVO.setDob(queryRegisterRemoteVo.getBirthDay());
        queryCardInfoResVO.setName(queryRegisterRemoteVo.getPatientName());
        queryCardInfoResVO.setSex(queryRegisterRemoteVo.getSexCode().equals(ONE) ? M_SEX : F_SEX);
        queryCardInfoResVO.setCredNo(queryRegisterRemoteVo.getCredentialNo());
        queryCardInfoResVO.setCredType("01");
        queryCardInfoResVO.setPatientNo(queryRegisterRemoteVo.getPatientNo());
        return queryCardInfoResVO;
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            YaRegisterCardDto yaRegisterCardDto = this.getYaRegisterCardDto(body);
            log.info("\u6ce8\u518c\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)yaRegisterCardDto));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "32000"), (String)JSON.toJSONString((Object)yaRegisterCardDto));
            log.info("\u6ce8\u518c\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
            }
            Object data = jsonObject.get((Object)"Data");
            RegisterHisDto hisDto = (RegisterHisDto)JSON.parseObject((String)JSON.toJSONString((Object)data), RegisterHisDto.class);
            RegisteredCardResVO registeredCardResVO = this.getRegisteredCardResVO(body, hisDto);
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    private RegisteredCardResVO getRegisteredCardResVO(RegisteredCardReqVO body, RegisterHisDto hisDto) {
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        registeredCardResVO.setCardNo(body.getCredNo());
        registeredCardResVO.setPatientId(hisDto.getPatRowID());
        registeredCardResVO.setPatientNo(hisDto.getPatientNo());
        registeredCardResVO.setCardType("01");
        registeredCardResVO.setName(body.getName());
        registeredCardResVO.setTelephone(body.getTelephone());
        registeredCardResVO.setCredNo(body.getCredNo());
        registeredCardResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
        registeredCardResVO.setDob(DobUtils.format((String)body.getCredNo().substring(6, 14)));
        registeredCardResVO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals(ONE) ? M_SEX : F_SEX);
        return registeredCardResVO;
    }

    private YaRegisterCardDto getYaRegisterCardDto(RegisteredCardReqVO body) {
        YaRegisterCardDto yaRegisterCardDto = new YaRegisterCardDto();
        yaRegisterCardDto.setCardNo(body.getCredNo());
        yaRegisterCardDto.setPatientName(body.getName());
        yaRegisterCardDto.setClientType("CHINACHDU");
        yaRegisterCardDto.setUserCode("fk01");
        yaRegisterCardDto.setCardTypeCode("03");
        yaRegisterCardDto.setSexCode(body.getSex().equals(M_SEX) ? ONE : TWO);
        yaRegisterCardDto.setBirthDay(body.getDob());
        yaRegisterCardDto.setCredentialTypeCode("01");
        yaRegisterCardDto.setCredentialNo(body.getCredNo());
        yaRegisterCardDto.setCredentialOwner(ONE);
        yaRegisterCardDto.setMobilePhone(body.getTelephone());
        return yaRegisterCardDto;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

