/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.MainPresInventoryHisDto;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.mainPres.DiseaseReqVo;
import com.ebaiyihui.his.pojo.vo.mainPres.DiseaseRespVo;
import com.ebaiyihui.his.pojo.vo.mainPres.MainPresInventoryResVO;
import com.ebaiyihui.his.pojo.vo.mainPres.MedicalAdviceReqQo;
import com.ebaiyihui.his.pojo.vo.mainPres.MedicalAdviceRespVo;
import com.ebaiyihui.his.pojo.vo.mainPres.MedicalAdviceSubQo;
import com.ebaiyihui.his.pojo.vo.mainPres.PayReqQo;
import com.ebaiyihui.his.pojo.vo.mainPres.QueryMainPresInventoryReqVO;
import com.ebaiyihui.his.pojo.vo.outPatient.OutPatientSubQo;
import com.ebaiyihui.his.service.IMainPresService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MainPresServiceImpl
implements IMainPresService {
    private static final Logger log = LoggerFactory.getLogger(MainPresServiceImpl.class);
    private static final String CARD_TYPE = "5";
    @Autowired
    NodeConfig nodeConfig;

    public FrontResponse<List<MainPresInventoryResVO>> inventory(FrontRequest<QueryMainPresInventoryReqVO> queryMainPresInventoryReqVO) {
        QueryMainPresInventoryReqVO body = (QueryMainPresInventoryReqVO)queryMainPresInventoryReqVO.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getEpisodeID()) || StringUtils.isEmpty((CharSequence)body.getDocEmplNo()) || CollectionUtils.isEmpty((Collection)body.getProductCodes())) {
            FrontResponse.error((String)queryMainPresInventoryReqVO.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("KeyWord", "");
            params.put("EpisodeID", body.getEpisodeID());
            params.put("UserCode", body.getDocEmplNo());
            String arcimCode = StringUtils.join((Iterable)body.getProductCodes(), (String)"^");
            params.put("ARCIMCode", arcimCode);
            params.put("OrderCatCode", "");
            params.put("RecLocCode", "YAZY121");
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "31021"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)queryMainPresInventoryReqVO.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            List hisDto = JSON.parseArray((String)JSON.toJSONString((Object)data), MainPresInventoryHisDto.class);
            ArrayList<MainPresInventoryResVO> mainPresInventoryResVOS = new ArrayList<MainPresInventoryResVO>();
            for (MainPresInventoryHisDto dto : hisDto) {
                MainPresInventoryResVO vo = new MainPresInventoryResVO();
                vo.setProductName(dto.getARCIMDesc());
                vo.setProductCode(dto.getARCIMCode());
                vo.setStockQty(dto.getStockQty());
                mainPresInventoryResVOS.add(vo);
            }
            return FrontResponse.success((String)queryMainPresInventoryReqVO.getTransactionId(), mainPresInventoryResVOS);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u533b\u5631\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)queryMainPresInventoryReqVO.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u533b\u5631\u5e93\u5b58\u5f02\u5e38");
        }
    }

    public FrontResponse<List<MedicalAdviceRespVo>> saveMain(FrontRequest<MedicalAdviceReqQo> medicalAdviceReqQo) {
        MedicalAdviceReqQo body = (MedicalAdviceReqQo)medicalAdviceReqQo.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getEpisodeID()) || StringUtils.isEmpty((CharSequence)body.getTPTradeNo()) || StringUtils.isEmpty((CharSequence)body.getUserCode())) {
            FrontResponse.error((String)medicalAdviceReqQo.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("EpisodeID", body.getEpisodeID());
            params.put("UserCode", body.getUserCode());
            params.put("ClientType", "CHINACHDU");
            params.put("OrderCatCode", "");
            params.put("OrderLocCode", body.getOrderLocCode());
            if (CollectionUtils.isEmpty((Collection)body.getSubQos())) {
                MedicalAdviceSubQo qo = (MedicalAdviceSubQo)JSON.parseObject((String)"{\"ARCIMCode\":\"11010000102\",\"ARCOSCode\":\"\",\"AnaesthesiaID\":\"\",\"DoseQty\":\"\",\"DoseUOMCode\":\"\",\"ExceedDurReasonCode\":\"\",\"InsuTypeCode\":\"07\",\"InsurSignSymptomCode\":\"\",\"LabEpisodeNo\":\"\",\"LabSpec\":\"\",\"OrderActionCode\":\"\",\"OrderAntibApplyId\":\"\",\"OrderCoverMainIns\":\"\",\"OrderDIACatCode\":\"\",\"OrderDate\":\"\",\"OrderDepProcNotes\":\"\",\"OrderDurCode\":\"1\u5929\",\"OrderEndDate\":\"\",\"OrderEndTime\":\"\",\"OrderFirstDayTimes\":\"2\",\"OrderInsurCatCode\":\"\",\"OrderMasterSeqNo\":\"\",\"OrderMultiDate\":\"\",\"OrderNeedPIVAFlag\":\"\",\"OrderNotifyClinician\":\"\",\"OrderPackQty\":\"1\",\"OrderPhSpecInstr\":\"\",\"OrderPrice\":\"0\",\"OrderPrior\":\"NORM\",\"OrderRecLoc\":\"YAZY121\",\"OrderSeqNo\":\"\",\"OrderSkinTest\":\"\",\"OrderSpeedFlowRate\":\"\",\"OrderStageCode\":\"\",\"OrderStartDate\":\"2023-11-07\",\"OrderStartTime\":\"11:23:00\",\"UserReasonCode\":\"\",\"OrderFreqCode\":\"Qd\",\"OrderInstrCode\":\"\",\"PackUOMCode\":\"\",\"NutritionDrugFlag\":\"\",\"HMaterialBarCode\":\"\",\"CPWStepCode\":\"\",\"InsurApproveType\":\"\",\"FlowRateUnit\":\"\",\"LocalInfusionQty\":\"\",\"BySelfOMFlag\":\"\",\"TPTradeNo\":\"\",\"PilotProCode\":\"\"}", MedicalAdviceSubQo.class);
                qo.setOrderStartDate(DateUtil.getCurrentDateStr());
                body.getSubQos().add(qo);
            }
            params.put("Data", body.getSubQos());
            log.info("\u6267\u884c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(params));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "32010"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)medicalAdviceReqQo.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            List hisDto = JSON.parseArray((String)JSON.toJSONString((Object)data), MedicalAdviceRespVo.class);
            return FrontResponse.success((String)medicalAdviceReqQo.getTransactionId(), (Object)hisDto);
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u533b\u5631\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)medicalAdviceReqQo.getTransactionId(), (String)"0", (String)"\u4fdd\u5b58\u533b\u5631\u5f02\u5e38");
        }
    }

    public FrontResponse pay(FrontRequest<PayReqQo> payReqQo) {
        PayReqQo body = (PayReqQo)payReqQo.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getCardNo()) || StringUtils.isEmpty((CharSequence)body.getDoctCode()) || StringUtils.isEmpty((CharSequence)body.getOrderSeq()) || CollectionUtils.isEmpty((Collection)body.getOeOrdItemIds())) {
            FrontResponse.error((String)payReqQo.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("CardNo", body.getCardNo());
            params.put("CardType", CARD_TYPE);
            params.put("CardTypeCode", "");
            params.put("ClientType", "CHINACHDU");
            params.put("UserCode", "HLW001");
            params.put("HospCode", "YASZYYY");
            ArrayList _data = new ArrayList();
            for (String id : body.getOeOrdItemIds()) {
                HashMap<String, String> dataItem = new HashMap<String, String>();
                dataItem.put("OEOrdItemID", id);
                _data.add(dataItem);
            }
            params.put("Data", _data);
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "11004"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)payReqQo.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            JSONArray arr = JSON.parseArray((String)JSON.toJSONString((Object)data));
            JSONObject hisDto = (JSONObject)JSON.toJSON((Object)arr.get(0));
            params = new HashMap();
            params.put("CardNo", body.getCardNo());
            params.put("CardType", CARD_TYPE);
            params.put("CardTypeCode", "");
            params.put("TPTradeNo", body.getOrderSeq());
            params.put("UserCode", "HLW001");
            params.put("PayMode", "WXZF");
            params.put("PayFee", hisDto.getString("AmtSum"));
            params.put("PayFeeUnit", hisDto.getString("MoneyUnit"));
            params.put("InsuTypeCode", "07");
            params.put("HISTradeNo", hisDto.getString("HISTradeNo"));
            params.put("PayInsuTypeCode", "");
            params.put("TPExtTradeNo", "");
            params.put("ClientType", "CHINACHDU");
            params.put("BankInfo", JSON.toJSONString((Object)new OutPatientSubQo()));
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "12004"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            jsonObject = JSON.parseObject((String)response);
            resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)payReqQo.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            return FrontResponse.success((String)payReqQo.getTransactionId(), null);
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u7f34\u8d39\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)payReqQo.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u7f34\u8d39\u5f02\u5e38");
        }
    }

    public FrontResponse<List<DiseaseRespVo>> saveDiagnos(FrontRequest<DiseaseReqVo> diseaseReqVo) {
        DiseaseReqVo body = (DiseaseReqVo)diseaseReqVo.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getEpisodeID()) || CollectionUtils.isEmpty((Collection)body.getDiseaseList())) {
            FrontResponse.error((String)diseaseReqVo.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("EpisodeID", body.getEpisodeID());
            params.put("ClientType", "CHINACHDU");
            params.put("TPTradeNo", body.getTPTradeNo());
            params.put("Data", body.getDiseaseList());
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "12010"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)diseaseReqVo.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            List hisDto = JSON.parseArray((String)JSON.toJSONString((Object)data), DiseaseRespVo.class);
            return FrontResponse.success((String)diseaseReqVo.getTransactionId(), (Object)hisDto);
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u8bca\u65ad\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)diseaseReqVo.getTransactionId(), (String)"0", (String)"\u4fdd\u5b58\u8bca\u65ad\u5f02\u5e38");
        }
    }

    public FrontResponse getdic(String type, String oLHFlag) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("DicCode", type);
        param.put("ParfDicCode", "");
        param.put("Count", "9999");
        param.put("Page", "1");
        param.put("HospCode", "YASZYYY");
        param.put("ClientType", "CHINACHDU");
        param.put("Active", "Y");
        param.put("KeyWord", "");
        param.put("OLHFlag", oLHFlag);
        String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "31023"), (String)JSON.toJSONString(param));
        return FrontResponse.success((String)"", (Object)response);
    }
}

