/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.ReportDetailItemRespVo;
import com.ebaiyihui.his.pojo.vo.report.ReportDetailReqVo;
import com.ebaiyihui.his.pojo.vo.report.ReportDetailRespVo;
import com.ebaiyihui.his.pojo.vo.report.ReportListRespVo;
import com.ebaiyihui.his.service.IReportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements IReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    @Autowired
    NodeConfig nodeConfig;
    private static final String REPORT_STATUS = "F";
    private static final String CARD_TYPE = "5";

    public FrontResponse<GetReportListsRes> list(FrontRequest<GetReportListsReq> getReportListsReq) {
        GetReportListsReq body = (GetReportListsReq)getReportListsReq.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getReportType()) || StringUtils.isEmpty((CharSequence)body.getCardNo()) || StringUtils.isEmpty((CharSequence)body.getBeginTime()) || StringUtils.isEmpty((CharSequence)body.getEndTime())) {
            FrontResponse.error((String)getReportListsReq.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String url = this.nodeConfig.getRemoteUrl();
            params.put("CardNo", body.getCardNo());
            params.put("CardType", CARD_TYPE);
            params.put("CardTypeCode", "");
            params.put("StartDate", body.getBeginTime());
            params.put("EndDate", body.getEndTime());
            switch (body.getReportType()) {
                case "2": {
                    params.put("ReportType", "Ris");
                    url = url + "31027";
                    break;
                }
                default: {
                    params.put("ReportType", "Lis");
                    url = url + "31004";
                }
            }
            params.put("ClientType", "CHINACHDU");
            params.put("ReportStatus", REPORT_STATUS);
            params.put("OGFParms", "");
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            String response = HttpUtil.post((String)url, (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)getReportListsReq.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            List hisDto = JSON.parseArray((String)JSON.toJSONString((Object)data), ReportListRespVo.class);
            GetReportListsRes resDto = new GetReportListsRes();
            resDto.setSuccess("1");
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (ReportListRespVo dto : hisDto) {
                GetReportListsData res = new GetReportListsData();
                res.setReportNo(dto.getReportID());
                res.setReportName(dto.getARCIMDesc());
                res.setReportType(body.getReportType());
                res.setReportDate(dto.getReportDate());
                res.setReportTime(dto.getReportTime());
                res.setTsName(dto.getARCIMDesc());
                datas.add(res);
            }
            resDto.setDatas(datas);
            return FrontResponse.success((String)getReportListsReq.getTransactionId(), (Object)resDto);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u62a5\u544a\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)getReportListsReq.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u62a5\u544a\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<LisReportListRes> lisDetail(FrontRequest<ReportDetailReqVo> reportDetailReqVo) {
        ReportDetailReqVo body = (ReportDetailReqVo)reportDetailReqVo.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getReportNo()) || StringUtils.isEmpty((CharSequence)body.getReportType())) {
            FrontResponse.error((String)reportDetailReqVo.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ReportID", body.getReportNo());
            params.put("ReportType", body.getReportType());
            params.put("ClientType", "CHINACHDU");
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "31005"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)reportDetailReqVo.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            ReportDetailRespVo hisDto = (ReportDetailRespVo)JSON.parseObject((String)JSON.toJSONString((Object)data), ReportDetailRespVo.class);
            LisReportListRes res = new LisReportListRes();
            res.setPatientName(hisDto.getPatName());
            res.setReportName(hisDto.getExamCat());
            res.setReportNo(body.getReportNo());
            res.setPatientNo(hisDto.getIOPNO());
            res.setSex(Objects.equals(res.getSex(), "\u7537") ? "1" : "2");
            res.setAge(hisDto.getAge());
            res.setDeptName(hisDto.getAdmLoc());
            res.setBed(hisDto.getBedNo());
            res.setAuthTime(hisDto.getReportDate() + " " + hisDto.getReportTime());
            res.setAuthUser(hisDto.getPriReportDoc());
            res.setPatientDOB(hisDto.getBirthDay());
            res.setDiagnosis(hisDto.getDiagnose());
            ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
            for (ReportDetailItemRespVo d : hisDto.getItemDetail()) {
                LisReportListResData rd = new LisReportListResData();
                rd.setItmCode(d.getTestCode());
                rd.setItmName(d.getTestCodeName());
                rd.setItmRes(d.getResult());
                rd.setItmRanges(d.getRefRanges());
                rd.setItmUnit(d.getUnits());
                rd.setItmCrises(d.getWarnFlag());
                datas.add(rd);
            }
            res.setDatas(datas);
            return FrontResponse.success((String)reportDetailReqVo.getTransactionId(), (Object)res);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u62a5\u544a\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)reportDetailReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<PacsReportListRes> risDetail(FrontRequest<ReportDetailReqVo> reportDetailReqVo) {
        ReportDetailReqVo body = (ReportDetailReqVo)reportDetailReqVo.getBody();
        if (StringUtils.isEmpty((CharSequence)body.getReportNo()) || StringUtils.isEmpty((CharSequence)body.getReportType())) {
            FrontResponse.error((String)reportDetailReqVo.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ReportID", body.getReportNo());
            params.put("ReportType", body.getReportType());
            params.put("ClientType", "CHINACHDU");
            log.info("\u6267\u884c\u5165\u53c2\uff1a" + JSON.toJSONString(params));
            String response = HttpUtil.post((String)(this.nodeConfig.getRemoteUrl() + "31028"), (String)JSON.toJSONString(params));
            log.info("\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            JSONObject jsonObject = JSON.parseObject((String)response);
            String resultCode = String.valueOf(jsonObject.get((Object)"ResultCode"));
            if (!"0".equals(resultCode)) {
                return FrontResponse.error((String)reportDetailReqVo.getTransactionId(), (String)"0", (String)String.valueOf(jsonObject.get((Object)"ResultMsg")));
            }
            Object data = jsonObject.get((Object)"Data");
            ReportDetailRespVo hisDto = (ReportDetailRespVo)JSON.parseObject((String)JSON.toJSONString((Object)data), ReportDetailRespVo.class);
            PacsReportListRes res = new PacsReportListRes();
            res.setPatientName(hisDto.getPatName());
            res.setReportName(hisDto.getExamCat());
            res.setReportNo(body.getReportNo());
            res.setPatientNo(hisDto.getIOPNO());
            res.setSex(Objects.equals(res.getSex(), "\u7537") ? "1" : "2");
            res.setAge(hisDto.getAge());
            res.setDeptName(hisDto.getAdmLoc());
            res.setBed(hisDto.getBedNo());
            res.setAuthTime(hisDto.getReportDate() + " " + hisDto.getReportTime());
            res.setAuthUser(hisDto.getPriReportDoc());
            res.setPatientDOB(hisDto.getBirthDay());
            res.setCheckDate(res.getAuthTime());
            res.setCheckOper(hisDto.getReportDoc());
            res.setCheckDesc(hisDto.getExamDesc());
            res.setCheckResult(hisDto.getExamResult());
            return FrontResponse.success((String)reportDetailReqVo.getTransactionId(), (Object)res);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u62a5\u544a\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)reportDetailReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }
}

