/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String TIME_FORMAT = "HH:mm:ss";
    public static String DATE_FORMAT = "yyyy-MM-dd";
    public static final String FORMAT = "yyyyMMddHHmmss";

    public static String getCurrentTimeStr() {
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        return format.format(currentDate);
    }

    public static Integer compareTime(String time) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date futureTime = format.parse(time);
            Date nowTime = new Date();
            int sign = futureTime.compareTo(nowTime);
            return sign;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getCurrentDateStr() {
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(currentDate);
    }

    public static String dateStrToStamp(String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FULL_FORMAT);
        Date date = simpleDateFormat.parse(s);
        long ts = date.getTime();
        String res = String.valueOf(ts);
        return res;
    }

    public static Date getAfterCurrentDay(int days) {
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    public static String dealDateFormat(String oldDateStr) throws ParseException {
        if (null == oldDateStr) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = df.parse(oldDateStr);
        SimpleDateFormat df1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.UK);
        Date date1 = df1.parse(date.toString());
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df2.format(date1);
    }

    public static String getCurrentDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(FORMAT);
        return df.format(calendar.getTime());
    }
}

