/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.his.core.dto.CheckReportListItems;
import com.ebaiyihui.his.core.dto.CheckReportListResDTO;
import com.ebaiyihui.his.core.dto.CheckReportResultItems;
import com.ebaiyihui.his.core.dto.CheckReportResultResDTO;
import com.ebaiyihui.his.core.dto.GetPhyCheckReportItemDto;
import com.ebaiyihui.his.core.dto.PhyCheckItemDTO;
import com.ebaiyihui.his.core.dto.PhyCheckReportDTO;
import com.ebaiyihui.his.core.dto.PhyCheckReportDTOList;
import com.ebaiyihui.his.core.dto.PhyCheckReportItemDto;
import com.ebaiyihui.his.core.dto.PhyCheckReportListDTO;
import com.ebaiyihui.his.core.dto.PhyCheckResultDTO;
import com.ebaiyihui.his.core.dto.PhyCheckegistersDto;
import com.ebaiyihui.his.core.dto.ReportDetailItems;
import com.ebaiyihui.his.core.dto.ReportDetailsResDTO;
import com.ebaiyihui.his.core.dto.ReportListItems;
import com.ebaiyihui.his.core.dto.ReportListReqDTO;
import com.ebaiyihui.his.core.dto.ReportListResDTO;
import com.ebaiyihui.his.core.dto.ReportMethodReq;
import com.ebaiyihui.his.core.dto.ReportResultItems;
import com.ebaiyihui.his.core.dto.ReportResultResDTO;
import com.ebaiyihui.his.core.enums.ItmCrisesEnums;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.ReportMethodEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.service.ElectronicReportService;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.utils.DateUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetPhyCheckReportItemReq;
import com.ebaiyihui.his.pojo.vo.report.GetPhyCheckReportItemRes;
import com.ebaiyihui.his.pojo.vo.report.GetPhyCheckReportListReq;
import com.ebaiyihui.his.pojo.vo.report.GetPhyCheckReportListRes;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetPhyCheckReportData;
import com.ebaiyihui.his.pojo.vo.report.datas.GetPhyCheckReportItemData;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.datas.PhyCheckItemData;
import com.ebaiyihui.his.pojo.vo.report.datas.PhyCheckResultData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        Date date = new Date();
        String endTime = DateUtils.dateToString((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SS");
        String startTime = DateUtils.dateToString((Date)DateUtils.getAddMonth((Date)date, (int)-3), (String)"yyyy-MM-dd'T'HH:mm:ss.SS");
        GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
        ReportListReqDTO reportListReqDTO = new ReportListReqDTO();
        reportListReqDTO.setPatientNo(getReportListsReq.getCardNo());
        reportListReqDTO.setPatientName(getReportListsReq.getPatientId());
        reportListReqDTO.setBeginTime(startTime);
        reportListReqDTO.setEndTime(endTime);
        if (getReportListsReq.getReportType().equals("1")) {
            return this.getAssayReportList(reportListReqDTO, param.getTransactionId());
        }
        if (getReportListsReq.getReportType().equals("2")) {
            return this.getCheckReportList(reportListReqDTO, param.getTransactionId());
        }
        return FrontResponse.error((String)param.getTransactionId(), (IError)IError.DATA_ERROR);
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        LisReportListRes lisReportListRes = new LisReportListRes();
        ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RequestEntityEnum.REPORT_DETAILS.getValue(), param.getBody());
        FrontResponse reportDetailsRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INSPECTION_REPORT_DETAILS.getValue(), map, ReportDetailsResDTO.class);
        log.info("\u8fd4\u56de\u53c2\u6570" + Objects.toString(reportDetailsRes));
        if (null == reportDetailsRes) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)reportDetailsRes.getMessage());
        }
        if (!"1".equals(((ReportDetailsResDTO)reportDetailsRes.getBody()).getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((ReportDetailsResDTO)reportDetailsRes.getBody()).getErr());
        }
        List itemResDTOList = ((ReportDetailsResDTO)reportDetailsRes.getBody()).getReportDetail().getItemsList();
        if (CollectionUtils.isEmpty((Collection)itemResDTOList)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((ReportDetailsResDTO)reportDetailsRes.getBody()).getErr());
        }
        FrontResponse reportResultRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INSPECTION_REPORT_RESULT.getValue(), map, ReportResultResDTO.class);
        if (null == reportResultRes || null == reportResultRes.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)reportResultRes.getMessage());
        }
        if (!"1".equals(((ReportResultResDTO)reportResultRes.getBody()).getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((ReportResultResDTO)reportResultRes.getBody()).getErr());
        }
        List reportResultItems = ((ReportResultResDTO)reportResultRes.getBody()).getReportResult().getResultItemsList();
        if (CollectionUtils.isEmpty((Collection)reportResultItems)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((ReportResultResDTO)reportResultRes.getBody()).getErr());
        }
        BeanUtils.copyProperties(itemResDTOList.get(0), (Object)lisReportListRes);
        String specNo = "";
        if (StringUtils.isNotEmpty((CharSequence)((ReportDetailItems)itemResDTOList.get(0)).getTestformNo())) {
            specNo = ((ReportDetailItems)itemResDTOList.get(0)).getTestformNo();
        }
        String admType = "I";
        if ("\u95e8\u8bca".equals(((ReportDetailItems)itemResDTOList.get(0)).getPatientType())) {
            admType = "O";
        }
        String print = "N";
        if (StringUtils.isNotEmpty((CharSequence)((ReportDetailItems)itemResDTOList.get(0)).getPrintTime())) {
            print = "Y";
        }
        lisReportListRes.setAdmType(admType);
        lisReportListRes.setPrint(print);
        lisReportListRes.setSpecNo(specNo);
        for (ReportResultItems reportResultItem : reportResultItems) {
            LisReportListResData lisReportListResData = new LisReportListResData();
            BeanUtils.copyProperties((Object)reportResultItem, (Object)lisReportListResData);
            lisReportListResData.setItmCrises(ItmCrisesEnums.getDisplay((String)reportResultItem.getFlag()));
            datas.add(lisReportListResData);
        }
        lisReportListRes.setDatas(datas);
        return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RequestEntityEnum.REPORT_DETAILS.getValue(), param.getBody());
        FrontResponse reportDetailsRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CHECK_REPORT_DETAILS.getValue(), map, CheckReportResultResDTO.class);
        log.info("\u8fd4\u56de\u53c2\u6570" + Objects.toString(reportDetailsRes));
        if (null == reportDetailsRes) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)reportDetailsRes.getMessage());
        }
        if (!"1".equals(((CheckReportResultResDTO)reportDetailsRes.getBody()).getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((CheckReportResultResDTO)reportDetailsRes.getBody()).getErr());
        }
        List itemResDTOList = ((CheckReportResultResDTO)reportDetailsRes.getBody()).getReportResult().getResultItemsList();
        if (CollectionUtils.isEmpty((Collection)itemResDTOList)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((CheckReportResultResDTO)reportDetailsRes.getBody()).getErr());
        }
        BeanUtils.copyProperties(itemResDTOList.get(0), (Object)pacsReportListRes);
        pacsReportListRes.setAuthUser(((CheckReportResultItems)itemResDTOList.get(0)).getDoctorName());
        pacsReportListRes.setPrint(((CheckReportResultItems)itemResDTOList.get(0)).getIsPrint().equals("\u5df2\u6253\u5370") ? "Y" : "N");
        pacsReportListRes.setAdmType(((CheckReportResultItems)itemResDTOList.get(0)).getIsHisPatientType().equals("\u95e8\u8bca") ? "O" : "I");
        return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
    }

    private FrontResponse<GetReportListsRes> getAssayReportList(ReportListReqDTO reportListReqDTO, String transactionId) {
        ArrayList<GetReportListsData> getReportList = new ArrayList<GetReportListsData>();
        HashMap<String, ReportListReqDTO> map = new HashMap<String, ReportListReqDTO>();
        map.put(RequestEntityEnum.REPORT_LIST.getValue(), reportListReqDTO);
        FrontResponse reportListRes = this.hisRemoteService.requestHis(transactionId, MethodCodeEnum.INSPECTION_REPORT_LIST.getValue(), map, ReportListResDTO.class);
        if (null == reportListRes || null == reportListRes.getBody()) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)reportListRes.getMessage());
        }
        if (!"1".equals(((ReportListResDTO)reportListRes.getBody()).getResult())) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)((ReportListResDTO)reportListRes.getBody()).getErr());
        }
        List itemResDTOList = ((ReportListResDTO)reportListRes.getBody()).getReportList().getReportListItems();
        if (CollectionUtils.isEmpty((Collection)itemResDTOList)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)((ReportListResDTO)reportListRes.getBody()).getErr());
        }
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setSuccess("1");
        getReportListsRes.setMessage(((ReportListResDTO)reportListRes.getBody()).getErr());
        getReportListsRes.setPatientName(((ReportListItems)itemResDTOList.get(0)).getPatientName());
        getReportListsRes.setPatientID(((ReportListItems)itemResDTOList.get(0)).getPatientId());
        for (ReportListItems reportListItems : itemResDTOList) {
            GetReportListsData getReportListsData = new GetReportListsData();
            BeanUtils.copyProperties((Object)reportListItems, (Object)getReportListsData);
            getReportListsData.setReportType("1");
            getReportList.add(getReportListsData);
        }
        getReportListsRes.setDatas(getReportList);
        return FrontResponse.success((String)transactionId, (Object)getReportListsRes);
    }

    private FrontResponse<GetReportListsRes> getCheckReportList(ReportListReqDTO reportListReqDTO, String transactionId) {
        ArrayList<GetReportListsData> getReportList = new ArrayList<GetReportListsData>();
        HashMap<String, ReportListReqDTO> map = new HashMap<String, ReportListReqDTO>();
        map.put(RequestEntityEnum.REPORT_LIST.getValue(), reportListReqDTO);
        FrontResponse reportListRes = this.hisRemoteService.requestHis(transactionId, MethodCodeEnum.CHECK_REPORT_LIST.getValue(), map, CheckReportListResDTO.class);
        if (null == reportListRes || null == reportListRes.getBody()) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)reportListRes.getMessage());
        }
        if (!"1".equals(((CheckReportListResDTO)reportListRes.getBody()).getResult())) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)((CheckReportListResDTO)reportListRes.getBody()).getErr());
        }
        List itemResDTOList = ((CheckReportListResDTO)reportListRes.getBody()).getReportList().getReportListItems();
        if (CollectionUtils.isEmpty((Collection)itemResDTOList)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)((CheckReportListResDTO)reportListRes.getBody()).getErr());
        }
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setSuccess("1");
        getReportListsRes.setMessage(((CheckReportListResDTO)reportListRes.getBody()).getErr());
        getReportListsRes.setPatientID(reportListReqDTO.getPatientNo());
        getReportListsRes.setPatientNo(reportListReqDTO.getPatientNo());
        for (CheckReportListItems reportListItems : itemResDTOList) {
            GetReportListsData getReportListsData = new GetReportListsData();
            BeanUtils.copyProperties((Object)reportListItems, (Object)getReportListsData);
            getReportListsData.setReportType("2");
            getReportList.add(getReportListsData);
        }
        getReportListsRes.setDatas(getReportList);
        return FrontResponse.success((String)transactionId, (Object)getReportListsRes);
    }

    public FrontResponse<GetPhyCheckReportListRes> getPhyReportList(FrontRequest<GetPhyCheckReportListReq> param) {
        ReportMethodReq reportMethodReq = new ReportMethodReq();
        reportMethodReq.setIdNo(((GetPhyCheckReportListReq)param.getBody()).getIdenNO());
        FrontResponse response = this.hisRemoteService.requestReportHis(param.getTransactionId(), ReportMethodEnum.QUERY_CHECK_INFO.getValue(), reportMethodReq, PhyCheckReportListDTO.class);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"S0001".equals(((PhyCheckReportListDTO)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((PhyCheckReportListDTO)response.getBody()).getMessage());
        }
        PhyCheckReportListDTO phyCheckReportListDTO = (PhyCheckReportListDTO)response.getBody();
        PhyCheckReportDTOList phyCheckReportDTOList = phyCheckReportListDTO.getPhyCheckReportDTOList();
        List phyCheckReportDTOs = phyCheckReportDTOList.getPhyCheckReportDTOs();
        GetPhyCheckReportListRes getPhyCheckReportListRes = new GetPhyCheckReportListRes();
        ArrayList<GetPhyCheckReportData> getCheckReportDataList = new ArrayList<GetPhyCheckReportData>();
        for (PhyCheckReportDTO phyCheckReportDTO : phyCheckReportDTOs) {
            GetPhyCheckReportData getPhyCheckReportData = new GetPhyCheckReportData();
            BeanUtils.copyProperties((Object)phyCheckReportDTO, (Object)getPhyCheckReportData);
            getCheckReportDataList.add(getPhyCheckReportData);
        }
        getPhyCheckReportListRes.setGetCheckReportDataList(getCheckReportDataList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPhyCheckReportListRes);
    }

    public FrontResponse<GetPhyCheckReportItemRes> getPhyReportItem(FrontRequest<GetPhyCheckReportItemReq> param) {
        ReportMethodReq reportMethodReq = new ReportMethodReq();
        reportMethodReq.setClinicCode(((GetPhyCheckReportItemReq)param.getBody()).getClinicCode());
        FrontResponse response = this.hisRemoteService.requestReportHis(param.getTransactionId(), ReportMethodEnum.QUERY_REPORT.getValue(), reportMethodReq, GetPhyCheckReportItemDto.class);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"S0001".equals(((GetPhyCheckReportItemDto)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((GetPhyCheckReportItemDto)response.getBody()).getMessage());
        }
        GetPhyCheckReportItemDto getPhyCheckReportItemDto = (GetPhyCheckReportItemDto)response.getBody();
        PhyCheckegistersDto registers = getPhyCheckReportItemDto.getRegisters();
        List phyCheckReportItemDtos = registers.getPhyCheckReportItemDto();
        GetPhyCheckReportItemRes getPhyCheckReportItemRes = new GetPhyCheckReportItemRes();
        ArrayList<GetPhyCheckReportItemData> GetPhyCheckReportItemDatas = new ArrayList<GetPhyCheckReportItemData>();
        for (PhyCheckReportItemDto phyCheckReportItemDto : phyCheckReportItemDtos) {
            GetPhyCheckReportItemData getPhyCheckReportItemData = new GetPhyCheckReportItemData();
            BeanUtils.copyProperties((Object)phyCheckReportItemDto, (Object)getPhyCheckReportItemData);
            List result = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)phyCheckReportItemDto.getResult())) {
                result = phyCheckReportItemDto.getResult();
            }
            ArrayList<PhyCheckResultData> phyCheckResultDatas = new ArrayList<PhyCheckResultData>();
            for (PhyCheckResultDTO phyCheckResultDTO : result) {
                PhyCheckResultData phyCheckResultData = new PhyCheckResultData();
                BeanUtils.copyProperties((Object)phyCheckResultDTO, (Object)phyCheckResultData);
                List phyCheckItemDTOs = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)phyCheckResultDTO.getItem())) {
                    phyCheckItemDTOs = phyCheckResultDTO.getItem();
                }
                ArrayList<PhyCheckItemData> items = new ArrayList<PhyCheckItemData>();
                for (PhyCheckItemDTO phyCheckItemDTO : phyCheckItemDTOs) {
                    PhyCheckItemData phyCheckItemData = new PhyCheckItemData();
                    BeanUtils.copyProperties((Object)phyCheckItemDTO, (Object)phyCheckItemData);
                    items.add(phyCheckItemData);
                }
                phyCheckResultData.setItem(items);
                phyCheckResultDatas.add(phyCheckResultData);
            }
            getPhyCheckReportItemData.setResult(phyCheckResultDatas);
            GetPhyCheckReportItemDatas.add(getPhyCheckReportItemData);
        }
        getPhyCheckReportItemRes.setCheckReportDataList(GetPhyCheckReportItemDatas);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPhyCheckReportItemRes);
    }
}

