/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.ebaiyihui.his.core.dto.HisBillInfoResDTO;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.enums.TradeTypeEnum;
import com.ebaiyihui.his.core.service.HisBillService;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.vo.HisBillInfoDetailResVo;
import com.ebaiyihui.his.core.vo.HisBillInfoReqVo;
import com.ebaiyihui.his.core.vo.HisBillInfoResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HisBillServiceImpl
implements HisBillService {
    private static final Logger log = LoggerFactory.getLogger(HisBillServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<HisBillInfoResVo> getHisBillInfo(FrontRequest<HisBillInfoReqVo> param) {
        HashMap<String, Object> getHisBillReqMap = new HashMap<String, Object>(1);
        getHisBillReqMap.put(RequestEntityEnum.BILL_INFO.getValue(), param.getBody());
        FrontResponse requestHis = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILL_INFO.getValue(), getHisBillReqMap, HisBillInfoResDTO.class);
        if (null == requestHis || null == requestHis.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)requestHis.getMessage());
        }
        if (!"1".equals(((HisBillInfoResDTO)requestHis.getBody()).getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((HisBillInfoResDTO)requestHis.getBody()).getResultMsg());
        }
        HisBillInfoResVo hisBillInfoResVo = ((HisBillInfoResDTO)requestHis.getBody()).getHisBillInfoResVo();
        for (HisBillInfoDetailResVo hisBillInfoDetailResVo : hisBillInfoResVo.getBillInfoList()) {
            String tradeType = hisBillInfoDetailResVo.getTradeType();
            tradeType = "\u6302\u53f7".equals(tradeType) || "\u9000\u53f7".equals(tradeType) ? TradeTypeEnum.REGISTERED.getDisplay() : ("\u7f34\u8d39".equals(tradeType) || "\u9000\u8d39".equals(tradeType) ? TradeTypeEnum.PAYCOST.getDisplay() : ("\u4ea4\u9884\u4ea4\u91d1".equals(tradeType) || "\u9000\u9884\u4ea4\u91d1".equals(tradeType) ? TradeTypeEnum.HOSPITAL_PAYMENT.getDisplay() : TradeTypeEnum.OTHER.getDisplay()));
            hisBillInfoDetailResVo.setTradeType(tradeType);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)hisBillInfoResVo);
    }
}

