/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.core.constant.BaseConstant;
import com.ebaiyihui.his.core.dto.ReportMethodReq;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.utils.CxfClientUtil;
import com.ebaiyihui.his.core.utils.XmlTemplateKit;
import com.ebaiyihui.his.core.utils.XmlUtil;
import com.ebaiyihui.his.core.vo.medicaladvice.MadParamReq;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.checkAppoint.CheckAppointReq;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private static final Logger log = LoggerFactory.getLogger(HisRemoteServiceImpl.class);
    @Value(value="${debug}")
    private Boolean debug;
    @Value(value="${his.wsdlUrl}")
    private String wsdlUrl;
    @Value(value="${his.oldUrl}")
    private String oldUrl;
    @Value(value="${his.method}")
    private String method;
    @Value(value="${his.madUrl}")
    private String madUrl;

    public <T> FrontResponse<T> requestHis(String transactionId, String methodStr, Map map, Class<T> clazz) {
        Object resHisDTO = null;
        try {
            String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            String responseHisXml = this.debug != false ? XmlTemplateKit.processDebug((String)methodStr) : (BaseConstant.METHODLIST.contains(methodStr) ? new CxfClientUtil().send(this.oldUrl, this.method, methodStr, requestHisXml) : new CxfClientUtil().send(this.wsdlUrl, this.method, methodStr, requestHisXml));
            if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
            resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
            log.info("resHisDTO\u6267\u884c\u7ed3\u679cinfo\uff1a" + resHisDTO.toString());
            if (null == resHisDTO) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42his\u5931\u8d25:{}", (Throwable)e);
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> requestHis(String template, String transactionId, String methodStr, Map map, Class<T> clazz) {
        Object resHisDTO = null;
        try {
            String requestHisXml = XmlTemplateKit.process((String)template, (Map)map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            String responseHisXml = this.debug != false ? XmlTemplateKit.processDebug((String)methodStr) : (BaseConstant.METHODLIST.contains(methodStr) ? new CxfClientUtil().send(this.oldUrl, this.method, methodStr, requestHisXml) : new CxfClientUtil().send(this.wsdlUrl, this.method, methodStr, requestHisXml));
            if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
            resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
            log.info("resHisDTO\u6267\u884c\u7ed3\u679cinfo\uff1a" + resHisDTO.toString());
            if (null == resHisDTO) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42his\u5931\u8d25:{}", (Throwable)e);
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> requestNewHis(String transactionId, String method, CheckAppointReq checkAppointReq, Class<T> c) {
        log.info("\u53d1\u8d77his\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + JSON.toJSONString((Object)checkAppointReq));
        String object = new CxfClientUtil().send(method, checkAppointReq);
        log.info("his\u54cd\u5e94\u7ed3\u679c\uff0c\u53c2\u6570\uff1a" + object);
        if (StringUtils.isEmpty((CharSequence)object)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        List list = JSON.parseArray((String)object, c);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString(list.get(0)));
        return FrontResponse.success((String)transactionId, list.get(0));
    }

    public <T> FrontResponse<T> requestReportHis(String transactionId, String methodStr, ReportMethodReq reportMethodReq, Class<T> c) {
        log.info("\u53d1\u8d77his\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + JSON.toJSONString((Object)reportMethodReq));
        String object = new CxfClientUtil().reportSend(this.wsdlUrl, methodStr, reportMethodReq);
        log.info("his\u54cd\u5e94\u7ed3\u679c\uff0c\u53c2\u6570\uff1a" + object);
        if (StringUtils.isEmpty((CharSequence)object)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        Object t = XmlUtil.convertToJavaBean((String)object, c);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)t));
        return FrontResponse.success((String)transactionId, (Object)t);
    }

    public <T> FrontResponse<T> requestMadHis(String transactionId, String methodStr, MadParamReq madParamReq, Class<T> c) {
        log.info("\u53d1\u8d77his\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + madParamReq);
        String object = new CxfClientUtil().madSend(this.madUrl, methodStr, madParamReq);
        log.info("his\u54cd\u5e94\u7ed3\u679c\uff0c\u53c2\u6570\uff1a" + object);
        if (StringUtils.isEmpty((CharSequence)object)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        Object t = JSON.parseObject((String)JSON.parse((String)object).toString(), c);
        if (null == t) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)t));
        return FrontResponse.success((String)transactionId, (Object)t);
    }

    public <T> FrontResponse<T> requestHisDebug(String transactionId, String methodStr, Map map, Class<T> c) {
        String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("\u53d1\u8d77his\u8bf7\u6c42\uff0c\u53c2\u6570\uff1a" + requestHisXml);
        String responseHisXml = XmlTemplateKit.processDebug((String)methodStr);
        log.info("his\u54cd\u5e94\u7ed3\u679c\uff0c\u53c2\u6570\uff1a" + responseHisXml);
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, c);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    static {
        XmlTemplateKit.init();
    }
}

