/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.core.config.NodeConfig;
import com.ebaiyihui.his.core.dto.medicaladvice.OpOrderInfoListDTO;
import com.ebaiyihui.his.core.dto.medicaladvice.WestdiaDTO;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.service.medicaladvice.MedicalAdviceService;
import com.ebaiyihui.his.core.vo.medicaladvice.CommonRes;
import com.ebaiyihui.his.core.vo.medicaladvice.DeleteMedicalAdviceReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DiagnoseDeleteReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DiagnoseSaveReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugFrequencyReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugFrequencyRes;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugItemListReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugItemListRes;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugItemReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugItemRes;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugStoreCountReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugStoreCountRes;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugUsageReq;
import com.ebaiyihui.his.core.vo.medicaladvice.DrugUsageRes;
import com.ebaiyihui.his.core.vo.medicaladvice.MadParamReq;
import com.ebaiyihui.his.core.vo.medicaladvice.MadSequenceReq;
import com.ebaiyihui.his.core.vo.medicaladvice.MedicalAdviceListReq;
import com.ebaiyihui.his.core.vo.medicaladvice.MedicalAdviceListRes;
import com.ebaiyihui.his.core.vo.medicaladvice.SaveMedicalAdviceReq;
import com.ebaiyihui.his.core.vo.medicaladvice.WestdiaQueryReq;
import com.ebaiyihui.his.core.vo.medicaladvice.WestdiaQueryRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MedicalAdviceServiceImpl
implements MedicalAdviceService {
    private static final Logger log = LoggerFactory.getLogger(MedicalAdviceServiceImpl.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<MedicalAdviceListRes> getMedicalAdviceList(FrontRequest<MedicalAdviceListReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setPatientId(((MedicalAdviceListReq)param.getBody()).getPatientId());
        madParamReq.setClinicNo(((MedicalAdviceListReq)param.getBody()).getClinicNo());
        madParamReq.setRecipeNo(((MedicalAdviceListReq)param.getBody()).getRecipeNo());
        madParamReq.setComboNo(((MedicalAdviceListReq)param.getBody()).getComboNo());
        madParamReq.setOrderId(((MedicalAdviceListReq)param.getBody()).getOrderId());
        log.info("=======\u67e5\u8be2\u533b\u5631\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Ensemble", madParamReq, MedicalAdviceListRes.class);
        log.info("=======\u67e5\u8be2\u533b\u5631\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((MedicalAdviceListRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((MedicalAdviceListRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<String> saveMedicalAdvice(FrontRequest<SaveMedicalAdviceReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setJsonString(JSON.toJSONString((Object)param.getBody()));
        log.info("=======\u4fdd\u5b58\u533b\u5631\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "ExecuteSave", madParamReq, CommonRes.class);
        log.info("=======\u4fdd\u5b58\u533b\u5631\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((CommonRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((CommonRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)((CommonRes)response.getBody()).getData());
    }

    public FrontResponse<String> deleteMedicalAdvice(FrontRequest<DeleteMedicalAdviceReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setJsonString(JSON.toJSONString((Object)param.getBody()));
        log.info("=======\u5220\u9664\u533b\u5631\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Executedelete", madParamReq, CommonRes.class);
        log.info("=======\u5220\u9664\u533b\u5631\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((CommonRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((CommonRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)((CommonRes)response.getBody()).getMessage());
    }

    public FrontResponse<DrugStoreCountRes> getDrugStoreCount(FrontRequest<DrugStoreCountReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setDrugId(((DrugStoreCountReq)param.getBody()).getDrugId());
        log.info("=======\u836f\u54c1\u5e93\u5b58\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "PharmacyListID", madParamReq, DrugStoreCountRes.class);
        log.info("=======\u836f\u54c1\u5e93\u5b58\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((DrugStoreCountRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((DrugStoreCountRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<DrugItemRes> getdrugMadItem(FrontRequest<DrugItemReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setDrugId(((DrugItemReq)param.getBody()).getDrugtermId());
        log.info("=======\u836f\u54c1\u8be6\u60c5\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Drugdetails", madParamReq, DrugItemRes.class);
        log.info("=======\u836f\u54c1\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((DrugItemRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((DrugItemRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<DrugItemListRes> getDrugItemList(FrontRequest<DrugItemListReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setTermClassId(((DrugItemListReq)param.getBody()).getTermClassId());
        log.info("=======\u836f\u54c1\u5217\u8868\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Medications", madParamReq, DrugItemListRes.class);
        log.info("=======\u836f\u54c1\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((DrugItemListRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((DrugItemListRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<DrugFrequencyRes> getDrugFrequency(FrontRequest<DrugFrequencyReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setFreqCode(((DrugFrequencyReq)param.getBody()).getFreqCode());
        log.info("=======\u836f\u54c1\u9891\u6b21\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Frequency", madParamReq, DrugFrequencyRes.class);
        log.info("=======\u836f\u54c1\u9891\u6b21\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((DrugFrequencyRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((DrugFrequencyRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<DrugUsageRes> getDrugUsage(FrontRequest<DrugUsageReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setValidState(((DrugUsageReq)param.getBody()).getValidState());
        log.info("=======\u836f\u54c1\u7528\u6cd5\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Usage", madParamReq, DrugUsageRes.class);
        log.info("=======\u836f\u54c1\u7528\u6cd5\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((DrugUsageRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((DrugUsageRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<OpOrderInfoListDTO> drugToOrder(FrontRequest<DrugItemReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setDrugId(((DrugItemReq)param.getBody()).getDrugtermId());
        log.info("=======\u533b\u5631\u5b9e\u4f53\u8f6c\u6362\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Conversion", madParamReq, OpOrderInfoListDTO.class);
        log.info("=======\u533b\u5631\u5b9e\u4f53\u8f6c\u6362\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((OpOrderInfoListDTO)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((OpOrderInfoListDTO)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response.getBody());
    }

    public FrontResponse<String> getMadSequence() {
        FrontResponse response = this.hisRemoteService.requestMadHis("", "Sequence", null, MadSequenceReq.class);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)"", (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((MadSequenceReq)response.getBody()).getCode())) {
            return FrontResponse.error((String)"", (String)"0", (String)((MadSequenceReq)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)"", (Object)((MadSequenceReq)response.getBody()).getData());
    }

    public FrontResponse<String> diagnoseeSave(FrontRequest<DiagnoseSaveReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setJsonString(JSON.toJSONString((Object)((DiagnoseSaveReq)param.getBody()).getList()));
        log.info("=======\u4fdd\u5b58\u8bca\u65ad\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "DiagnoseeSave", madParamReq, CommonRes.class);
        log.info("=======\u4fdd\u5b58\u8bca\u65ad\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((CommonRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((CommonRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)((CommonRes)response.getBody()).getData());
    }

    public FrontResponse<String> diagdelete(FrontRequest<DiagnoseDeleteReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setJsonString(JSON.toJSONString((Object)((DiagnoseDeleteReq)param.getBody()).getDiagnoseIds()));
        log.info("=======\u5220\u9664\u8bca\u65ad\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Diagdelete", madParamReq, CommonRes.class);
        log.info("=======\u5220\u9664\u8bca\u65ad\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((CommonRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((CommonRes)response.getBody()).getMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)((CommonRes)response.getBody()).getData());
    }

    public FrontResponse<WestdiaDTO> westdiaQuery(FrontRequest<WestdiaQueryReq> param) {
        MadParamReq madParamReq = new MadParamReq();
        madParamReq.setKeyWord(((WestdiaQueryReq)param.getBody()).getKeyWord());
        log.info("=======\u67e5\u8be2\u8bca\u65ad\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)madParamReq);
        FrontResponse response = this.hisRemoteService.requestMadHis(param.getTransactionId(), "Westdiaquery", madParamReq, WestdiaQueryRes.class);
        log.info("=======\u67e5\u8be2\u8bca\u65ad\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        if (null == response || null == response.getBody()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"200".equals(((WestdiaQueryRes)response.getBody()).getCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((WestdiaQueryRes)response.getBody()).getMessage());
        }
        List list = ((WestdiaQueryRes)response.getBody()).getData().getList();
        if (CollectionUtils.isEmpty(list = list.stream().filter(v -> Objects.equals(v.getWestDiseaseName(), ((WestdiaQueryReq)param.getBody()).getKeyWord())).collect(Collectors.toList()))) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u5230\u8be5\u8bca\u65ad");
        }
        return FrontResponse.success((String)param.getTransactionId(), list.get(0));
    }
}

