/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.ebaiyihui.his.core.constant.BaseConstant;
import com.ebaiyihui.his.core.dto.DeptInfoResDto;
import com.ebaiyihui.his.core.dto.DocSchduleItems;
import com.ebaiyihui.his.core.dto.DocSchduleResDTO;
import com.ebaiyihui.his.core.dto.schdule.NewDocSchduleItems;
import com.ebaiyihui.his.core.dto.schdule.NewDocSchduleResDTO;
import com.ebaiyihui.his.core.enums.AdmTimeArangeEnums;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.service.ScheduleService;
import com.ebaiyihui.his.core.utils.DateUtils;
import com.ebaiyihui.his.core.vo.DeptInfoResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    public static final List<String> MORNING_ADMRANGE = Arrays.asList("08:00-08:30", "08:30-09:00", "09:00-09:30", "09:30-10:00", "10:00-10:30", "10:30-11:00", "11:00-11:30", "11:30-12:00");
    public static final List<String> AFTERNOON_ADMRANGE = Arrays.asList("13:00-13:30", "13:30-14:00", "14:00-14:30", "14:30-15:00", "14:00-14:30", "14:30-15:00", "15:00-15:30", "15:30-16:00", "16:00-16:30");
    public static final List<String> SPECIAL_AFTERNOON_ADMRANGE = Arrays.asList("13:00-13:30", "13:30-14:00", "14:00-14:30", "14:30-15:00", "14:00-14:30", "14:30-15:00", "15:00-15:30", "15:30-16:00");
    @Value(value="${hosp.hospCode}")
    private String hospCode;
    @Value(value="${hosp.hospName}")
    private String hospName;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
        ArrayList<GetDeptScheduleResItems> items = new ArrayList<GetDeptScheduleResItems>();
        FrontResponse deptInfoResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_DEPT_INFO.getValue(), new HashMap(), DeptInfoResDto.class);
        DeptInfoResDto deptInfoResDto = (DeptInfoResDto)deptInfoResponse.getBody();
        if (null == deptInfoResDto) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(deptInfoResDto.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        List deptInfoResVoList = deptInfoResDto.getDept().getDeptInfoResVoList();
        for (DeptInfoResVo deptInfoResVo : deptInfoResVoList) {
            GetDeptScheduleResItems getDeptScheduleResItems = new GetDeptScheduleResItems();
            getDeptScheduleResItems.setDeptCode(deptInfoResVo.getDeptCode());
            getDeptScheduleResItems.setDeptName(deptInfoResVo.getName());
            getDeptScheduleResItems.setDeptAddress(deptInfoResVo.getAddress());
            items.add(getDeptScheduleResItems);
        }
        getDeptScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
    }

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        List<Object> items = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(RequestEntityEnum.DOC_SCHDULE.getValue(), param.getBody());
        FrontResponse schduleResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DOC_SCHDULE.getValue(), map, DocSchduleResDTO.class);
        DocSchduleResDTO schduleResDTOBody = (DocSchduleResDTO)schduleResDTO.getBody();
        if (null == schduleResDTOBody) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(schduleResDTOBody.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if (null == schduleResDTOBody.getItemsList()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        List schduleItems = schduleResDTOBody.getItemsList().getItems();
        if (CollectionUtils.isEmpty((Collection)schduleItems)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u6392\u73ed\u6570\u636e");
        }
        for (DocSchduleItems schduleItem : schduleItems) {
            GetScheduleResItems getScheduleResItems2 = new GetScheduleResItems();
            BeanUtils.copyProperties((Object)schduleItem, (Object)getScheduleResItems2);
            getScheduleResItems2.setScheduleStatus("1".equals(schduleItem.getVaildState()) ? "1" : "2");
            getScheduleResItems2.setRegAvailable(Integer.valueOf(Integer.valueOf(schduleItem.getRegTotal()) - Integer.valueOf(schduleItem.getPreReging())));
            getScheduleResItems2.setScheduleType(BaseConstant.DEFAULT);
            getScheduleResItems2.setIsAppend("0");
            getScheduleResItems2.setIsTimeArrange(BaseConstant.DEFAULT_NOT);
            getScheduleResItems2.setReplaceScheduleId(schduleItem.getScheduleId());
            getScheduleResItems2.setAdmDate(schduleItem.getAdmDate().replace("/", "-"));
            getScheduleResItems2.setAdmTimeRange(AdmTimeArangeEnums.getDisplay((String)schduleItem.getAdmTimeRange()));
            getScheduleResItems2.setRegTotal(Integer.valueOf(schduleItem.getRegTotal()));
            getScheduleResItems2.setHospitalArea(this.hospName);
            getScheduleResItems2.setHospitalAreaCode(this.hospCode);
            getScheduleResItems2.setScheduleLevelCode(schduleItem.getRegTitleCode());
            getScheduleResItems2.setScheduleLevelName(schduleItem.getRegTitleName());
            getScheduleResItems2.setLocTypeCode(schduleItem.getLocCode());
            getScheduleResItems2.setLocTypeName(schduleItem.getLocName());
            ArrayList<TimeArrangeItems> list = new ArrayList<TimeArrangeItems>();
            if (!StringUtils.isBlank((CharSequence)schduleItem.getYpreTime())) {
                String[] split = schduleItem.getYpreTime().split(",");
                for (int i = 1; i <= split.length; ++i) {
                    TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
                    timeArrangeItems.setStartNo(Integer.valueOf(i));
                    timeArrangeItems.setEndNo(Integer.valueOf(i));
                    timeArrangeItems.setTimeArrangeId(String.valueOf(i));
                    timeArrangeItems.setStartTime(split[i - 1]);
                    timeArrangeItems.setEndTime(split[i - 1]);
                    list.add(timeArrangeItems);
                }
            }
            getScheduleResItems2.setTimeArrangeItems(list);
            items.add(getScheduleResItems2);
        }
        if (null != param.getBody() && StringUtils.isNotEmpty((CharSequence)((GetScheduleReqVO)param.getBody()).getDocCode())) {
            items = items.stream().filter(getScheduleResItems -> ((GetScheduleReqVO)param.getBody()).getDocCode().equals(getScheduleResItems.getDocCode())).collect(Collectors.toList());
        }
        getScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    public FrontResponse<GetScheduleResVO> getNewSchedule(FrontRequest<GetScheduleReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        List<Object> items = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(RequestEntityEnum.DOC_SCHDULE.getValue(), param.getBody());
        FrontResponse schduleResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.NEW_QUERY_DOC_SCHDULE.getValue(), map, NewDocSchduleResDTO.class);
        NewDocSchduleResDTO schduleResDTOBody = (NewDocSchduleResDTO)schduleResDTO.getBody();
        if (null == schduleResDTOBody) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(schduleResDTOBody.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if (null == schduleResDTOBody.getItemsList()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        List schduleItems = schduleResDTOBody.getItemsList().getItems();
        if (CollectionUtils.isEmpty((Collection)schduleItems)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u6392\u73ed\u6570\u636e");
        }
        if ("1024".equals(((GetScheduleReqVO)param.getBody()).getLocCode())) {
            schduleItems = schduleItems.stream().filter(newDocSchduleItems -> "600007".equals(newDocSchduleItems.getDocCode())).collect(Collectors.toList());
        }
        for (NewDocSchduleItems schduleItem : schduleItems) {
            TimeArrangeItems timeArrangeItems;
            List timeDifference;
            ArrayList newTimeList;
            String endTime;
            String startTime;
            int i;
            Integer regAvailable = Integer.valueOf(schduleItem.getRegTotal()) - Integer.valueOf(schduleItem.getPreReging());
            if (regAvailable <= 0) continue;
            ArrayList sourceList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)schduleItem.getPreTime())) {
                String[] splitPreTime = schduleItem.getPreTime().split(",");
                ArrayList listPreTime = new ArrayList(splitPreTime.length);
                Collections.addAll(listPreTime, splitPreTime);
                if (StringUtils.isBlank((CharSequence)schduleItem.getYpreTime())) {
                    sourceList.addAll(listPreTime);
                } else {
                    String[] splitYpreTime = schduleItem.getYpreTime().split("\u3001");
                    ArrayList listYpreTime = new ArrayList(splitYpreTime.length);
                    Collections.addAll(listYpreTime, splitYpreTime);
                    this.listRemove(listPreTime, listYpreTime, sourceList);
                }
            }
            if (CollectionUtils.isEmpty(sourceList)) continue;
            GetScheduleResItems getScheduleResItems2 = new GetScheduleResItems();
            BeanUtils.copyProperties((Object)schduleItem, (Object)getScheduleResItems2);
            getScheduleResItems2.setScheduleStatus("1".equals(schduleItem.getVaildState()) ? "1" : "2");
            getScheduleResItems2.setRegAvailable(regAvailable);
            getScheduleResItems2.setScheduleType(BaseConstant.DEFAULT);
            getScheduleResItems2.setIsAppend("0");
            getScheduleResItems2.setIsTimeArrange(BaseConstant.DEFAULT_NOT);
            getScheduleResItems2.setReplaceScheduleId(schduleItem.getScheduleId());
            getScheduleResItems2.setAdmDate(schduleItem.getAdmDate().replace("/", "-"));
            getScheduleResItems2.setAdmTimeRange(AdmTimeArangeEnums.getDisplay((String)schduleItem.getAdmTimeRange()));
            getScheduleResItems2.setRegTotal(Integer.valueOf(schduleItem.getRegTotal()));
            getScheduleResItems2.setHospitalArea(this.hospName);
            getScheduleResItems2.setHospitalAreaCode(this.hospCode);
            getScheduleResItems2.setScheduleLevelCode(schduleItem.getRegTitleCode());
            getScheduleResItems2.setScheduleLevelName(schduleItem.getRegTitleName());
            getScheduleResItems2.setDiagFee("0.00");
            getScheduleResItems2.setAdmLocation(schduleItem.getLocName());
            getScheduleResItems2.setLocTypeCode(schduleItem.getLocCode());
            getScheduleResItems2.setLocTypeName(schduleItem.getLocName());
            ArrayList<TimeArrangeItems> list = new ArrayList<TimeArrangeItems>();
            if (AdmTimeArangeEnums.MORNING.getValue().equals(schduleItem.getAdmTimeRange())) {
                for (String timeRange : MORNING_ADMRANGE) {
                    i = 1;
                    startTime = timeRange.substring(0, 5) + ":00";
                    endTime = timeRange.substring(6) + ":00";
                    newTimeList = new ArrayList();
                    try {
                        timeDifference = DateUtils.getTimeRangeList((String)endTime, (String)startTime);
                        ScheduleServiceImpl.listIntersection(sourceList, (List)timeDifference, newTimeList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    timeArrangeItems = new TimeArrangeItems();
                    timeArrangeItems.setStartNo(Integer.valueOf(1));
                    timeArrangeItems.setEndNo(Integer.valueOf(newTimeList.size()));
                    timeArrangeItems.setTimeArrangeId(String.valueOf(i));
                    timeArrangeItems.setStartTime(timeRange.substring(0, 5));
                    timeArrangeItems.setEndTime(timeRange.substring(6));
                    timeArrangeItems.setBookedNos(StringUtils.join(newTimeList, (String)","));
                    list.add(timeArrangeItems);
                    ++i;
                }
            }
            if ("6015".equals(((GetScheduleReqVO)param.getBody()).getLocCode())) {
                if (AdmTimeArangeEnums.AFTERNOON.getValue().equals(schduleItem.getAdmTimeRange())) {
                    for (String timeRange : SPECIAL_AFTERNOON_ADMRANGE) {
                        i = 11;
                        startTime = timeRange.substring(0, 5) + ":00";
                        endTime = timeRange.substring(6) + ":00";
                        newTimeList = new ArrayList();
                        try {
                            timeDifference = DateUtils.getTimeRangeList((String)endTime, (String)startTime);
                            ScheduleServiceImpl.listIntersection(sourceList, (List)timeDifference, newTimeList);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        timeArrangeItems = new TimeArrangeItems();
                        timeArrangeItems.setStartNo(Integer.valueOf(1));
                        timeArrangeItems.setEndNo(Integer.valueOf(newTimeList.size()));
                        timeArrangeItems.setTimeArrangeId(String.valueOf(i));
                        timeArrangeItems.setStartTime(timeRange.substring(0, 5));
                        timeArrangeItems.setEndTime(timeRange.substring(6));
                        timeArrangeItems.setBookedNos(StringUtils.join(newTimeList, (String)","));
                        list.add(timeArrangeItems);
                        ++i;
                    }
                }
            } else if (AdmTimeArangeEnums.AFTERNOON.getValue().equals(schduleItem.getAdmTimeRange())) {
                for (String timeRange : AFTERNOON_ADMRANGE) {
                    i = 11;
                    startTime = timeRange.substring(0, 5) + ":00";
                    endTime = timeRange.substring(6) + ":00";
                    newTimeList = new ArrayList();
                    try {
                        timeDifference = DateUtils.getTimeRangeList((String)endTime, (String)startTime);
                        ScheduleServiceImpl.listIntersection(sourceList, (List)timeDifference, newTimeList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    timeArrangeItems = new TimeArrangeItems();
                    timeArrangeItems.setStartNo(Integer.valueOf(1));
                    timeArrangeItems.setEndNo(Integer.valueOf(newTimeList.size()));
                    timeArrangeItems.setTimeArrangeId(String.valueOf(i));
                    timeArrangeItems.setStartTime(timeRange.substring(0, 5));
                    timeArrangeItems.setEndTime(timeRange.substring(6));
                    timeArrangeItems.setBookedNos(StringUtils.join(newTimeList, (String)","));
                    list.add(timeArrangeItems);
                    ++i;
                }
            }
            getScheduleResItems2.setTimeArrangeItems(list);
            items.add(getScheduleResItems2);
        }
        if (null != param.getBody() && StringUtils.isNotEmpty((CharSequence)((GetScheduleReqVO)param.getBody()).getDocCode())) {
            items = items.stream().filter(getScheduleResItems -> ((GetScheduleReqVO)param.getBody()).getDocCode().equals(getScheduleResItems.getDocCode())).collect(Collectors.toList());
        }
        getScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    private List<String> listRemove(List<String> listA, List<String> listB, List<String> listC) {
        HashSet<String> hs1 = new HashSet<String>(listA);
        HashSet<String> hs2 = new HashSet<String>(listB);
        hs1.removeAll(hs2);
        listC.addAll(hs1);
        return listC;
    }

    private static List<String> listIntersection(List<String> listA, List<String> listB, List<String> listC) {
        HashSet<String> hs1 = new HashSet<String>(listA);
        HashSet<String> hs2 = new HashSet<String>(listB);
        hs1.retainAll(hs2);
        listC.addAll(hs1);
        return listC;
    }
}

