/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.ebaiyihui.his.core.dto.RegisteredRecordResDTO;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.service.SettlementService;
import com.ebaiyihui.his.core.vo.GetPrescriptionStatusReqVo;
import com.ebaiyihui.his.core.vo.GetPrescriptionStatusResVo;
import com.ebaiyihui.his.core.vo.GetPriceInfoReqVo;
import com.ebaiyihui.his.core.vo.GetPriceInfoResVo;
import com.ebaiyihui.his.core.vo.PrescriptionPreSettlementReqVo;
import com.ebaiyihui.his.core.vo.PrescriptionPreSettlementResVo;
import com.ebaiyihui.his.core.vo.PrescriptionStatusItemResVO;
import com.ebaiyihui.his.core.vo.PriceInfoFeeItemsResVO;
import com.ebaiyihui.his.core.vo.RegisteredRecordNewResVo;
import com.ebaiyihui.his.core.vo.RegisteredRecordReqVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettlementServiceImpl
implements SettlementService {
    private static final Logger log = LoggerFactory.getLogger(SettlementServiceImpl.class);
    private static final String OUTPATIENT_WAITING_PAY = "0";
    private static final String OUTPATIENT_PAIED = "1";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        HashMap<String, RegisteredRecordReqVo> map = new HashMap<String, RegisteredRecordReqVo>(1);
        RegisteredRecordReqVo recordReqVo = new RegisteredRecordReqVo();
        recordReqVo.setPatientIdCard(((GetAdmissionReq)param.getBody()).getCardNo());
        recordReqVo.setState(OUTPATIENT_WAITING_PAY);
        map.put(RequestEntityEnum.GET_OUTPATIENT_RECORD.getValue(), recordReqVo);
        FrontResponse registeredRecordResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_OUTPATIENT_RECORD.getValue(), map, RegisteredRecordResDTO.class);
        RegisteredRecordResDTO registeredRecordResDTO = (RegisteredRecordResDTO)registeredRecordResponse.getBody();
        if (null == registeredRecordResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!OUTPATIENT_PAIED.equals(registeredRecordResDTO.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)registeredRecordResponse.getMessage());
        }
        List registeredRecordNewResVoList = registeredRecordResDTO.getRegisteredRecordResVoList();
        ArrayList<GetAdmissionItems> items = new ArrayList<GetAdmissionItems>();
        for (RegisteredRecordNewResVo registeredRecordNewResVo : registeredRecordNewResVoList) {
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            getAdmissionItems.setAdmId(registeredRecordNewResVo.getClinicNO());
            getAdmissionItems.setAdmType("O");
            getAdmissionItems.setAge(registeredRecordNewResVo.getAge());
            getAdmissionItems.setSex(registeredRecordNewResVo.getSex());
            getAdmissionItems.setAdmDate(registeredRecordNewResVo.getRegDate());
            getAdmissionItems.setAdmStatus("2");
            getAdmissionItems.setDeptCode(registeredRecordNewResVo.getDeptCode());
            getAdmissionItems.setDeptName(registeredRecordNewResVo.getDeptName());
            getAdmissionItems.setName(registeredRecordNewResVo.getName());
            getAdmissionItems.setDocCode(registeredRecordNewResVo.getDoctCode());
            getAdmissionItems.setDocName(registeredRecordNewResVo.getDoctName());
            getAdmissionItems.setPatientId(registeredRecordNewResVo.getCardNo());
            items.add(getAdmissionItems);
        }
        getAdmissionRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<GetPriceInfoResVo> getPriceInfo(FrontRequest<GetPriceInfoReqVo> req) {
        HashMap<String, GetPriceInfoReqVo> map = new HashMap<String, GetPriceInfoReqVo>(1);
        GetPriceInfoReqVo getPriceInfoReqVo = (GetPriceInfoReqVo)req.getBody();
        log.info("getPriceInfo\u5165\u53c2:" + getPriceInfoReqVo.toString());
        map.put(RequestEntityEnum.GET_PRICE_INFO.getValue(), getPriceInfoReqVo);
        FrontResponse getPriceInfoRes = this.hisRemoteService.requestHis(req.getTransactionId(), MethodCodeEnum.GET_PRICE_INFO.getValue(), map, GetPriceInfoResVo.class);
        GetPriceInfoResVo getPriceInfoResBody = (GetPriceInfoResVo)getPriceInfoRes.getBody();
        if (null == getPriceInfoResBody) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(getPriceInfoResBody.getResult())) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        PriceInfoFeeItemsResVO feeItems = getPriceInfoResBody.getFeeItems();
        if (null == feeItems) {
            return FrontResponse.success((String)req.getTransactionId(), null);
        }
        return FrontResponse.success((String)req.getTransactionId(), (Object)getPriceInfoResBody);
    }

    public FrontResponse<PrescriptionPreSettlementResVo> prescriptionPreSettlement(FrontRequest<PrescriptionPreSettlementReqVo> req) {
        HashMap<String, PrescriptionPreSettlementReqVo> map = new HashMap<String, PrescriptionPreSettlementReqVo>(1);
        PrescriptionPreSettlementReqVo reqBody = (PrescriptionPreSettlementReqVo)req.getBody();
        log.info("\u5904\u65b9\u9884\u7ed3\u7b97prescriptionPreSettlement:" + reqBody.toString());
        map.put(RequestEntityEnum.PRE_SETTLEMENT.getValue(), reqBody);
        FrontResponse getPriceInfoRes = this.hisRemoteService.requestHis(req.getTransactionId(), MethodCodeEnum.PRESCRIPTION_PRESETTLEMENT.getValue(), map, PrescriptionPreSettlementResVo.class);
        PrescriptionPreSettlementResVo resBody = (PrescriptionPreSettlementResVo)getPriceInfoRes.getBody();
        if (null == resBody) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(resBody.getResult())) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        return FrontResponse.success((String)req.getTransactionId(), (Object)resBody);
    }

    public FrontResponse<PrescriptionPreSettlementResVo> prescriptionSettlement(FrontRequest<PrescriptionPreSettlementReqVo> req) {
        HashMap<String, PrescriptionPreSettlementReqVo> map = new HashMap<String, PrescriptionPreSettlementReqVo>(1);
        PrescriptionPreSettlementReqVo reqBody = (PrescriptionPreSettlementReqVo)req.getBody();
        log.info("\u5904\u65b9\u7ed3\u7b97prescriptionSettlement:" + reqBody.toString());
        map.put(RequestEntityEnum.SETTLEMENT.getValue(), reqBody);
        FrontResponse getPriceInfoRes = this.hisRemoteService.requestHis(req.getTransactionId(), MethodCodeEnum.PRESCRIPTION_SETTLEMENT.getValue(), map, PrescriptionPreSettlementResVo.class);
        PrescriptionPreSettlementResVo resBody = (PrescriptionPreSettlementResVo)getPriceInfoRes.getBody();
        if (null == resBody) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(resBody.getResult())) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        return FrontResponse.success((String)req.getTransactionId(), (Object)resBody);
    }

    public FrontResponse<PrescriptionStatusItemResVO> getPrescriptionStatus(FrontRequest<GetPrescriptionStatusReqVo> req) {
        HashMap<String, GetPrescriptionStatusReqVo> map = new HashMap<String, GetPrescriptionStatusReqVo>(1);
        GetPrescriptionStatusReqVo reqBody = (GetPrescriptionStatusReqVo)req.getBody();
        log.info("\u67e5\u8be2\u5904\u65b9\u72b6\u6001getPrescriptionStatus:" + reqBody.toString());
        map.put(RequestEntityEnum.PRESCRIPTION_STATUS.getValue(), reqBody);
        FrontResponse getPrescriptionStatusRes = this.hisRemoteService.requestHis(req.getTransactionId(), MethodCodeEnum.PRESCRIPTION_STATUS.getValue(), map, GetPrescriptionStatusResVo.class);
        GetPrescriptionStatusResVo resBody = (GetPrescriptionStatusResVo)getPrescriptionStatusRes.getBody();
        if (null == resBody) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(resBody.getResult())) {
            return FrontResponse.error((String)req.getTransactionId(), (String)OUTPATIENT_WAITING_PAY, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        PrescriptionStatusItemResVO prescriptionStatusItemResVO = resBody.getPrescriptionStatusItemResVO();
        return FrontResponse.success((String)req.getTransactionId(), (Object)prescriptionStatusItemResVO);
    }
}

